/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.icb;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.instrument.AdaptorInfo;
import com.mathworks.toolbox.instrument.icb.IJFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;

public class HardwarePanel
extends MJPanel {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_PROTOCOL = -1;
    public static final int SERIAL = 0;
    public static final int GPIB = 1;
    public static final int VISA_SERIAL = 2;
    public static final int VISA_GPIB = 3;
    public static final int VISA_TCPIP = 4;
    public static final int VISA_USB = 5;
    public static final int VISA_VXI = 6;
    public static final int VISA_VXI_GPIB = 7;
    public static final int TCPIP = 8;
    public static final int UDP = 9;
    public static final int VISA_PXI = 10;
    public static final String[] PROTOCOLS = new String[]{"Serial", "GPIB", "VISA Serial", "VISA GPIB", "VISA TCPIP", "VISA USB", "VISA VXI", "VISA GPIB-VXI", "TCPIP", "UDP", "VISA VXI"};
    public static final String[] SERIAL_PORTS = new String[]{"COM1", "COM2", "COM3", "COM4"};
    public static final String[] VISA_VENDORS = new String[]{"Agilent", "National Instruments", "Tektronix"};
    private int selectedProtocol = -1;
    private MJRadioButton slVariableRadio;
    private MJLabel timeoutLabel;
    private MJTextField timeout;
    private MJLabel inputBufferSizeLabel;
    private MJTextField inputBufferSize;
    private MJLabel protocolLabel;
    private MJComboBox protocol;
    private MJLabel serialPortLabel;
    private MJComboBox serialPort;
    private MJLabel baudrateLabel;
    private MJTextField baudRate;
    private MJLabel gpibVendorLabel;
    private MJComboBox gpibVendor;
    private MJLabel boardIndexLabel;
    private MJTextField boardIndex;
    private MJLabel primaryAddressLabel;
    private MJTextField primaryAddress;
    private MJLabel secondaryAddressLabel;
    private MJTextField secondaryAddress;
    private MJLabel visaVendorLabel;
    private MJComboBox visaVendor;
    private MJTextField visaSerialPort;
    private MJLabel chassisIndexLabel;
    private MJTextField chassisIndex;
    private MJLabel logicalAddressLabel;
    private MJTextField logicalAddress;
    private MJLabel busNumber;
    private MJTextField busNumberLabel;
    private MJLabel deviceNumber;
    private MJTextField deviceNumberLabel;
    private MJLabel functionNumber;
    private MJTextField functionNumberLabel;
    private MJLabel visaTCPBoardIndexLabel;
    private MJTextField visaTCPBoardIndex;
    private MJLabel visaTCPRemoteHostLabel;
    private MJTextField visaTCPRemoteHost;
    private MJLabel visaUSBBoardIndexLabel;
    private MJTextField visaUSBBoardIndex;
    private MJLabel visaUSBManufacturerIDLabel;
    private MJTextField visaUSBManufacturerID;
    private MJLabel visaUSBModelCodeLabel;
    private MJTextField visaUSBModelCode;
    private MJLabel visaUSBSerialNumberLabel;
    private MJTextField visaUSBSerialNumber;
    private MJLabel tcpudpRemoteHostLabel;
    private MJLabel tcpudpRemotePortLabel;
    private MJTextField tcpRemoteHost;
    private MJTextField tcpRemotePort;
    private MJTextField udpRemoteHost;
    private MJTextField udpRemotePort;
    private MJRadioButton wsVariableRadio;
    private MJLabel wsVariableNameLabel;
    private MJTextField wsVariableName;
    private MJPanel hwPanel;

    public HardwarePanel() {
        this.initComponents();
    }

    private void initComponents() {
        int n;
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.slVariableRadio = new MJRadioButton();
        this.slVariableRadio.setText("Specify new hardware configuration");
        buttonGroup.add((AbstractButton)this.slVariableRadio);
        this.slVariableRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                HardwarePanel.this.slVariableRadioItemStateChanged(itemEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.slVariableRadio, gridBagConstraints);
        this.hwPanel = new MJPanel((LayoutManager)new GridBagLayout());
        this.hwPanel.setBorder((Border)BorderFactory.createTitledBorder(""));
        this.timeoutLabel = new MJLabel("Timeout:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.timeoutLabel, (Object)gridBagConstraints);
        this.timeout = new MJTextField();
        this.timeout.setColumns(IJFrame.sSmallColumnWidth);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.timeout, (Object)gridBagConstraints);
        this.inputBufferSizeLabel = new MJLabel("Buffer size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.inputBufferSizeLabel, (Object)gridBagConstraints);
        this.inputBufferSize = new MJTextField();
        this.inputBufferSize.setColumns(IJFrame.sSmallColumnWidth);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.inputBufferSize, (Object)gridBagConstraints);
        this.protocolLabel = new MJLabel("Interface:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.protocolLabel, (Object)gridBagConstraints);
        this.protocol = new MJComboBox();
        for (n = 0; n < PROTOCOLS.length; ++n) {
            this.protocol.addItem((Object)new String(PROTOCOLS[n]));
        }
        this.protocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HardwarePanel.this.protocolActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.protocol, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.hwPanel, gridBagConstraints);
        this.serialPortLabel = new MJLabel("Port:");
        this.serialPort = new MJComboBox();
        for (n = 0; n < SERIAL_PORTS.length; ++n) {
            this.serialPort.addItem((Object)new String(SERIAL_PORTS[n]));
        }
        this.baudrateLabel = new MJLabel("Baudrate:");
        this.baudRate = new MJTextField();
        this.baudRate.setColumns(IJFrame.sSmallColumnWidth);
        this.gpibVendorLabel = new MJLabel("Board vendor:");
        this.gpibVendor = new MJComboBox();
        for (n = 0; n < AdaptorInfo.GPIB_NAMES.length; ++n) {
            this.gpibVendor.addItem((Object)AdaptorInfo.GPIB_NAMES[n]);
        }
        this.boardIndexLabel = new MJLabel("Board index:");
        this.boardIndex = new MJTextField();
        this.boardIndex.setColumns(IJFrame.sSmallColumnWidth);
        this.primaryAddressLabel = new MJLabel("Primary address:");
        this.primaryAddress = new MJTextField();
        this.primaryAddress.setColumns(IJFrame.sSmallColumnWidth);
        this.secondaryAddressLabel = new MJLabel("Secondary address:");
        this.secondaryAddress = new MJTextField();
        this.secondaryAddress.setColumns(IJFrame.sSmallColumnWidth);
        this.visaVendorLabel = new MJLabel("VISA vendor:");
        this.visaVendor = new MJComboBox();
        for (n = 0; n < VISA_VENDORS.length; ++n) {
            this.visaVendor.addItem((Object)new String(VISA_VENDORS[n]));
        }
        this.visaSerialPort = new MJTextField();
        this.visaSerialPort.setColumns(IJFrame.sSmallColumnWidth);
        this.chassisIndexLabel = new MJLabel("Chassis index:");
        this.chassisIndex = new MJTextField();
        this.chassisIndex.setColumns(IJFrame.sSmallColumnWidth);
        this.logicalAddressLabel = new MJLabel("Logical address:");
        this.logicalAddress = new MJTextField();
        this.logicalAddress.setColumns(IJFrame.sSmallColumnWidth);
        this.visaTCPBoardIndexLabel = new MJLabel("Board index:");
        this.visaTCPBoardIndex = new MJTextField();
        this.visaTCPBoardIndex.setColumns(IJFrame.sSmallColumnWidth);
        this.visaTCPRemoteHostLabel = new MJLabel("Remote host:");
        this.visaTCPRemoteHost = new MJTextField();
        this.visaUSBBoardIndexLabel = new MJLabel("Board index:");
        this.visaUSBBoardIndex = new MJTextField();
        this.visaUSBBoardIndex.setColumns(IJFrame.sSmallColumnWidth);
        this.visaUSBManufacturerIDLabel = new MJLabel("Manufacturer ID:");
        this.visaUSBManufacturerID = new MJTextField();
        this.visaUSBManufacturerID.setColumns(IJFrame.sSmallColumnWidth);
        this.visaUSBModelCodeLabel = new MJLabel("Model code:");
        this.visaUSBModelCode = new MJTextField();
        this.visaUSBModelCode.setColumns(IJFrame.sSmallColumnWidth);
        this.visaUSBSerialNumberLabel = new MJLabel("Serial number:");
        this.visaUSBSerialNumber = new MJTextField();
        this.visaUSBSerialNumber.setColumns(IJFrame.sSmallColumnWidth);
        this.tcpudpRemoteHostLabel = new MJLabel("Remote host:");
        this.tcpRemoteHost = new MJTextField();
        this.tcpudpRemotePortLabel = new MJLabel("Port:");
        this.tcpRemotePort = new MJTextField();
        this.tcpRemotePort.setColumns(IJFrame.sSmallColumnWidth);
        this.udpRemoteHost = new MJTextField();
        this.udpRemotePort = new MJTextField();
        this.udpRemotePort.setColumns(IJFrame.sSmallColumnWidth);
        this.wsVariableRadio = new MJRadioButton();
        this.wsVariableRadio.setText("Use interface object from MATLAB workspace");
        buttonGroup.add((AbstractButton)this.wsVariableRadio);
        this.wsVariableRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                HardwarePanel.this.wsVariableRadioItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.wsVariableRadio, gridBagConstraints);
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(""));
        this.wsVariableNameLabel = new MJLabel("Workspace object:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.wsVariableNameLabel, (Object)gridBagConstraints);
        this.wsVariableName = new MJTextField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)this.wsVariableName, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 5, 4);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)mJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new MJPanel(), gridBagConstraints);
        this.slVariableRadio.setSelected(true);
        this.disableWorkspaceObject();
        this.protocol.setSelectedIndex(0);
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.protocol.addActionListener(actionListener);
        this.serialPort.addActionListener(actionListener);
        this.gpibVendor.addActionListener(actionListener);
        this.visaVendor.addActionListener(actionListener);
    }

    public void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.slVariableRadio.addItemListener(itemListener);
        this.wsVariableRadio.addItemListener(itemListener);
    }

    public void addTextListener(DocumentListener documentListener) {
        if (documentListener == null) {
            return;
        }
        this.timeout.getDocument().addDocumentListener(documentListener);
        this.inputBufferSize.getDocument().addDocumentListener(documentListener);
        this.baudRate.getDocument().addDocumentListener(documentListener);
        this.boardIndex.getDocument().addDocumentListener(documentListener);
        this.primaryAddress.getDocument().addDocumentListener(documentListener);
        this.secondaryAddress.getDocument().addDocumentListener(documentListener);
        this.visaSerialPort.getDocument().addDocumentListener(documentListener);
        this.chassisIndex.getDocument().addDocumentListener(documentListener);
        this.logicalAddress.getDocument().addDocumentListener(documentListener);
        this.visaTCPBoardIndex.getDocument().addDocumentListener(documentListener);
        this.visaTCPRemoteHost.getDocument().addDocumentListener(documentListener);
        this.visaUSBBoardIndex.getDocument().addDocumentListener(documentListener);
        this.visaUSBManufacturerID.getDocument().addDocumentListener(documentListener);
        this.visaUSBModelCode.getDocument().addDocumentListener(documentListener);
        this.visaUSBSerialNumber.getDocument().addDocumentListener(documentListener);
        this.tcpRemoteHost.getDocument().addDocumentListener(documentListener);
        this.tcpRemotePort.getDocument().addDocumentListener(documentListener);
        this.udpRemoteHost.getDocument().addDocumentListener(documentListener);
        this.udpRemotePort.getDocument().addDocumentListener(documentListener);
        this.wsVariableName.getDocument().addDocumentListener(documentListener);
    }

    public int getParameterValues(String[] stringArray, String[] stringArray2, int n) {
        stringArray[n] = new String("isWorkspaceObject");
        stringArray2[n++] = new String(IJFrame.booleanToString(this.wsVariableRadio.isSelected()));
        stringArray[n] = new String("timeout");
        stringArray2[n++] = this.timeout.getText();
        stringArray[n] = new String("inputBufferSize");
        stringArray2[n++] = this.inputBufferSize.getText();
        stringArray[n] = new String("protocol");
        stringArray2[n++] = (String)this.protocol.getSelectedItem();
        stringArray[n] = new String("serialPort");
        stringArray2[n++] = (String)this.serialPort.getSelectedItem();
        stringArray[n] = new String("baudRate");
        stringArray2[n++] = this.baudRate.getText();
        stringArray[n] = new String("gpibVendor");
        stringArray2[n++] = (String)this.gpibVendor.getSelectedItem();
        stringArray[n] = new String("boardIndex");
        stringArray2[n++] = this.boardIndex.getText();
        stringArray[n] = new String("primaryAddress");
        stringArray2[n++] = this.primaryAddress.getText();
        stringArray[n] = new String("secondaryAddress");
        stringArray2[n++] = this.secondaryAddress.getText();
        stringArray[n] = new String("visaVendor");
        stringArray2[n++] = (String)this.visaVendor.getSelectedItem();
        stringArray[n] = new String("visaSerialPort");
        stringArray2[n++] = this.visaSerialPort.getText();
        stringArray[n] = new String("chassisIndex");
        stringArray2[n++] = this.chassisIndex.getText();
        stringArray[n] = new String("logicalAddress");
        stringArray2[n++] = this.logicalAddress.getText();
        stringArray[n] = new String("tcpRemoteHost");
        stringArray2[n++] = this.tcpRemoteHost.getText();
        stringArray[n] = new String("tcpRemotePort");
        stringArray2[n++] = this.tcpRemotePort.getText();
        stringArray[n] = new String("udpRemoteHost");
        stringArray2[n++] = this.udpRemoteHost.getText();
        stringArray[n] = new String("udpRemotePort");
        stringArray2[n++] = this.udpRemotePort.getText();
        stringArray[n] = new String("visaTCPBoardIndex");
        stringArray2[n++] = this.visaTCPBoardIndex.getText();
        stringArray[n] = new String("visaTCPRemoteHost");
        stringArray2[n++] = this.visaTCPRemoteHost.getText();
        stringArray[n] = new String("usbBoardIndex");
        stringArray2[n++] = this.visaUSBBoardIndex.getText();
        stringArray[n] = new String("usbManufID");
        stringArray2[n++] = this.visaUSBManufacturerID.getText();
        stringArray[n] = new String("usbModelCode");
        stringArray2[n++] = this.visaUSBModelCode.getText();
        stringArray[n] = new String("usbSerialNumber");
        stringArray2[n++] = this.visaUSBSerialNumber.getText();
        stringArray[n] = new String("wsVariableName");
        stringArray2[n++] = this.wsVariableName.getText();
        return n;
    }

    public void setParameterValues(String[] stringArray, String[] stringArray2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], stringArray2[i]);
        }
        this.setParameterValues(hashMap);
    }

    public void setParameterValues(Map<String, String> map) {
        if (map.get("isWorkspaceObject").compareToIgnoreCase("on") == 0) {
            this.wsVariableRadio.doClick();
        } else {
            this.slVariableRadio.doClick();
        }
        this.timeout.setText(map.get("timeout"));
        this.inputBufferSize.setText(map.get("inputBufferSize"));
        this.protocol.setSelectedItem((Object)map.get("protocol"));
        this.serialPort.setSelectedItem((Object)map.get("serialPort"));
        this.baudRate.setText(map.get("baudRate"));
        this.gpibVendor.setSelectedItem((Object)map.get("gpibVendor"));
        this.boardIndex.setText(map.get("boardIndex"));
        this.primaryAddress.setText(map.get("primaryAddress"));
        this.secondaryAddress.setText(map.get("secondaryAddress"));
        this.visaVendor.setSelectedItem((Object)map.get("visaVendor"));
        this.visaSerialPort.setText(map.get("visaSerialPort"));
        this.chassisIndex.setText(map.get("chassisIndex"));
        this.logicalAddress.setText(map.get("logicalAddress"));
        this.visaTCPBoardIndex.setText(map.get("visaTCPBoardIndex"));
        this.visaTCPRemoteHost.setText(map.get("visaTCPRemoteHost"));
        this.visaUSBBoardIndex.setText(map.get("usbBoardIndex"));
        this.visaUSBManufacturerID.setText(map.get("usbManufID"));
        this.visaUSBModelCode.setText(map.get("usbModelCode"));
        this.visaUSBSerialNumber.setText(map.get("usbSerialNumber"));
        this.tcpRemoteHost.setText(map.get("tcpRemoteHost"));
        this.tcpRemotePort.setText(map.get("tcpRemotePort"));
        this.udpRemoteHost.setText(map.get("udpRemoteHost"));
        this.udpRemotePort.setText(map.get("udpRemotePort"));
        this.wsVariableName.setText(map.get("wsVariableName"));
    }

    private void disableHardwareConfiguration() {
        this.protocol.setEnabled(false);
        this.protocolLabel.setEnabled(false);
        this.timeout.setEnabled(false);
        this.timeout.setBackground(this.getBackground());
        this.timeoutLabel.setEnabled(false);
        this.inputBufferSize.setEnabled(false);
        this.inputBufferSize.setBackground(this.getBackground());
        this.inputBufferSizeLabel.setEnabled(false);
        this.serialPortLabel.setEnabled(false);
        this.serialPortLabel.setBackground(this.getBackground());
        this.serialPort.setEnabled(false);
        this.baudrateLabel.setEnabled(false);
        this.baudrateLabel.setBackground(this.getBackground());
        this.baudRate.setEnabled(false);
        this.baudRate.setBackground(this.getBackground());
        this.gpibVendor.setEnabled(false);
        this.boardIndex.setEnabled(false);
        this.boardIndex.setBackground(this.getBackground());
        this.primaryAddress.setEnabled(false);
        this.primaryAddress.setBackground(this.getBackground());
        this.secondaryAddress.setEnabled(false);
        this.secondaryAddress.setBackground(this.getBackground());
        this.gpibVendorLabel.setEnabled(false);
        this.boardIndexLabel.setEnabled(false);
        this.primaryAddressLabel.setEnabled(false);
        this.secondaryAddressLabel.setEnabled(false);
        this.serialPortLabel.setEnabled(false);
        this.serialPortLabel.setBackground(this.getBackground());
        this.serialPort.setEnabled(false);
        this.baudrateLabel.setEnabled(false);
        this.baudrateLabel.setBackground(this.getBackground());
        this.baudRate.setEnabled(false);
        this.baudRate.setBackground(this.getBackground());
        this.visaVendorLabel.setEnabled(false);
        this.visaVendor.setEnabled(false);
        this.visaSerialPort.setEnabled(false);
        this.visaSerialPort.setBackground(this.getBackground());
        this.chassisIndexLabel.setEnabled(false);
        this.chassisIndex.setEnabled(false);
        this.chassisIndex.setBackground(this.getBackground());
        this.logicalAddressLabel.setEnabled(false);
        this.logicalAddress.setEnabled(false);
        this.logicalAddress.setBackground(this.getBackground());
        this.visaTCPBoardIndexLabel.setEnabled(false);
        this.visaTCPBoardIndex.setEnabled(false);
        this.visaTCPBoardIndex.setBackground(this.getBackground());
        this.visaTCPRemoteHostLabel.setEnabled(false);
        this.visaTCPRemoteHost.setEnabled(false);
        this.visaTCPRemoteHost.setBackground(this.getBackground());
        this.visaUSBBoardIndexLabel.setEnabled(false);
        this.visaUSBBoardIndex.setEnabled(false);
        this.visaUSBBoardIndex.setBackground(this.getBackground());
        this.visaUSBManufacturerIDLabel.setEnabled(false);
        this.visaUSBManufacturerID.setEnabled(false);
        this.visaUSBManufacturerID.setBackground(this.getBackground());
        this.visaUSBModelCodeLabel.setEnabled(false);
        this.visaUSBModelCode.setEnabled(false);
        this.visaUSBModelCode.setBackground(this.getBackground());
        this.visaUSBSerialNumberLabel.setEnabled(false);
        this.visaUSBSerialNumber.setEnabled(false);
        this.visaUSBSerialNumber.setBackground(this.getBackground());
        this.tcpudpRemoteHostLabel.setEnabled(false);
        this.tcpudpRemotePortLabel.setEnabled(false);
        this.tcpRemoteHost.setEnabled(false);
        this.tcpRemoteHost.setBackground(this.getBackground());
        this.tcpRemotePort.setEnabled(false);
        this.tcpRemotePort.setBackground(this.getBackground());
        this.udpRemoteHost.setEnabled(false);
        this.udpRemoteHost.setBackground(this.getBackground());
        this.udpRemotePort.setEnabled(false);
        this.udpRemotePort.setBackground(this.getBackground());
    }

    private void disableWorkspaceObject() {
        this.wsVariableNameLabel.setEnabled(false);
        this.wsVariableName.setEnabled(false);
        this.wsVariableName.setBackground(this.getBackground());
    }

    public void disableComponents() {
        this.slVariableRadio.setEnabled(false);
        this.wsVariableRadio.setEnabled(false);
        this.disableWorkspaceObject();
        this.disableHardwareConfiguration();
    }

    public void enableComponents() {
        this.slVariableRadio.setEnabled(true);
        this.wsVariableRadio.setEnabled(true);
        if (this.slVariableRadio.isSelected()) {
            this.enableHardwareConfiguration();
        } else {
            this.enableWorkspaceObject();
        }
    }

    private void enableHardwareConfiguration() {
        MJTextField mJTextField = new MJTextField();
        Color color = mJTextField.getBackground();
        this.protocol.setEnabled(true);
        this.protocolLabel.setEnabled(true);
        this.timeout.setEnabled(true);
        this.timeout.setBackground(color);
        this.timeoutLabel.setEnabled(true);
        this.inputBufferSize.setEnabled(true);
        this.inputBufferSize.setBackground(color);
        this.inputBufferSizeLabel.setEnabled(true);
        this.gpibVendor.setEnabled(true);
        this.boardIndex.setEnabled(true);
        this.boardIndex.setBackground(color);
        this.primaryAddress.setEnabled(true);
        this.primaryAddress.setBackground(color);
        this.secondaryAddress.setEnabled(true);
        this.secondaryAddress.setBackground(color);
        this.gpibVendorLabel.setEnabled(true);
        this.boardIndexLabel.setEnabled(true);
        this.primaryAddressLabel.setEnabled(true);
        this.secondaryAddressLabel.setEnabled(true);
        this.serialPortLabel.setEnabled(true);
        this.serialPortLabel.setBackground(color);
        this.serialPort.setEnabled(true);
        this.baudrateLabel.setEnabled(true);
        this.baudrateLabel.setBackground(color);
        this.baudRate.setEnabled(true);
        this.baudRate.setBackground(color);
        this.visaVendorLabel.setEnabled(true);
        this.visaVendor.setEnabled(true);
        this.visaSerialPort.setEnabled(true);
        this.visaSerialPort.setBackground(color);
        this.chassisIndexLabel.setEnabled(true);
        this.chassisIndex.setEnabled(true);
        this.chassisIndex.setBackground(color);
        this.logicalAddressLabel.setEnabled(true);
        this.logicalAddress.setEnabled(true);
        this.logicalAddress.setBackground(color);
        this.visaTCPBoardIndexLabel.setEnabled(true);
        this.visaTCPBoardIndex.setEnabled(true);
        this.visaTCPBoardIndex.setBackground(color);
        this.visaTCPRemoteHostLabel.setEnabled(true);
        this.visaTCPRemoteHost.setEnabled(true);
        this.visaTCPRemoteHost.setBackground(color);
        this.visaUSBBoardIndexLabel.setEnabled(true);
        this.visaUSBBoardIndex.setEnabled(true);
        this.visaUSBBoardIndex.setBackground(color);
        this.visaUSBManufacturerIDLabel.setEnabled(true);
        this.visaUSBManufacturerID.setEnabled(true);
        this.visaUSBManufacturerID.setBackground(color);
        this.visaUSBModelCodeLabel.setEnabled(true);
        this.visaUSBModelCode.setEnabled(true);
        this.visaUSBModelCode.setBackground(color);
        this.visaUSBSerialNumberLabel.setEnabled(true);
        this.visaUSBSerialNumber.setEnabled(true);
        this.visaUSBSerialNumber.setBackground(color);
        this.tcpudpRemoteHostLabel.setEnabled(true);
        this.tcpudpRemotePortLabel.setEnabled(true);
        this.tcpRemoteHost.setEnabled(true);
        this.tcpRemoteHost.setBackground(color);
        this.tcpRemotePort.setEnabled(true);
        this.tcpRemotePort.setBackground(color);
        this.udpRemoteHost.setEnabled(true);
        this.udpRemoteHost.setBackground(color);
        this.udpRemotePort.setEnabled(true);
        this.udpRemotePort.setBackground(color);
    }

    private void enableWorkspaceObject() {
        MJTextField mJTextField = new MJTextField();
        Color color = mJTextField.getBackground();
        this.wsVariableNameLabel.setEnabled(true);
        this.wsVariableName.setEnabled(true);
        this.wsVariableName.setBackground(color);
    }

    private void addSerialConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.serialPortLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.serialPort, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.baudrateLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.baudRate, (Object)gridBagConstraints);
    }

    private void removeSerialConfiguration() {
        this.hwPanel.remove((Component)this.serialPortLabel);
        this.hwPanel.remove((Component)this.serialPort);
        this.hwPanel.remove((Component)this.baudrateLabel);
        this.hwPanel.remove((Component)this.baudRate);
    }

    private void addGPIBConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.gpibVendorLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.gpibVendor, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.boardIndexLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.boardIndex, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.primaryAddressLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.primaryAddress, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.secondaryAddressLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.secondaryAddress, (Object)gridBagConstraints);
    }

    private void removeGPIBConfiguration() {
        this.hwPanel.remove((Component)this.gpibVendorLabel);
        this.hwPanel.remove((Component)this.gpibVendor);
        this.hwPanel.remove((Component)this.boardIndexLabel);
        this.hwPanel.remove((Component)this.boardIndex);
        this.hwPanel.remove((Component)this.primaryAddressLabel);
        this.hwPanel.remove((Component)this.primaryAddress);
        this.hwPanel.remove((Component)this.secondaryAddressLabel);
        this.hwPanel.remove((Component)this.secondaryAddress);
    }

    private void addVISASerialConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendorLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendor, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.serialPortLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaSerialPort, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.baudrateLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.baudRate, (Object)gridBagConstraints);
    }

    private void removeVISASerialConfiguration() {
        this.hwPanel.remove((Component)this.visaVendorLabel);
        this.hwPanel.remove((Component)this.visaVendor);
        this.hwPanel.remove((Component)this.serialPortLabel);
        this.hwPanel.remove((Component)this.visaSerialPort);
        this.hwPanel.remove((Component)this.baudrateLabel);
        this.hwPanel.remove((Component)this.baudRate);
    }

    private void addVISAGPIBConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendorLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendor, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.boardIndexLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.boardIndex, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.primaryAddressLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.primaryAddress, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.secondaryAddressLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.secondaryAddress, (Object)gridBagConstraints);
    }

    private void removeVISAGPIBConfiguration() {
        this.hwPanel.remove((Component)this.visaVendorLabel);
        this.hwPanel.remove((Component)this.visaVendor);
        this.hwPanel.remove((Component)this.boardIndexLabel);
        this.hwPanel.remove((Component)this.boardIndex);
        this.hwPanel.remove((Component)this.primaryAddressLabel);
        this.hwPanel.remove((Component)this.primaryAddress);
        this.hwPanel.remove((Component)this.secondaryAddressLabel);
        this.hwPanel.remove((Component)this.secondaryAddress);
    }

    private void addVISAVXIConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendorLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendor, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.chassisIndexLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.chassisIndex, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.logicalAddressLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.logicalAddress, (Object)gridBagConstraints);
    }

    private void removeVISAVXIConfiguration() {
        this.hwPanel.remove((Component)this.visaVendorLabel);
        this.hwPanel.remove((Component)this.visaVendor);
        this.hwPanel.remove((Component)this.chassisIndexLabel);
        this.hwPanel.remove((Component)this.chassisIndex);
        this.hwPanel.remove((Component)this.logicalAddressLabel);
        this.hwPanel.remove((Component)this.logicalAddress);
    }

    private void addVISAPXIConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendorLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendor, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.chassisIndexLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.chassisIndex, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.busNumberLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.busNumber, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.deviceNumberLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.deviceNumber, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.functionNumberLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.functionNumber, (Object)gridBagConstraints);
    }

    private void removeVISAPXIConfiguration() {
        this.hwPanel.remove((Component)this.visaVendorLabel);
        this.hwPanel.remove((Component)this.visaVendor);
        this.hwPanel.remove((Component)this.chassisIndexLabel);
        this.hwPanel.remove((Component)this.chassisIndex);
        this.hwPanel.remove((Component)this.busNumberLabel);
        this.hwPanel.remove((Component)this.busNumber);
        this.hwPanel.remove((Component)this.deviceNumberLabel);
        this.hwPanel.remove((Component)this.deviceNumber);
        this.hwPanel.remove((Component)this.functionNumberLabel);
        this.hwPanel.remove((Component)this.functionNumber);
    }

    private void addVISAVXIGPIBConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendorLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendor, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.chassisIndexLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.chassisIndex, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.logicalAddressLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.logicalAddress, (Object)gridBagConstraints);
    }

    private void removeVISAVXIGPIBConfiguration() {
        this.hwPanel.remove((Component)this.visaVendorLabel);
        this.hwPanel.remove((Component)this.visaVendor);
        this.hwPanel.remove((Component)this.chassisIndexLabel);
        this.hwPanel.remove((Component)this.chassisIndex);
        this.hwPanel.remove((Component)this.logicalAddressLabel);
        this.hwPanel.remove((Component)this.logicalAddress);
    }

    private void addVISATCPConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendorLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendor, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaTCPBoardIndexLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.visaTCPBoardIndex, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaTCPRemoteHostLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.visaTCPRemoteHost, (Object)gridBagConstraints);
    }

    private void removeVISATCPConfiguration() {
        this.hwPanel.remove((Component)this.visaVendorLabel);
        this.hwPanel.remove((Component)this.visaVendor);
        this.hwPanel.remove((Component)this.visaTCPBoardIndexLabel);
        this.hwPanel.remove((Component)this.visaTCPBoardIndex);
        this.hwPanel.remove((Component)this.visaTCPBoardIndexLabel);
        this.hwPanel.remove((Component)this.visaTCPBoardIndex);
        this.hwPanel.remove((Component)this.visaTCPRemoteHostLabel);
        this.hwPanel.remove((Component)this.visaTCPRemoteHost);
    }

    private void addVISAUSBConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendorLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaVendor, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaUSBBoardIndexLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.visaUSBBoardIndex, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaUSBManufacturerIDLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.visaUSBManufacturerID, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.visaUSBModelCodeLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaUSBModelCode, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.hwPanel.add((Component)this.visaUSBSerialNumberLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.visaUSBSerialNumber, (Object)gridBagConstraints);
    }

    private void removeVISAUSBConfiguration() {
        this.hwPanel.remove((Component)this.visaVendorLabel);
        this.hwPanel.remove((Component)this.visaVendor);
        this.hwPanel.remove((Component)this.visaUSBBoardIndexLabel);
        this.hwPanel.remove((Component)this.visaUSBBoardIndex);
        this.hwPanel.remove((Component)this.visaUSBManufacturerIDLabel);
        this.hwPanel.remove((Component)this.visaUSBManufacturerID);
        this.hwPanel.remove((Component)this.visaUSBModelCodeLabel);
        this.hwPanel.remove((Component)this.visaUSBModelCode);
        this.hwPanel.remove((Component)this.visaUSBSerialNumberLabel);
        this.hwPanel.remove((Component)this.visaUSBSerialNumber);
    }

    private void addTCPIPConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.tcpudpRemoteHostLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.tcpRemoteHost, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.tcpudpRemotePortLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.tcpRemotePort, (Object)gridBagConstraints);
    }

    private void removeTCPIPConfiguration() {
        this.hwPanel.remove((Component)this.tcpudpRemoteHostLabel);
        this.hwPanel.remove((Component)this.tcpRemoteHost);
        this.hwPanel.remove((Component)this.tcpudpRemotePortLabel);
        this.hwPanel.remove((Component)this.tcpRemotePort);
    }

    private void addUDPConfiguration() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.tcpudpRemoteHostLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.udpRemoteHost, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.tcpudpRemotePortLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints.anchor = 17;
        this.hwPanel.add((Component)this.udpRemotePort, (Object)gridBagConstraints);
    }

    private void removeUDPConfiguration() {
        this.hwPanel.remove((Component)this.tcpudpRemoteHostLabel);
        this.hwPanel.remove((Component)this.udpRemoteHost);
        this.hwPanel.remove((Component)this.tcpudpRemotePortLabel);
        this.hwPanel.remove((Component)this.udpRemotePort);
    }

    private void protocolActionPerformed(ActionEvent actionEvent) {
        switch (this.selectedProtocol) {
            case 0: {
                this.removeSerialConfiguration();
                break;
            }
            case 1: {
                this.removeGPIBConfiguration();
                break;
            }
            case 2: {
                this.removeVISASerialConfiguration();
                break;
            }
            case 3: {
                this.removeVISAGPIBConfiguration();
                break;
            }
            case 6: {
                this.removeVISAVXIConfiguration();
                break;
            }
            case 7: {
                this.removeVISAVXIGPIBConfiguration();
                break;
            }
            case 4: {
                this.removeVISATCPConfiguration();
                break;
            }
            case 5: {
                this.removeVISAUSBConfiguration();
                break;
            }
            case 8: {
                this.removeTCPIPConfiguration();
                break;
            }
            case 9: {
                this.removeUDPConfiguration();
                break;
            }
            case 10: {
                this.removeVISAPXIConfiguration();
            }
        }
        switch (this.protocol.getSelectedIndex()) {
            case 0: {
                this.addSerialConfiguration();
                break;
            }
            case 1: {
                this.addGPIBConfiguration();
                break;
            }
            case 2: {
                this.addVISASerialConfiguration();
                break;
            }
            case 3: {
                this.addVISAGPIBConfiguration();
                break;
            }
            case 6: {
                this.addVISAVXIConfiguration();
                break;
            }
            case 7: {
                this.addVISAVXIGPIBConfiguration();
                break;
            }
            case 5: {
                this.addVISAUSBConfiguration();
                break;
            }
            case 4: {
                this.addVISATCPConfiguration();
                break;
            }
            case 8: {
                this.addTCPIPConfiguration();
                break;
            }
            case 9: {
                this.addUDPConfiguration();
                break;
            }
            case 10: {
                this.addVISAPXIConfiguration();
            }
        }
        this.selectedProtocol = this.protocol.getSelectedIndex();
        this.validate();
        MJFrame mJFrame = (MJFrame)this.getTopLevelAncestor();
        if (mJFrame != null) {
            mJFrame.pack();
        }
    }

    private void slVariableRadioItemStateChanged(ItemEvent itemEvent) {
        if (this.slVariableRadio.isSelected()) {
            this.enableHardwareConfiguration();
        } else {
            this.disableHardwareConfiguration();
        }
    }

    private void wsVariableRadioItemStateChanged(ItemEvent itemEvent) {
        if (this.wsVariableRadio.isSelected()) {
            this.enableWorkspaceObject();
        } else {
            this.disableWorkspaceObject();
        }
    }
}

