/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.editors;

import com.mathworks.toolbox.instrument.editors.ASCIITableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public abstract class ASCIITableViewer
extends JPanel
implements ActionListener,
MouseListener {
    protected static final char ENTER_KEY = '\n';
    protected static final int EMPTY_ROW = 5;
    protected static final String ACTION = "ACTION";
    protected static final int ASCII_CHAR = 0;
    protected static final int ASCII_CODE = 1;
    protected int currentView = 1;
    protected boolean hitEnter = false;
    protected JTable table;
    protected ASCIITableModel model;
    protected Vector<Object> mostRecentValues = new Vector();

    public ASCIITableViewer(String string) {
        this.setLayout(new BorderLayout());
        this.layoutFrame();
    }

    public void layoutFrame() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 5));
        this.add((Component)jPanel, "Center");
        jPanel.add((Component)this.createLeftPanel(), "Center");
        jPanel.add((Component)this.createSetButtonPanel(), "East");
    }

    public JPanel createLeftPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.createLabel(), "South");
        jPanel2.add((Component)this.createPropertyPanel(), "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)jPanel3, "Center");
        jPanel3.setBorder(this.createBorder("Options"));
        this.model = new ASCIITableModel();
        this.table = new JTable(this.model);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(this);
        jTableHeader.setBorder(BorderFactory.createRaisedBevelBorder());
        jTableHeader.putClientProperty(ACTION, "SORT");
        this.table.setSelectionMode(0);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn2.setCellRenderer(defaultTableCellRenderer);
        defaultTableCellRenderer.setHorizontalAlignment(0);
        this.table.setRowSelectionInterval(0, 0);
        this.table.setColumnSelectionInterval(0, 0);
        this.addValuesToTable();
        this.table.addMouseListener(this);
        this.table.putClientProperty(ACTION, "SET");
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel3.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public Border createBorder(String string) {
        Border border = BorderFactory.createLineBorder(Color.black);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, string);
        Border border2 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        return BorderFactory.createCompoundBorder(titledBorder, border2);
    }

    public void createMostRecentValuesVector() {
        this.mostRecentValues.removeAllElements();
        for (int i = 0; i < 5; ++i) {
            this.mostRecentValues.addElement(this.table.getValueAt(i, 0));
            this.mostRecentValues.addElement(this.table.getValueAt(i, 1));
        }
    }

    public void updateTextField(JTextField jTextField, Object object) {
        if (object instanceof String) {
            jTextField.setText((String)object);
        } else if (object instanceof Integer) {
            jTextField.setText(object.toString());
        } else {
            double[] dArray = (double[])object;
            String string = String.valueOf(dArray[0]);
            int n = string.indexOf(".");
            jTextField.setText(string.substring(0, n));
        }
    }

    public void updateMostRecentTableValues() {
        this.updateMostRecentTableValues(this.table.getSelectedRow());
    }

    public void updateMostRecentTableValues(int n) {
        this.updateMostRecentValuesVector(n);
        for (int i = 0; i < this.mostRecentValues.size(); i += 2) {
            this.table.setValueAt(this.mostRecentValues.elementAt(i), i / 2, 0);
            this.table.setValueAt(this.mostRecentValues.elementAt(i + 1), i / 2, 1);
        }
        this.saveMostRecentValues();
    }

    public void updateMostRecentValuesVector(int n) {
        String string = this.convertTableEntryToString(n, 0);
        String string2 = this.convertTableEntryToString(n, 1);
        int n2 = n < 5 ? n * 2 : this.containsNewValue(string);
        if (n2 != -1) {
            this.mostRecentValues.removeElementAt(n2 + 1);
            this.mostRecentValues.removeElementAt(n2);
        } else {
            this.mostRecentValues.removeElementAt(this.mostRecentValues.size() - 1);
            this.mostRecentValues.removeElementAt(this.mostRecentValues.size() - 1);
        }
        this.mostRecentValues.insertElementAt(string, 0);
        this.mostRecentValues.insertElementAt(string2, 1);
    }

    public String convertTableEntryToString(int n, int n2) {
        Object object = this.table.getValueAt(n, n2);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Integer) {
            return object.toString();
        }
        return "";
    }

    public int containsNewValue(String string) {
        for (int i = 0; i < this.mostRecentValues.size(); i += 2) {
            if (!string.equals(this.mostRecentValues.elementAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.hitEnter) {
            this.hitEnter = false;
            return;
        }
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        boolean bl = this.updateProperty(string, this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn()));
        if (bl) {
            // empty if block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        String string = (String)((JComponent)mouseEvent.getSource()).getClientProperty(ACTION);
        switch (n) {
            case 1: {
                if (!string.equals("SORT")) return;
                this.sort(mouseEvent);
                return;
            }
            case 2: {
                if (string.equals("SET")) {
                    boolean bl = this.mouseDoubleClick();
                    if (!bl) return;
                }
                if (!string.equals("SORT")) return;
                this.sort(mouseEvent);
            }
        }
    }

    public void sort(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        int n = jTableHeader.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
        int n2 = this.table.convertColumnIndexToModel(n);
        if (n2 == this.currentView) {
            return;
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        this.currentView = n2;
        switch (this.currentView) {
            case 0: {
                this.updateTable(this.model.getDataSortedByChar());
                tableColumn.setHeaderValue("ASCII Character *");
                tableColumn2.setHeaderValue("ASCII Code");
                break;
            }
            case 1: {
                this.updateTable(this.model.getDataSortedByCode());
                tableColumn.setHeaderValue("ASCII Character");
                tableColumn2.setHeaderValue("ASCII Code *");
            }
        }
        this.updateTable(n2);
        this.repaint();
    }

    public void updateTable(Object[][] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.table.setValueAt(objectArray[i][0], i, 0);
            this.table.setValueAt(objectArray[i][1], i, 1);
        }
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    public int findCode(String string) {
        int n;
        for (n = 0; n < this.table.getRowCount(); ++n) {
            if (!string.equals(this.table.getValueAt(n, 0))) continue;
            return n;
        }
        for (n = 0; n < this.table.getRowCount(); ++n) {
            if (!string.equals(this.table.getValueAt(n, 1))) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public abstract JLabel createLabel();

    public abstract JPanel createPropertyPanel();

    public abstract JPanel createSetButtonPanel();

    public abstract void addValuesToTable();

    public abstract boolean updateProperty(String var1, Object var2);

    public abstract boolean mouseDoubleClick();

    public abstract void saveMostRecentValues();

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract void updateTable(int var1);
}

