/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.icdevice;

import java.util.Hashtable;

public class ICTypeInfo {
    public static final int sBooleanType = 1;
    public static final int sByteType = 2;
    public static final int sCharType = 3;
    public static final int sShortType = 4;
    public static final int sIntType = 5;
    public static final int sLongType = 6;
    public static final int sDoubleType = 7;
    public static final int sFloatType = 8;
    public static final int sObjectType = 9;
    public static final int sMLArrayRefType = 10;
    private static Hashtable<String, ICTypeInfo> sBasicTypes = null;
    public int storageClass;
    public String typeName;
    public String className;

    public ICTypeInfo(int n, String string) {
        this.storageClass = n;
        this.typeName = string;
        this.className = string;
    }

    public ICTypeInfo(String string) {
        this.storageClass = 9;
        int n = string.indexOf("[]");
        if (n > 0) {
            String string2 = "";
            String string3 = string.substring(0, n).replace('.', '/');
            while (n > 0) {
                n = string.indexOf("[]", n + 1);
                string2 = string2 + "[";
            }
            ICTypeInfo iCTypeInfo = ICTypeInfo.getTypeInfoFromName(string3);
            this.className = this.typeName = string2 + iCTypeInfo.typeName;
        } else {
            this.className = string.replace('.', '/');
            this.typeName = "L" + this.className + ";";
        }
    }

    public static void initBasicTypes() {
        if (sBasicTypes != null) {
            return;
        }
        sBasicTypes = new Hashtable();
        sBasicTypes.put("boolean", new ICTypeInfo(1, "Z"));
        sBasicTypes.put("byte", new ICTypeInfo(2, "B"));
        sBasicTypes.put("char", new ICTypeInfo(3, "C"));
        sBasicTypes.put("short", new ICTypeInfo(4, "S"));
        sBasicTypes.put("int", new ICTypeInfo(5, "I"));
        sBasicTypes.put("float", new ICTypeInfo(8, "F"));
        sBasicTypes.put("double", new ICTypeInfo(7, "D"));
        sBasicTypes.put("long", new ICTypeInfo(6, "J"));
    }

    public static ICTypeInfo getTypeInfoFromName(String string) {
        ICTypeInfo.initBasicTypes();
        ICTypeInfo iCTypeInfo = sBasicTypes.get(string);
        if (iCTypeInfo == null) {
            iCTypeInfo = new ICTypeInfo(string);
        }
        return iCTypeInfo;
    }
}

