/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.panels;

import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.StringProperty;
import com.mathworks.toolbox.instrument.device.util.PropertyHelp;
import com.mathworks.toolbox.testmeas.guiutil.TMHelpViewer;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.io.File;
import java.util.Vector;
import javax.swing.ListModel;

public class DeviceDriverHelper {
    protected static final int SET = 0;
    protected static final int GET = 1;
    private static final String NO_HELP_FCN = "No help is defined for this function.";
    private static final String NO_HELP_PROP = "No help is defined for this property.";
    protected static final String TAB = "    ";
    private Parser parser = null;
    private String[] groupNames;
    protected String driverName = "";
    protected long driverLastModified = 0L;
    protected Vector<String> functions = null;
    protected int[] functionLabelLocations;
    protected String[] functionLabelNames;
    protected int numOfFunctionGroups = 0;
    protected Vector<String> properties = null;
    protected int[] propertyLabelLocations;
    protected String[] propertyLabelNames;
    protected int numOfPropertyGroups = 0;
    protected int stepType = 1;
    private String[] defaultFunctionNames = new String[]{"devicereset", "geterror", "selftest"};

    public DeviceDriverHelper(Parser parser) {
        this.parser = parser;
        this.groupNames = TMStringUtil.sort((String[])TMStringUtil.vector2StringArray(this.parser.getPropertyGroups()));
    }

    protected Parser getParser() {
        return this.parser;
    }

    protected String[] getGroupNames() {
        this.getParser();
        return this.groupNames;
    }

    protected long getDriverDate() {
        File file = new File(this.driverName);
        return file.lastModified();
    }

    protected int addToVector(Vector<String> vector, Vector<String> vector2, String string) {
        if (vector2 == null || vector2.size() == 0) {
            return 0;
        }
        vector.add(string);
        for (int i = 0; i < vector2.size(); ++i) {
            vector.add(TAB + vector2.elementAt(i));
        }
        return vector2.size();
    }

    public int getGroupSize(String string) {
        return this.parser.getGroupSize(string);
    }

    public String getGroupCommandNameAt(String string, int n) {
        return this.parser.getGroupCommandNameAt(string, n);
    }

    protected String updateHtml(String string) {
        string = "<p>" + string;
        int n = string.indexOf(TMStringUtil.LINESEP);
        int n2 = 0;
        while (n != -1) {
            n2 = n;
            if ((n = string.indexOf(TMStringUtil.LINESEP, n + 1)) - 1 == n2 || n == -1) continue;
            string = string.substring(0, n) + "</p><p>" + string.substring(n + 1);
        }
        string = string + "</p>";
        return string;
    }

    public Vector<String> getPropertyListData() {
        if (this.properties != null) {
            return this.properties;
        }
        this.driverLastModified = this.getDriverDate();
        this.properties = new Vector();
        String[] stringArray = this.getGroupNames();
        this.propertyLabelLocations = new int[stringArray.length + 1];
        this.propertyLabelNames = new String[stringArray.length + 1];
        this.numOfPropertyGroups = 0;
        Vector<String> vector = this.getParser().getProperties("parent");
        Vector vector2 = vector == null ? new Vector() : (Vector)vector.clone();
        if (this.stepType == 1) {
            vector2.add("InstrumentModel");
        } else {
            vector2 = this.removeReadOnlyProperties(vector2, "parent");
        }
        int n = this.getParser().getDriverTypeId();
        if (n == 2 || n == 7 || n == 1) {
            vector2.add((String)"RepCapIdentifier");
        }
        vector2 = TMStringUtil.stringArray2Vector((String[])TMStringUtil.sort((String[])TMStringUtil.vector2StringArray(vector2)));
        this.addToVector(this.properties, vector2, "Device object properties:");
        this.propertyLabelNames[this.numOfPropertyGroups] = "parent";
        this.propertyLabelLocations[this.numOfPropertyGroups] = 0;
        ++this.numOfPropertyGroups;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            int n3 = this.properties.size();
            String string = stringArray[i] + " group object properties:";
            Vector<String> vector3 = this.getParser().getProperties(stringArray[i]);
            if (vector3 == null) continue;
            vector3 = (Vector<String>)vector3.clone();
            if (this.stepType == 0) {
                vector3 = this.removeReadOnlyProperties(vector3, stringArray[i]);
            }
            if ((n2 = this.addToVector(this.properties, vector3, string)) == 0) continue;
            this.propertyLabelNames[this.numOfPropertyGroups] = stringArray[i];
            this.propertyLabelLocations[this.numOfPropertyGroups] = n3;
            ++this.numOfPropertyGroups;
        }
        return this.properties;
    }

    protected Vector<String> removeReadOnlyProperties(Vector<String> vector, String string) {
        Vector<String> vector2 = new Vector<String>();
        while (vector.size() > 0) {
            String string2 = vector.elementAt(0);
            PropertyDefinition propertyDefinition = (PropertyDefinition)this.getParser().getPropertyInformation(string2, string);
            if (!propertyDefinition.getReadOnly().equals("always")) {
                vector2.add(string2);
            }
            vector.removeElementAt(0);
        }
        return vector2;
    }

    protected int getPropertyIndex(String string, String string2, ListModel listModel) {
        for (int i = 0; i < this.numOfPropertyGroups; ++i) {
            String string3 = this.propertyLabelNames[i];
            if (!string2.equals(string3)) continue;
            int n = this.propertyLabelLocations[i];
            int n2 = listModel.getSize();
            if (i != this.numOfPropertyGroups - 1) {
                n2 = this.propertyLabelLocations[i + 1];
            }
            string = TAB + string;
            for (int j = n; j < n2; ++j) {
                if (!string.equals(listModel.getElementAt(j))) continue;
                return j;
            }
            return -1;
        }
        return -1;
    }

    public String getSelectedPropertyGroup(int n) {
        String string = this.propertyLabelNames[this.numOfPropertyGroups - 1];
        for (int i = 0; i < this.numOfPropertyGroups; ++i) {
            if (this.propertyLabelLocations[i] <= n) continue;
            string = this.propertyLabelNames[i - 1];
            break;
        }
        return string;
    }

    public String getProperty(int n) {
        String string = this.properties.elementAt(n);
        for (int i = 0; i < this.propertyLabelLocations.length; ++i) {
            if (n != this.propertyLabelLocations[i]) continue;
            return string;
        }
        return string.substring(TAB.length());
    }

    public boolean isPropertyHeader(int n) {
        for (int i = 0; i < this.propertyLabelLocations.length; ++i) {
            if (this.propertyLabelLocations[i] != n) continue;
            return true;
        }
        return false;
    }

    public void showPropertyHelp(int n) {
        String string = this.getSelectedPropertyGroup(n);
        String string2 = this.getPropertyHelp(string, n);
        string2 = "<html>" + string2 + "</html>";
        TMHelpViewer tMHelpViewer = TMHelpViewer.getInstance();
        tMHelpViewer.update(string2, this.getProperty(n) + " Help");
        tMHelpViewer.addToFrame();
    }

    public String getPropertyHelp(String string, int n) {
        if (this.isPropertyHeader(n)) {
            if (string.equals("parent")) {
                return "<html></html>";
            }
            String string2 = this.getParser().getGroupDescription(string);
            string2 = string2 == null || string2.equals("") ? this.getGroupHelp(string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase()) : this.updateHtml(string2);
            return string2;
        }
        String string3 = this.getProperty(n);
        if (string3.equals("InstrumentModel")) {
            return this.getInstrumentModelHelp();
        }
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getParser().getPropertyInformation(string3, string);
        if (propertyDefinition == null) {
            return NO_HELP_PROP;
        }
        String string4 = propertyDefinition.getDescription();
        string4 = string4 == null || string4.equals("") ? NO_HELP_PROP : this.updateHtml(string4);
        return string4;
    }

    public boolean isPropertyHelpDefined(String string, int n) {
        String string2 = this.getPropertyHelp(string, n);
        return !string2.equals(NO_HELP_PROP);
    }

    private String getInstrumentModelHelp() {
        try {
            return PropertyHelp.getHelp("InstrumentModel");
        }
        catch (TMException tMException) {
            return "";
        }
    }

    private String getGroupHelp(String string) {
        return "<p>" + string.toUpperCase() + " vector of device " + string.toLowerCase() + " objects (read only)</p>" + "<p> </p>" + "<p>   " + string + " is a vector of all the device " + string.toLowerCase() + " objects contained by" + "a device object. When a device object is created, all the available " + string.toLowerCase() + "" + "objects (as defined by the device driver) are added.</p>" + "<p> </p>" + "<p>" + string + " is used to reference one or more individual " + string.toLowerCase() + " objects. To  " + "reference a " + string.toLowerCase() + " object, you must know its hardware index. The hardware" + "index is given by the HwIndex property. For example, you must use " + string + "" + "with the appropriate indices when configuring " + string.toLowerCase() + " property values.</p>";
    }

    public PropertyConstraint[] getPropertyConstraints(String string, String string2) {
        if (string2.equals("RepCapIdentifier")) {
            PropertyConstraint[] propertyConstraintArray = new PropertyConstraint[]{new StringProperty()};
            return propertyConstraintArray;
        }
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getParser().getPropertyInformation(string2, string);
        return propertyDefinition.getValidConstraints(this.getParser());
    }

    public boolean isPropertyReadOnly(String string, String string2) {
        if (string2.equals("InstrumentModel")) {
            return true;
        }
        if (string2.equals("RepCapIdentifier")) {
            return false;
        }
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getParser().getPropertyInformation(string2, string);
        return propertyDefinition.getReadOnly().equals("always");
    }

    public boolean isDefaultPropertyName(String string, String string2) {
        if (!string2.equals("parent")) {
            return false;
        }
        return string.equals("InstrumentModel");
    }

    public Vector<String> getFunctionListData() {
        if (this.functions != null) {
            return this.functions;
        }
        this.driverLastModified = this.getDriverDate();
        this.functions = new Vector();
        String[] stringArray = this.getGroupNames();
        this.functionLabelLocations = new int[stringArray.length + 1];
        this.functionLabelNames = new String[stringArray.length + 1];
        this.numOfFunctionGroups = 0;
        Vector<String> vector = this.getParser().getMethods("parent");
        Vector vector2 = vector == null ? new Vector() : (Vector)vector.clone();
        vector2.add("devicereset");
        vector2.add("geterror");
        vector2.add("selftest");
        vector2 = TMStringUtil.stringArray2Vector((String[])TMStringUtil.sort((String[])TMStringUtil.vector2StringArray((Vector)vector2)));
        this.addToVector(this.functions, vector2, "Device object functions:");
        this.functionLabelNames[this.numOfFunctionGroups] = "parent";
        this.functionLabelLocations[this.numOfFunctionGroups] = 0;
        ++this.numOfFunctionGroups;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.functions.size();
            String string = stringArray[i] + " group object functions:";
            int n2 = this.addToVector(this.functions, this.getParser().getMethods(stringArray[i]), string);
            if (n2 == 0) continue;
            this.functionLabelNames[this.numOfFunctionGroups] = stringArray[i];
            this.functionLabelLocations[this.numOfFunctionGroups] = n;
            ++this.numOfFunctionGroups;
        }
        return this.functions;
    }

    protected int getFunctionIndex(String string, String string2, ListModel listModel) {
        for (int i = 0; i < this.numOfFunctionGroups; ++i) {
            String string3 = this.functionLabelNames[i];
            if (!string2.equals(string3)) continue;
            int n = this.functionLabelLocations[i];
            int n2 = listModel.getSize();
            if (i != this.numOfFunctionGroups - 1) {
                n2 = this.functionLabelLocations[i + 1];
            }
            string = TAB + string;
            for (int j = n; j < n2; ++j) {
                if (!string.equals(listModel.getElementAt(j))) continue;
                return j;
            }
            return -1;
        }
        return -1;
    }

    public String getSelectedFunctionGroup(int n) {
        String string = this.functionLabelNames[this.numOfFunctionGroups - 1];
        for (int i = 0; i < this.numOfFunctionGroups; ++i) {
            if (this.functionLabelLocations[i] <= n) continue;
            string = this.functionLabelNames[i - 1];
            break;
        }
        return string;
    }

    public String getFunctionDefinition(String string, int n) {
        String string2 = this.getFunction(n);
        if (string2.equals("devicereset")) {
            return "devicereset(OBJ)";
        }
        if (string2.equals("geterror")) {
            return "MSG = geterror(OBJ)";
        }
        if (string2.equals("selftest")) {
            return "OUT = selftest(OBJ)";
        }
        return this.getParser().getMethodDefinition(string2, string).getInvokeCommand();
    }

    public String getFunctionHelp(String string, int n) {
        if (this.isFunctionHeader(n)) {
            if (string.equals("parent")) {
                return "<html></html>";
            }
            String string2 = this.getParser().getGroupDescription(string);
            string2 = string2 == null || string2.equals("") ? this.getGroupHelp(string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase()) : this.updateHtml(string2);
            return string2;
        }
        String string3 = this.getFunction(n);
        if (string3.equals("devicereset")) {
            return this.getDeviceResetHelp();
        }
        if (string3.equals("geterror")) {
            return this.getGetErrorHelp();
        }
        if (string3.equals("selftest")) {
            return this.getSelfTestHelp();
        }
        String string4 = this.getParser().getMethodDefinition(string3, string).getDescription();
        string4 = string4 == null || string4.equals("") ? NO_HELP_FCN : this.updateHtml(string4);
        return string4;
    }

    public boolean isFunctionHelpDefined(String string, int n) {
        String string2 = this.getFunctionHelp(string, n);
        return !string2.equals(NO_HELP_FCN);
    }

    public String getFunction(int n) {
        String string = this.functions.elementAt(n);
        for (int i = 0; i < this.functionLabelLocations.length; ++i) {
            if (n != this.functionLabelLocations[i]) continue;
            return string;
        }
        return string.substring(TAB.length());
    }

    private String getDeviceResetHelp() {
        return "<p>DEVICERESET Reset instrument.</p><p> </p><p>DEVICERESET(OBJ) resets the instrument associated with device object, OBJ. </p>";
    }

    private String getGetErrorHelp() {
        return "<p>GETERROR Check and return error message from instrument.</p><p> </p><p>MSG = GETERROR(OBJ) checks the instrument associated with device object, OBJ, for an error message and returns to MSG. The interpretation of MSG will vary based on the instrument.</p>";
    }

    private String getSelfTestHelp() {
        return "<p>SELFTEST Run the instrument self-test.</p><p> </p><p>OUT = SELFTEST(OBJ) runs the self-test for the instrument associated with device object, OBJ and returns the result of the self-test to OUT. OUT will vary based on the instrument.</p>";
    }

    public boolean isFunctionHeader(int n) {
        for (int i = 0; i < this.functionLabelLocations.length; ++i) {
            if (this.functionLabelLocations[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultFunctionName(String string, String string2) {
        if (!string2.equals("parent")) {
            return false;
        }
        for (int i = 0; i < this.defaultFunctionNames.length; ++i) {
            if (!this.defaultFunctionNames[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void showFunctionHelp(int n) {
        String string = this.getSelectedFunctionGroup(n);
        String string2 = this.getFunctionHelp(string, n);
        string2 = "<html>" + string2 + "</html>";
        TMHelpViewer tMHelpViewer = TMHelpViewer.getInstance();
        tMHelpViewer.update(string2, this.getFunction(n) + " Help");
        tMHelpViewer.addToFrame();
    }
}

