/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest.panel;

import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.CodeGenerator;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolFileWriter;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.MIDStepPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.PropertySweepInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.StepInfo;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertySweepPanel
extends MIDStepPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    public static final String ACTION = "ACTION";
    private static final int SELECT = 0;
    private static final int UNSELECT = 1;
    private String[] headings = new String[]{" ", "Property Name", "Group Name"};
    private Object[][] data = null;
    private PropertyTableModel model = null;
    private JScrollPane groupComboBoxesPanel;
    private Hashtable<String, JComboBox> groupComboBoxes = new Hashtable();
    private JCheckBox noErrorStepPass;
    private JCheckBox valueMatchesStepPass;
    private int maxLabelWidth = 0;
    private JLabel tempLabel = new JLabel();
    private long driverLastModified = 0L;

    public PropertySweepPanel(MIDTestToolClient mIDTestToolClient) {
        this.client = mIDTestToolClient;
        this.layoutPanel();
        this.setName("Property Sweep Step Panel");
    }

    @Override
    public void update(StepInfo stepInfo) {
        PropertySweepInfo propertySweepInfo = (PropertySweepInfo)stepInfo;
        if (propertySweepInfo.getData() == null) {
            this.updatePropertiesInTable();
            return;
        }
        if (propertySweepInfo.getNeedsToUpdate()) {
            this.setSelectedProperties(propertySweepInfo.getSelectedProperties());
            this.setSelectedGroups(propertySweepInfo.getSelectedGroups());
            this.noErrorStepPass.setSelected(propertySweepInfo.getNoErrorStepPass());
            this.valueMatchesStepPass.setSelected(propertySweepInfo.getValueMatchesStepPass());
            return;
        }
        this.updateAfterDriverReload(propertySweepInfo);
        propertySweepInfo.setNeedsToUpdate(false);
    }

    public void updatePanelAfterDriverReload() {
        this.updatePropertiesInTable();
        this.groupComboBoxesPanel.getViewport().setView(this.layoutGroupObjectComboboxes());
    }

    private void updateAfterDriverReload(PropertySweepInfo propertySweepInfo) {
        this.updatePropertiesInTable();
        Object[][] objectArray = propertySweepInfo.getData();
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            boolean bl = (Boolean)objectArray[i][0];
            if (bl || (n = this.findTableRow((String)objectArray[i][1], (String)objectArray[i][2])) == -1) continue;
            this.data[n][0] = FALSE;
        }
        this.model.fireTableDataChanged();
        this.groupComboBoxesPanel.getViewport().setView(this.layoutGroupObjectComboboxes());
        String[] stringArray = propertySweepInfo.getGroupNames();
        this.setSelectedGroups(stringArray);
        this.noErrorStepPass.setSelected(propertySweepInfo.getNoErrorStepPass());
        this.valueMatchesStepPass.setSelected(propertySweepInfo.getValueMatchesStepPass());
    }

    @Override
    public void cleanup(StepInfo stepInfo) {
        PropertySweepInfo propertySweepInfo = (PropertySweepInfo)stepInfo;
        propertySweepInfo.setSelectedProperties(this.getSelectedProperties());
        propertySweepInfo.setSelectedGroups(this.getSelectedGroups());
        propertySweepInfo.setNoErrorStepPass(this.noErrorStepPass.isSelected());
        propertySweepInfo.setValueMatchesStepPass(this.valueMatchesStepPass.isSelected());
        propertySweepInfo.setData(this.data);
        propertySweepInfo.setGroupNames(this.getSelectedGroupNames());
    }

    @Override
    public void save(MIDTestToolFileWriter mIDTestToolFileWriter, Element element, StepInfo stepInfo) {
        PropertySweepInfo propertySweepInfo = (PropertySweepInfo)stepInfo;
        mIDTestToolFileWriter.addNode(element, "Name", propertySweepInfo.getName());
        Object[][] objectArray = propertySweepInfo.getData();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Element element2 = mIDTestToolFileWriter.addNode(element, "DataRow");
            element2.setAttribute("Selected", String.valueOf(objectArray[i][0]));
            element2.setAttribute("Property", (String)objectArray[i][1]);
            element2.setAttribute("Group", (String)objectArray[i][2]);
            if (!objectArray[i][0].equals(TRUE)) continue;
            ++n;
        }
        String[] stringArray = propertySweepInfo.getGroupNames();
        for (int i = 0; i < stringArray.length; ++i) {
            mIDTestToolFileWriter.addNode(element, "GroupName", stringArray[i]);
        }
        int[] nArray = propertySweepInfo.getSelectedGroups();
        for (int i = 0; i < nArray.length; ++i) {
            mIDTestToolFileWriter.addNode(element, "GroupIndex", nArray[i]);
        }
        mIDTestToolFileWriter.addNode(element, "SelectedProperties", n);
        mIDTestToolFileWriter.addNode(element, "NoErrorStepPass", propertySweepInfo.getNoErrorStepPass());
        mIDTestToolFileWriter.addNode(element, "ValueMatchesStepPass", propertySweepInfo.getValueMatchesStepPass());
    }

    @Override
    public void load(Node node, StepInfo stepInfo) {
        PropertySweepInfo propertySweepInfo = (PropertySweepInfo)stepInfo;
        propertySweepInfo.setNeedsToUpdate(true);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getNodeName();
            NodeList nodeList2 = nodeList.item(i).getChildNodes();
            if (string.equals("Name")) {
                propertySweepInfo.setName(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("DataRow")) {
                Element element = (Element)nodeList.item(i);
                vector3.addElement(element.getAttribute("Selected"));
                vector3.addElement(element.getAttribute("Property"));
                vector3.addElement(element.getAttribute("Group"));
                continue;
            }
            if (string.equals("GroupName")) {
                vector.addElement(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (string.equals("NoErrorStepPass")) {
                propertySweepInfo.setNoErrorStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("ValueMatchesStepPass")) {
                propertySweepInfo.setValueMatchesStepPass(new Boolean(nodeList2.item(0).getNodeValue()));
                continue;
            }
            if (string.equals("GroupIndex")) {
                vector2.addElement(nodeList2.item(0).getNodeValue());
                continue;
            }
            if (!string.equals("SelectedProperties")) continue;
            n = new Integer(nodeList2.item(0).getNodeValue());
        }
        propertySweepInfo.setGroupNames(TMStringUtil.vector2StringArray(vector));
        Object[][] objectArray = new Object[vector3.size() / 3][3];
        int n2 = 0;
        for (int i = 0; i < vector3.size(); i += 3) {
            objectArray[n2][0] = this.str2Boolean((String)vector3.elementAt(i));
            objectArray[n2][1] = vector3.elementAt(i + 1);
            objectArray[n2++][2] = vector3.elementAt(i + 2);
        }
        propertySweepInfo.setData(objectArray);
        int[] nArray = new int[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            nArray[i] = new Integer((String)vector2.elementAt(i));
        }
        propertySweepInfo.setSelectedGroups(nArray);
        n2 = 0;
        int[] nArray2 = new int[n];
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i][0].equals(TRUE)) continue;
            nArray2[n2++] = i;
        }
        propertySweepInfo.setSelectedProperties(nArray2);
        propertySweepInfo.setIsNodeDirty(false);
    }

    private Boolean str2Boolean(String string) {
        if (string.equals("true")) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public void duplicate(StepInfo stepInfo, StepInfo stepInfo2) {
        PropertySweepInfo propertySweepInfo = (PropertySweepInfo)stepInfo;
        PropertySweepInfo propertySweepInfo2 = (PropertySweepInfo)stepInfo2;
        propertySweepInfo.setSelectedProperties(propertySweepInfo2.getSelectedProperties());
        propertySweepInfo.setSelectedGroups(propertySweepInfo2.getSelectedGroups());
        propertySweepInfo.setNoErrorStepPass(propertySweepInfo2.getNoErrorStepPass());
        propertySweepInfo.setValueMatchesStepPass(propertySweepInfo2.getValueMatchesStepPass());
        propertySweepInfo.setData(propertySweepInfo2.getData());
        propertySweepInfo.setGroupNames(propertySweepInfo2.getGroupNames());
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = this.add(this.createSelectButtonPanel(), this.createPropertyTablePanel(), 5);
        JPanel jPanel2 = this.add(jPanel, this.createGroupObjectPanel(), 5);
        JPanel jPanel3 = this.add(jPanel2, this.createStepPassesPanel(), 5);
        this.add((Component)jPanel3, "North");
    }

    private JPanel createSelectButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)new JLabel("Select the properties to test:"), "West");
        JButton jButton = new JButton("Select All");
        JButton jButton2 = new JButton("Unselect All");
        jButton.setName("Select All Button");
        jButton2.setName("Unselect All Button");
        jButton.putClientProperty(ACTION, new Integer(0));
        jButton2.putClientProperty(ACTION, new Integer(1));
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 5, 0));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel;
    }

    private JPanel createPropertyTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.createTableData();
        this.model = new PropertyTableModel();
        JTable jTable = new JTable(this.model);
        jTable.setName("Property Sweep Table");
        jTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(1000);
        jTable.getColumnModel().getColumn(2).setPreferredWidth(1000);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setPreferredSize(new Dimension(150, 300));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel;
    }

    private JPanel createGroupObjectPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.add((Component)new JLabel("Select the group object(s) to use on sweep:"), "North");
        this.groupComboBoxesPanel = new JScrollPane(this.layoutGroupObjectComboboxes());
        this.groupComboBoxesPanel.setPreferredSize(new Dimension(54, 300));
        this.groupComboBoxesPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.groupComboBoxesPanel.getVerticalScrollBar().setUnitIncrement(10);
        jPanel.add((Component)this.groupComboBoxesPanel, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        return jPanel;
    }

    protected JPanel createStepPassesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.noErrorStepPass = new JCheckBox("If no MATLAB or instrument error occurs", true);
        this.valueMatchesStepPass = new JCheckBox("If current value matches configured value");
        this.noErrorStepPass.setName("No error Checkbox");
        this.valueMatchesStepPass.setName("Matches CheckBox");
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Select when this step passes"));
        jPanel2.add(this.noErrorStepPass);
        jPanel2.add(this.valueMatchesStepPass);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private void calculateMaximumGroupLabelWidth() {
        String[] stringArray = this.getGroupNamesWithProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            this.tempLabel.setText(stringArray[i] + ":");
            int n = this.tempLabel.getPreferredSize().width;
            if (n <= this.maxLabelWidth) continue;
            this.maxLabelWidth = n;
        }
        this.maxLabelWidth += 2;
    }

    private JPanel layoutGroupObjectComboboxes() {
        String[] stringArray = this.getGroupNamesWithProperties();
        this.groupComboBoxes = new Hashtable();
        JPanel jPanel = new JPanel(new GridLayout(stringArray.length, 1, 0, 0));
        if (stringArray.length == 0) {
            return jPanel;
        }
        this.calculateMaximumGroupLabelWidth();
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        for (int i = 0; i < stringArray.length; ++i) {
            jPanel.add(this.createGroupPanel(stringArray[i]));
        }
        return jPanel;
    }

    private JPanel createGroupPanel(String string) {
        this.tempLabel.setText(string + ":");
        int n = this.maxLabelWidth - this.tempLabel.getPreferredSize().width;
        JPanel jPanel = new JPanel(new BorderLayout(n, 0));
        jPanel.add((Component)new JLabel(string + ":"), "West");
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setName(string + " ComboBox");
        int n2 = this.getGroupSize(string);
        for (int i = 0; i < n2; ++i) {
            jComboBox.addItem(this.getGroupCommandNameAt(string, i + 1));
        }
        jComboBox.addItem("All " + string + " group objects");
        this.groupComboBoxes.put(string, jComboBox);
        jPanel.add(jComboBox, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    private void createTableData() {
        int n;
        if (this.getDriverDate() == this.driverLastModified && this.data != null) {
            return;
        }
        this.driverLastModified = this.getDriverDate();
        String[] stringArray = this.getGroupNamesWithProperties();
        int n2 = 0;
        int n3 = 0;
        Vector<String> vector = this.getParser().getProperties("parent");
        Vector vector2 = vector == null ? new Vector() : (Vector)vector.clone();
        vector2.add("InstrumentModel");
        vector2 = TMStringUtil.stringArray2Vector((String[])TMStringUtil.sort((String[])TMStringUtil.vector2StringArray((Vector)vector2)));
        n2 = vector2.size();
        for (n = 0; n < stringArray.length; ++n) {
            vector = this.getParser().getProperties(stringArray[n]);
            if (vector == null) continue;
            n2 += vector.size();
        }
        this.data = new Object[n2][3];
        for (n = 0; n < vector2.size(); ++n) {
            this.data[n3][0] = TRUE;
            this.data[n3][1] = vector2.elementAt(n);
            this.data[n3++][2] = "Device";
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            Vector<String> vector3 = this.getParser().getProperties(string);
            if (vector3 == null) continue;
            Vector vector4 = (Vector)vector3.clone();
            for (int i = 0; i < vector4.size(); ++i) {
                this.data[n3][0] = TRUE;
                this.data[n3][1] = vector4.elementAt(i);
                this.data[n3++][2] = string;
            }
        }
    }

    protected void updatePropertiesInTable() {
        this.data = null;
        this.createTableData();
        this.model.fireTableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.selectProperties(true);
                break;
            }
            case 1: {
                this.selectProperties(false);
            }
        }
    }

    private void selectProperties(boolean bl) {
        Boolean bl2 = TRUE;
        if (!bl) {
            bl2 = FALSE;
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][0] = bl2;
        }
        this.model.fireTableDataChanged();
    }

    private int findTableRow(String string, String string2) {
        for (int i = 0; i < this.data.length; ++i) {
            String string3 = (String)this.data[i][1];
            String string4 = (String)this.data[i][2];
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private int[] getSelectedProperties() {
        int[] nArray = new int[this.data.length];
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.data[i][0].equals(TRUE)) continue;
            nArray[n++] = i;
        }
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    private void setSelectedProperties(int[] nArray) {
        if (nArray == null) {
            this.selectProperties(true);
            return;
        }
        this.selectProperties(false);
        for (int i = 0; i < nArray.length; ++i) {
            this.data[nArray[i]][0] = TRUE;
        }
    }

    private String[] getSelectedGroupNames() {
        String[] stringArray = this.getGroupNamesWithProperties();
        String[] stringArray2 = new String[2 * stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            JComboBox jComboBox = this.groupComboBoxes.get(stringArray[i]);
            stringArray2[n++] = stringArray[i];
            stringArray2[n++] = (String)jComboBox.getSelectedItem();
        }
        return stringArray2;
    }

    private void setSelectedGroups(String[] stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            JComboBox jComboBox = this.groupComboBoxes.get(stringArray[i]);
            if (jComboBox == null) continue;
            jComboBox.setSelectedItem(stringArray[i + 1]);
        }
    }

    private int[] getSelectedGroups() {
        String[] stringArray = this.getGroupNamesWithProperties();
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            JComboBox jComboBox = this.groupComboBoxes.get(stringArray[i]);
            nArray[i] = jComboBox.getSelectedIndex();
        }
        return nArray;
    }

    private void setSelectedGroups(int[] nArray) {
        int n;
        String[] stringArray = this.getGroupNamesWithProperties();
        if (nArray == null) {
            nArray = new int[stringArray.length];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = 0;
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            JComboBox jComboBox = this.groupComboBoxes.get(stringArray[n]);
            jComboBox.setSelectedIndex(nArray[n]);
        }
    }

    @Override
    public String generateCode(StepInfo stepInfo, boolean bl, boolean bl2, int n) {
        PropertySweepInfo propertySweepInfo = (PropertySweepInfo)stepInfo;
        String string = this.getDisplayFunction(bl);
        String string2 = this.getDisplayInsert(bl);
        String string3 = "";
        int[] nArray = propertySweepInfo.getSelectedProperties();
        int[] nArray2 = propertySweepInfo.getSelectedGroups();
        String[] stringArray = propertySweepInfo.getGroupNames();
        string3 = this.addLine(string3, "% Overall error status for all settings.");
        string3 = this.addLine(string3, "finalerrorcode = false;\n");
        for (int i = 0; i < nArray.length; ++i) {
            String string4 = (String)this.data[nArray[i]][1];
            String string5 = (String)this.data[nArray[i]][2];
            int n2 = 0;
            String string6 = "deviceObj";
            if (string5.equals("Device")) {
                string5 = "parent";
            } else {
                n2 = this.getSelectedGroupIndex(string5, stringArray, nArray2);
                string6 = this.getSelectedGroupName(string5, stringArray);
            }
            string3 = this.addLine(string3, "% Reset errorcode.");
            string3 = this.addLine(string3, "errorcode = false;");
            if (bl) {
                string3 = this.addLine(string3, "");
                string3 = this.addLine(string3, "% Post information on the property being tested.");
                string3 = this.addLine(string3, string + "('Testing " + string4 + " property in the " + string5 + " group." + string2 + "');");
                string3 = this.addLine(string3, "% Verify that the test is still running.");
                string3 = this.addLine(string3, "if (MIDTestToolClient.isTestRunning == false)");
                string3 = this.addLine(string3, "    MessageService.publish('Test status: " + CodeGenerator.generateColorCode(true, "\"#0000FF\"", "INCOMPLETE") + "');");
                string3 = this.addLine(string3, "    return;");
                string3 = this.addLine(string3, "end");
            }
            boolean bl3 = false;
            if (!string4.equals("InstrumentModel")) {
                bl3 = ((PropertyDefinition)this.getParser().getPropertyInformation(string4, string5)).isWriteable();
            }
            string3 = !bl3 ? this.addLine(string3, this.generateTestReadOnlyPropertyCode(bl, propertySweepInfo, string4, string5, string6, n2 + 1)) : this.addLine(string3, this.generateTestAllValuesCode(bl, propertySweepInfo, string4, string5, string6, n2 + 1, n));
            if (!bl2) continue;
            string3 = this.addLine(string3, this.generateWarningCode(bl, string5, string4));
        }
        string3 = this.addLine(string3, "% If finalerrorcode is true, at least one property failed in Property Sweep. ");
        string3 = this.addLine(string3, "errorcode = finalerrorcode;");
        if (bl) {
            this.client.assignVariableInformation(new Integer(0));
        }
        return string3;
    }

    private String generateTestAllValuesCode(boolean bl, PropertySweepInfo propertySweepInfo, String string, String string2, String string3, int n, int n2) {
        Object object;
        String string4 = this.getDisplayFunction(bl);
        String string5 = this.getDisplayInsert(bl);
        boolean bl2 = false;
        String string6 = "";
        PropertyConstraint[] propertyConstraintArray = this.getPropertyConstraints(string2, string);
        for (int i = 0; i < propertyConstraintArray.length; ++i) {
            object = propertyConstraintArray[i];
            string6 = this.addConstraintValues(string6, (PropertyConstraint)object, n2);
        }
        string6 = "{" + string6 + "}";
        String string7 = this.addLine("\n", "% Valid values for the " + string + " property.");
        string7 = this.addLine(string7, "validValues = " + string6 + ";");
        string7 = this.addLine(string7, "");
        string7 = this.addLine(string7, "% Test all supported values.");
        string7 = this.addLine(string7, "for i = 1:length(validValues)");
        string7 = this.addTabbedLine(string7, "try");
        string7 = this.addTabbedLine(string7, "    % Configure the property.");
        if (string2.equals("parent")) {
            string7 = this.addTabbedLine(string7, "    set(deviceObj, '" + string + "', validValues{i});");
        } else {
            string7 = this.addTabbedLine(string7, "    groupObj = get(deviceObj, '" + string2 + "');");
            object = "All " + string2 + " group objects";
            if (!string3.equals(object)) {
                string7 = this.addTabbedLine(string7, "    groupObj = groupObj(" + n + ");");
            } else {
                bl2 = true;
            }
            string7 = this.addTabbedLine(string7, "    set(groupObj, '" + string + "', validValues{i});");
        }
        string7 = this.addLine(string7, "");
        string7 = this.addTabbedLine(string7, "    % Check if instrument error occurred.");
        string7 = this.addTabbedLine(string7, "    result = geterror(deviceObj);");
        if (propertySweepInfo.getNoErrorStepPass()) {
            string7 = this.addTabbedLine(string7, "    errorcode = ~strcmp(result, noErrorMsg);");
            string7 = this.addLine(string7, "");
            string7 = this.addTabbedLine(string7, this.postMessage(bl, "An instrument error occurred while setting the property value.", "result", true, "        "));
        }
        if (propertySweepInfo.getValueMatchesStepPass()) {
            string7 = this.addLine(string7, "");
            string7 = this.addTabbedLine(string7, "    % Verify that the configured value matches the expected value.");
            string7 = this.addTabbedLine(string7, "    if (errorcode == false)");
            string7 = this.addTabbedLine(string7, "        % Get the current property value.");
            string7 = string2.equals("parent") ? this.addTabbedLine(string7, "        tempOut = get(deviceObj, '" + string + "');") : (bl2 ? this.addTabbedLine(string7, "        tempOut = get(groupObj, {'" + string + "'});") : this.addTabbedLine(string7, "        tempOut = get(groupObj, '" + string + "');"));
            if (bl2) {
                string7 = this.addLine(string7, "");
                string7 = this.addTabbedLine(string7, "        % Compare to the expected value.");
                string7 = this.addTabbedLine(string7, "        expectedValue = cell(size(groupObj))';");
                string7 = this.addTabbedLine(string7, "        [expectedValue{:}] = deal(validValues{i});");
                string7 = this.addTabbedLine(string7, "        errorcode = ~isequal(tempOut, expectedValue);");
            } else {
                string7 = this.addLine(string7, "");
                string7 = this.addTabbedLine(string7, "        % Compare to the expected value.");
                string7 = this.addTabbedLine(string7, "        errorcode = ~isequal(tempOut, validValues{i});");
            }
            string7 = this.addTabbedLine(string7, "");
            string7 = this.addTabbedLine(string7, "        % Post information about test step failure.");
            string7 = this.addTabbedLine(string7, "        if (errorcode == true)");
            string7 = this.addTabbedLine(string7, "            " + string4 + "('The property is not configured to the expected value." + string5 + "');");
            if (!bl2) {
                string7 = this.addTabbedLine(string7, "");
                string7 = this.addTabbedLine(string7, "            % Post actual value.");
                string7 = this.addTabbedLine(string7, "            if isnumeric(tempOut)");
                string7 = this.addTabbedLine(string7, "                " + string4 + "(['Actual value: ' num2str(tempOut) '" + string5 + "']);");
                string7 = this.addTabbedLine(string7, "            else");
                string7 = this.addTabbedLine(string7, "                " + string4 + "(['Actual value: ' tempOut '" + string5 + "']);");
                string7 = this.addTabbedLine(string7, "            end");
                string7 = this.addTabbedLine(string7, "");
                string7 = this.addTabbedLine(string7, "            % Post expected value.");
                string7 = this.addTabbedLine(string7, "            if isnumeric(validValues{i})");
                string7 = this.addTabbedLine(string7, "                " + string4 + "(['Expected value: ' num2str(validValues{i}) '" + string5 + "']);");
                string7 = this.addTabbedLine(string7, "            else");
                string7 = this.addTabbedLine(string7, "                " + string4 + "(['Expected value: ' validValues{i} '" + string5 + "']);");
                string7 = this.addTabbedLine(string7, "            end");
                string7 = this.addTabbedLine(string7, "        end");
            } else {
                string7 = this.addTabbedLine(string7, "");
                string7 = this.addTabbedLine(string7, "            % Post actual value.");
                string7 = this.addTabbedLine(string7, "            for k=1:length(tempOut)");
                string7 = this.addTabbedLine(string7, "                c = tempOut{k};");
                string7 = this.addTabbedLine(string7, "                if isnumeric(c)");
                string7 = this.addTabbedLine(string7, "                    " + string4 + "(['Actual value(' num2str(k) '): ' num2str(c) '" + string5 + "']);");
                string7 = this.addTabbedLine(string7, "                else");
                string7 = this.addTabbedLine(string7, "                    " + string4 + "(['Actual value(' num2str(k) '): ' c '" + string5 + "']);");
                string7 = this.addTabbedLine(string7, "                end");
                string7 = this.addTabbedLine(string7, "            end");
                string7 = this.addTabbedLine(string7, "");
                string7 = this.addTabbedLine(string7, "            % Post expected value.");
                string7 = this.addTabbedLine(string7, "            if isnumeric(validValues{i})");
                string7 = this.addTabbedLine(string7, "                " + string4 + "(['Expected value: ' num2str(validValues{i}) '" + string5 + "']);");
                string7 = this.addTabbedLine(string7, "            else");
                string7 = this.addTabbedLine(string7, "                " + string4 + "(['Expected value: ' validValues{i} '" + string5 + "']);");
                string7 = this.addTabbedLine(string7, "            end");
                string7 = this.addTabbedLine(string7, "        end");
            }
            string7 = this.addLine(string7, "");
            string7 = this.addTabbedLine(string7, "        % Check if instrument error occurred.");
            string7 = this.addTabbedLine(string7, "        result = geterror(deviceObj);");
            if (propertySweepInfo.getNoErrorStepPass()) {
                string7 = this.addTabbedLine(string7, "        errorcode1 = ~strcmp(result, noErrorMsg);");
                string7 = this.addLine(string7, "");
                string7 = this.addTabbedLine(string7, "        % Post information about error if one occurred.");
                string7 = this.addTabbedLine(string7, "        if (errorcode1 == true)");
                string7 = this.addTabbedLine(string7, "            errorcode = errorcode1;");
                string7 = this.addTabbedLine(string7, "            " + string4 + "('An instrument error occurred while getting the property value." + string5 + "');");
                string7 = this.addTabbedLine(string7, "            " + string4 + "([result '" + string5 + "']);");
                string7 = this.addTabbedLine(string7, "        end");
            }
            string7 = this.addTabbedLine(string7, "    end");
        }
        string7 = this.addTabbedLine(string7, "catch aException");
        string7 = this.addTabbedLine(string7, "    % A MATLAB error occurred.");
        if (propertySweepInfo.getNoErrorStepPass()) {
            string7 = this.addTabbedLine(string7, "    errorcode = true;");
            string7 = this.addLine(string7, "");
            string7 = this.addTabbedLine(string7, "    % Post information about error.");
            string7 = this.addTabbedLine(string7, "    " + string4 + "('" + CodeGenerator.generateColorCode(bl, "\"#FF0000\"", "A MATLAB error occurred while testing the property.") + string5 + "');");
            string7 = this.addTabbedLine(string7, "    " + string4 + "(" + CodeGenerator.generateColorCodeToEval(bl, "\"#FF0000\"", "aException.message") + ");");
        }
        string7 = this.addTabbedLine(string7, "end");
        string7 = this.addTabbedLine(string7, "if (errorcode == true)");
        string7 = this.addTabbedLine(string7, "    finalerrorcode = true;");
        string7 = this.addTabbedLine(string7, "end");
        string7 = this.addLine(string7, "end");
        return string7;
    }

    private String generateTestReadOnlyPropertyCode(boolean bl, PropertySweepInfo propertySweepInfo, String string, String string2, String string3, int n) {
        String string4 = this.getDisplayFunction(bl);
        String string5 = this.getDisplayInsert(bl);
        String string6 = this.addLine(" \n", "try");
        string6 = this.addTabbedLine(string6, "% Query the value for the read-only property, " + string + ".");
        if (string2.equals("parent")) {
            string6 = this.addTabbedLine(string6, "get(deviceObj, '" + string + "');");
        } else {
            string6 = this.addTabbedLine(string6, "groupObj = get(deviceObj, '" + string2 + "');");
            String string7 = "All " + string2 + " group objects";
            if (!string3.equals(string7)) {
                string6 = this.addTabbedLine(string6, "groupObj = groupObj(" + n + ");");
                string6 = this.addTabbedLine(string6, "get(groupObj, '" + string + "');");
            } else {
                string6 = this.addTabbedLine(string6, "get(groupObj, {'" + string + "'});");
            }
        }
        string6 = this.addLine(string6, "");
        string6 = this.addTabbedLine(string6, "% Check if instrument error occurred.");
        string6 = this.addTabbedLine(string6, "result = geterror(deviceObj);");
        if (propertySweepInfo.getNoErrorStepPass()) {
            string6 = this.addTabbedLine(string6, "errorcode = ~strcmp(result, noErrorMsg);");
            string6 = this.addLine(string6, "");
            string6 = this.addTabbedLine(string6, this.postMessage(bl, "An instrument error occurred while getting the property value.", "result", true, "    "));
        }
        string6 = this.addLine(string6, "catch aException");
        string6 = this.addTabbedLine(string6, "% A MATLAB error occurred.");
        if (propertySweepInfo.getNoErrorStepPass()) {
            string6 = this.addTabbedLine(string6, "errorcode = true;");
            string6 = this.addLine(string6, "");
            string6 = this.addTabbedLine(string6, "% Post information about error.");
            string6 = this.addTabbedLine(string6, string4 + "('" + CodeGenerator.generateColorCode(bl, "\"#FF0000\"", "A MATLAB error occurred while getting the property value.") + string5 + "');");
            string6 = this.addTabbedLine(string6, string4 + "(" + CodeGenerator.generateColorCodeToEval(bl, "\"#FF0000\"", "aException.message") + ");");
        }
        string6 = this.addLine(string6, "end");
        return string6;
    }

    private String generateWarningCode(boolean bl, String string, String string2) {
        String string3 = this.getDisplayFunction(bl);
        String string4 = this.getDisplayInsert(bl);
        String string5 = "";
        boolean bl2 = true;
        if (!this.isPropertyHelpDefined(string, string2)) {
            bl2 = false;
            string5 = this.addLine(string5, "");
            string5 = this.addLine(string5, "% Post warnings.");
            string5 = this.addLine(string5, "warningOccurred = true;");
            string5 = this.addLine(string5, "stepWarningOccurred = true;");
            string5 = this.addLine(string5, string3 + "('" + CodeGenerator.generateColorCode(bl, "\"#0000FF\"", "Warning: No help is defined for the " + string2 + " property in the " + string + " group.") + string4 + "');");
        }
        if (!this.isDefaultValueDefined(string, string2)) {
            if (bl2) {
                string5 = this.addLine(string5, "");
                string5 = this.addLine(string5, "% Post warnings.");
                string5 = this.addLine(string5, "warningOccurred = true;");
                string5 = this.addLine(string5, "stepWarningOccurred = true;");
            }
            string5 = this.addLine(string5, string3 + "('" + CodeGenerator.generateColorCode(bl, "\"#0000FF\"", "Warning: No default value is defined for the " + string2 + " property in the " + string + " group.") + string4 + "');");
        }
        return string5;
    }

    private int getSelectedGroupIndex(String string, String[] stringArray, int[] nArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            if (string2.equals(string)) {
                return nArray[n];
            }
            ++n;
        }
        return 0;
    }

    private String getSelectedGroupName(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            if (!string2.equals(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public PropertyConstraint[] getPropertyConstraints(String string, String string2) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getParser().getPropertyInformation(string2, string);
        return propertyDefinition.getValidConstraints(this.getParser());
    }

    private String addConstraintValues(String string, PropertyConstraint propertyConstraint, int n) {
        String string2 = propertyConstraint.getCellArrayOfValues();
        if (!string2.equals("{}")) {
            if (string.equals("")) {
                return string2.substring(1, string2.length() - 1);
            }
            return string + ", " + string2.substring(1, string2.length() - 1);
        }
        string2 = propertyConstraint.getCellArrayOfValues(n);
        if (!string2.equals("{}")) {
            if (string.equals("")) {
                return string2.substring(1, string2.length() - 1);
            }
            return string + ", " + string2.substring(1, string2.length() - 1);
        }
        return string;
    }

    public boolean isDefaultValueDefined(String string, String string2) {
        if (string2.equals("InstrumentModel")) {
            return true;
        }
        Object object = ((PropertyDefinition)this.getParser().getPropertyInformation(string2, string)).getDriverDefinedDefalutValue();
        return object != null;
    }

    public boolean isPropertyHelpDefined(String string, String string2) {
        if (string2.equals("InstrumentModel")) {
            return true;
        }
        String string3 = ((PropertyDefinition)this.getParser().getPropertyInformation(string2, string)).getDescription();
        return string3 != null && !string3.equals("");
    }

    public class PropertyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return PropertySweepPanel.this.headings.length;
        }

        @Override
        public int getRowCount() {
            if (PropertySweepPanel.this.data == null) {
                return 0;
            }
            return PropertySweepPanel.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return PropertySweepPanel.this.headings[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return PropertySweepPanel.this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ((PropertySweepPanel)PropertySweepPanel.this).data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 1;
        }
    }
}

