/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest;

import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.StepInfo;
import com.mathworks.toolbox.instrument.guiutil.ICSaveDialog;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class CodeGenerator {
    public static final String FAIL_COLOR = "\"#FF0000\"";
    public static final String PASS_COLOR = "\"#008000\"";
    public static final String WARNING_COLOR = "\"#0000FF\"";
    public static final String FAIL_MSG = "FAILED";
    public static final String PASS_MSG = "PASSED";
    public static final String WARNING_MSG = "PASSED with warnings";
    public static final String TAB = "    ";
    private MIDTestToolClient client;
    private String fileNameWithPath;
    private String functionName;

    public CodeGenerator(MIDTestToolClient mIDTestToolClient) {
        this.client = mIDTestToolClient;
    }

    public void generateMCode() {
        if (!ICSaveDialog.save(".m", "Save MATLAB Instrument Driver Test Code", "MATLAB Files (*.m)", this.client.getBrowserFrame())) {
            return;
        }
        this.fileNameWithPath = ICSaveDialog.getFileNameWithPath();
        String string = this.generateCode(false, true, 0, this.client.getRoot().getChildCount() - 1);
        try {
            File file = new File(this.fileNameWithPath);
            FileWriter fileWriter = new FileWriter(file);
            this.functionName = file.getName();
            int n = this.functionName.indexOf(".");
            this.functionName = this.functionName.substring(0, n);
            String string2 = this.addLine("function varargout = " + this.functionName + "\n", this.generateComments());
            string = this.addLine(string2, string);
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("An error occurred while writing the Code.");
        }
    }

    public String generateDriverMethodCode(String string) {
        String string2 = this.addLine("function varargout = " + string + "(obj)\n", "");
        string2 = this.addLine(string2, "% Set the object variable name.");
        string2 = this.addLine(string2, "deviceObj = obj;");
        string2 = this.addLine(string2, "");
        string2 = this.addLine(string2, this.generateCode(false, false, 0, this.client.getRoot().getChildCount() - 1));
        return string2;
    }

    public String generateMCodeForTestRun(int n, int n2) {
        return this.generateCode(true, true, n, n2);
    }

    public String generateCode(boolean bl, boolean bl2, int n, int n2) {
        BrowserTreeNode browserTreeNode = this.client.getRoot();
        boolean bl3 = this.client.reportWarnings();
        int n3 = this.client.getNumberOfDoublesToTest();
        String string = CodeGenerator.getDisplayFunction(bl);
        String string2 = CodeGenerator.getDisplayInsert(bl);
        String string3 = this.addLine("% Wrap entire test in try catch.\n", "try");
        if (bl) {
            string3 = this.addLine(string3, "import com.mathworks.toolbox.instrument.device.guiutil.midtest.*;");
            string3 = this.addLine(string3, "");
        }
        string3 = this.addLine(string3, string + "('Test: " + this.makeValidForLabel(browserTreeNode.getName()) + string2 + "');");
        string3 = this.addLine(string3, string + "(['Start time: ' datestr(now) '" + string2 + "']);");
        string3 = bl ? this.addLine(string3, "MessageService.publish('<hr>')") : this.addLine(string3, "");
        string3 = this.addLine(string3, this.generateInitCode(bl2));
        for (int i = n; i < n2 + 1; ++i) {
            BrowserTreeNode browserTreeNode2 = (BrowserTreeNode)browserTreeNode.getChildAt(i);
            String string4 = "% Test Step " + (i + 1) + ": " + this.makeValidForLabel(browserTreeNode2.getName()) + " (" + MIDTestToolClient.STEP_NAMES[browserTreeNode2.getType()] + " Test Step)";
            string3 = this.addLine(string3, string4);
            if (bl) {
                string3 = this.addLine(string3, "MessageService.publish('" + string4.substring(2) + "');");
                string3 = this.addLine(string3, "");
                string3 = this.addLine(string3, "% Verify that the test is still running.");
                string3 = this.addLine(string3, "if (MIDTestToolClient.isTestRunning == false)");
                string3 = this.addLine(string3, "    MessageService.publish('<hr>')");
                string3 = this.addLine(string3, "    MessageService.publish('Test has been stopped.')");
                string3 = this.addLine(string3, "    MessageService.publish(['Stop time: ' datestr(now)]);");
                string3 = this.addLine(string3, "    MessageService.publish('Test status: " + CodeGenerator.generateColorCode(true, WARNING_COLOR, "INCOMPLETE") + "');");
                string3 = this.addLine(string3, "");
                if (bl2) {
                    string3 = this.addLine(string3, "    % Cleanup.");
                    string3 = this.addLine(string3, "    if exist('interfaceObj') && (okToDeleteInterfaceObj == true)");
                    string3 = this.addLine(string3, "        delete(interfaceObj)");
                    string3 = this.addLine(string3, "    end");
                    string3 = this.addLine(string3, "");
                    string3 = this.addLine(string3, "    if exist('deviceObj')");
                    string3 = this.addLine(string3, "        delete(deviceObj)");
                    string3 = this.addLine(string3, "    end");
                }
                string3 = this.addLine(string3, "    return");
                string3 = this.addLine(string3, "end");
                string3 = this.addLine(string3, "");
                this.client.assignVariableInformation(MIDTestToolClient.STEP_NAMES[browserTreeNode2.getType()] + " (" + (i + 1) + ")");
                this.client.assignVariableInformation(this.makeValidForMatlabVariable(((StepInfo)browserTreeNode2.getUserData()).getName()));
            }
            if (bl3) {
                string3 = this.addLine(string3, "% Reset the test step warning flag.");
                string3 = this.addLine(string3, "stepWarningOccurred = false;");
                string3 = this.addLine(string3, "");
            }
            String string5 = this.client.getStepPanel().generateCode(browserTreeNode2, bl, bl3, n3);
            string3 = this.addLine(string3, string5);
            if (!string5.equals("")) {
                string3 = this.addLine(string3, "% Post message indicating if test step passed.");
                string3 = this.addLine(string3, "if (errorcode == true)");
                string3 = this.addLine(string3, "    errorOccurred = true;");
                string3 = this.addLine(string3, TAB + string + "('Test step status: " + CodeGenerator.generateColorCode(bl, FAIL_COLOR, FAIL_MSG) + string2 + "');");
                string3 = this.addLine(string3, "elseif (stepWarningOccurred == true)");
                string3 = this.addLine(string3, TAB + string + "('Test step status: " + CodeGenerator.generateColorCode(bl, WARNING_COLOR, WARNING_MSG) + string2 + "');");
                string3 = this.addLine(string3, "else");
                string3 = this.addLine(string3, TAB + string + "('Test step status: " + CodeGenerator.generateColorCode(bl, PASS_COLOR, PASS_MSG) + string2 + "');");
                string3 = this.addLine(string3, "end");
                string3 = this.addLine(string3, "");
            }
            if (this.client.getFailAction() != 0 && !string5.equals("")) {
                string3 = this.addLine(string3, "% Handle the error if one occurred.");
                string3 = this.addLine(string3, "if (errorcode == true)");
                string3 = this.addLine(string3, this.generateFailActionCode(bl, bl2));
                string3 = this.addLine(string3, "end");
                string3 = this.addLine(string3, " ");
            }
            if (string5.equals("")) {
                string3 = this.addLine(string3, "% This test step generated no code. Most likely because a");
                string3 = this.addLine(string3, "% property or function to test was not selected.");
                string3 = this.addLine(string3, string + "('Test step status: " + CodeGenerator.generateColorCode(bl, PASS_COLOR, PASS_MSG) + string2 + "');");
                string3 = this.addLine(string3, "");
            }
            if (!bl) continue;
            string3 = this.addLine(string3, "MessageService.publish('<hr>')");
            string3 = this.addLine(string3, "");
        }
        if (bl2) {
            string3 = this.addLine(string3, "% Cleanup.");
            string3 = this.addLine(string3, "disconnect(deviceObj);");
            string3 = this.addLine(string3, "delete(deviceObj);");
            string3 = this.addLine(string3, "");
            string3 = this.addLine(string3, "if exist('interfaceObj') && (okToDeleteInterfaceObj == true)");
            string3 = this.addLine(string3, "    delete(interfaceObj);");
            string3 = this.addLine(string3, "end");
            string3 = this.addLine(string3, "");
        }
        string3 = this.addLine(string3, "% Post results.");
        string3 = this.addLine(string3, string + "(['Stop time: ' datestr(now) '" + string2 + "']);");
        string3 = this.addLine(string3, "if (errorOccurred == true)");
        string3 = this.addLine(string3, TAB + string + "('Test status: " + CodeGenerator.generateColorCode(bl, FAIL_COLOR, FAIL_MSG) + string2 + "');");
        string3 = this.addLine(string3, "elseif (warningOccurred == true)");
        string3 = this.addLine(string3, TAB + string + "('Test status: " + CodeGenerator.generateColorCode(bl, WARNING_COLOR, WARNING_MSG) + string2 + "');");
        string3 = this.addLine(string3, "else");
        string3 = this.addLine(string3, TAB + string + "('Test status: " + CodeGenerator.generateColorCode(bl, PASS_COLOR, PASS_MSG) + string2 + "');");
        string3 = this.addLine(string3, "end");
        string3 = this.addLine(string3, "");
        string3 = this.addLine(string3, "catch aException");
        string3 = this.addLine(string3, "    % An error occurred while running the test.");
        if (bl) {
            string3 = this.addLine(string3, "    MessageService.publish('<hr>')");
        }
        string3 = this.addLine(string3, TAB + string + "('" + CodeGenerator.generateColorCode(bl, FAIL_COLOR, "An error occurred while executing the test.") + string2 + "');");
        string3 = this.addLine(string3, TAB + string + "(" + CodeGenerator.generateColorCodeToEval(bl, FAIL_COLOR, "aException.message") + ");");
        string3 = this.addLine(string3, "");
        if (bl2) {
            string3 = this.addLine(string3, "    % Cleanup.");
            string3 = this.addLine(string3, "    if exist('interfaceObj') && (okToDeleteInterfaceObj == true)");
            string3 = this.addLine(string3, "        delete(interfaceObj)");
            string3 = this.addLine(string3, "    end");
            string3 = this.addLine(string3, "");
            string3 = this.addLine(string3, "    if exist('deviceObj')");
            string3 = this.addLine(string3, "        delete(deviceObj)");
            string3 = this.addLine(string3, "    end");
        }
        string3 = this.addLine(string3, "end");
        return string3;
    }

    public static String generateColorCode(boolean bl, String string, String string2) {
        if (!bl) {
            return string2;
        }
        return "<font color=" + string + ">" + string2 + "</font>";
    }

    public static String generateColorCodeToEval(boolean bl, String string, String string2) {
        if (!bl) {
            return "[" + string2 + " '" + CodeGenerator.getDisplayInsert(bl) + "']";
        }
        return "['<font color=" + string + ">' " + string2 + " '</font>']";
    }

    private String generateInitCode(boolean bl) {
        String string = this.addLine("% Initialize variables.\n", "varargout              = {};");
        string = this.addLine(string, "noErrorMsg             = '" + this.client.getNoErrorMessage() + "';");
        string = this.addLine(string, "stepWarningOccurred    = false;");
        string = this.addLine(string, "warningOccurred        = false;");
        string = this.addLine(string, "errorOccurred          = false;");
        if (bl) {
            string = this.addLine(string, "okToDeleteInterfaceObj = true;");
        }
        string = this.addLine(string, " ");
        if (!bl) {
            return string;
        }
        string = this.addLine(string, this.client.getSetupPanel().generateCode());
        string = this.addLine(string, "% Connect the device object to the instrument.");
        string = this.addLine(string, "connect(deviceObj);");
        string = this.addLine(string, "");
        return string;
    }

    private String generateFailActionCode(boolean bl, boolean bl2) {
        switch (this.client.getFailAction()) {
            case 0: {
                return "";
            }
            case 2: {
                if (bl) {
                    return "    MessageService.publish('<hr>')\n" + this.generateResultsCode(bl) + "\n" + this.generateCleanupCode(bl2) + "\n" + TAB + "return;";
                }
                return this.generateResultsCode(bl) + "\n" + this.generateCleanupCode(bl2) + "\n" + TAB + "return;";
            }
            case 1: {
                return "    devicereset(deviceObj);";
            }
            case 3: {
                if (bl) {
                    return "    devicereset(deviceObj);\n    MessageService.publish('<hr>')\n" + this.generateResultsCode(bl) + "\n" + this.generateCleanupCode(bl2) + "\n" + TAB + "return;";
                }
                return "    devicereset(deviceObj);\n" + this.generateResultsCode(bl) + "\n" + this.generateCleanupCode(bl2) + "\n" + TAB + "return;";
            }
        }
        return "";
    }

    private String generateResultsCode(boolean bl) {
        String string = CodeGenerator.getDisplayFunction(bl);
        String string2 = CodeGenerator.getDisplayInsert(bl);
        String string3 = "";
        string3 = this.addLine(string3, "    % Post results.");
        string3 = this.addLine(string3, TAB + string + "(['Stop time: ' datestr(now) '" + string2 + "']);");
        string3 = this.addLine(string3, "    if (errorOccurred == true)");
        string3 = this.addLine(string3, "        " + string + "('Test status: " + CodeGenerator.generateColorCode(bl, FAIL_COLOR, FAIL_MSG) + string2 + "');");
        string3 = this.addLine(string3, "    elseif (warningOccurred == true)");
        string3 = this.addLine(string3, "        " + string + "('Test status: " + CodeGenerator.generateColorCode(bl, WARNING_COLOR, WARNING_MSG) + string2 + "');");
        string3 = this.addLine(string3, "    else");
        string3 = this.addLine(string3, "        " + string + "('Test status: " + CodeGenerator.generateColorCode(bl, PASS_COLOR, PASS_MSG) + string2 + "');");
        string3 = this.addLine(string3, "    end");
        return string3;
    }

    private String generateCleanupCode(boolean bl) {
        if (!bl) {
            return "";
        }
        String string = "";
        string = this.addLine(string, "    % Cleanup.");
        string = this.addLine(string, "    if exist('interfaceObj') && (okToDeleteInterfaceObj == true)");
        string = this.addLine(string, "        delete(interfaceObj)");
        string = this.addLine(string, "    end");
        string = this.addLine(string, "");
        string = this.addLine(string, "    if exist('deviceObj')");
        string = this.addLine(string, "        delete(deviceObj)");
        string = this.addLine(string, "    end");
        return string;
    }

    private String generateComments() {
        String string = this.addLine("%   " + this.functionName.toUpperCase() + " Code for testing a MATLAB instrument driver.\n", "%");
        string = this.addLine(string, "%   This is the machine generated code that tests a MATLAB instrument driver, ");
        string = this.addLine(string, "%   " + this.client.getSetupPanel().getDriverName() + ".");
        string = this.addLine(string, "%   ");
        string = this.addLine(string, "%   The test consists of multiple test steps that can test the MATLAB instrument");
        string = this.addLine(string, "%   drivers functions and properties.");
        string = this.addLine(string, "%   ");
        string = this.addLine(string, "%   The test code was generated with the MIDTEST GUI. For more information");
        string = this.addLine(string, "%   on MIDTEST, type 'instrhelp midtest' at the MATLAB command prompt.");
        string = this.addLine(string, "%   ");
        string = this.addLine(string, "%   To run the test, type the name of the file, " + this.functionName + ", at the MATLAB");
        string = this.addLine(string, "%   command prompt.");
        string = this.addLine(string, "% ");
        string = this.addLine(string, "%   The file, " + this.functionName.toUpperCase() + ".M must be on your MATLAB PATH. For additional information ");
        string = this.addLine(string, "%   on setting your MATLAB PATH, type 'help addpath' at the MATLAB command ");
        string = this.addLine(string, "%   prompt.");
        string = this.addLine(string, "% ");
        string = this.addLine(string, "%   Example:");
        string = this.addLine(string, "%       " + this.functionName.toLowerCase() + ";");
        string = this.addLine(string, "% ");
        string = this.addLine(string, "%   See also ICDEVICE, MIDTEST.");
        string = this.addLine(string, "% ");
        string = this.addLine(string, " ");
        string = this.addLine(string, "%   Creation time: " + TMStringUtil.getDate());
        string = this.addLine(string, " ");
        return string;
    }

    public String generateDriverMethodDescription(String string) {
        String string2 = this.addLine(string.toUpperCase() + " Code for testing a MATLAB instrument driver.\n", " ");
        string2 = this.addLine(string2, "This is the machine generated code that tests a MATLAB instrument driver, ");
        string2 = this.addLine(string2, this.client.getSetupPanel().getDriverName() + ".");
        string2 = this.addLine(string2, "");
        string2 = this.addLine(string2, "The test consists of multiple test steps that can test the MATLAB instrument");
        string2 = this.addLine(string2, "drivers functions and properties.");
        string2 = this.addLine(string2, "");
        string2 = this.addLine(string2, "The test code was generated with the MIDTEST GUI. For more information");
        string2 = this.addLine(string2, "on MIDTEST, type 'instrhelp midtest' at the MATLAB command prompt.");
        string2 = this.addLine(string2, "");
        string2 = this.addLine(string2, "");
        string2 = this.addLine(string2, "Creation time: " + TMStringUtil.getDate());
        string2 = this.addLine(string2, "");
        string2 = this.addLine(string2, "Example:");
        string2 = this.addLine(string2, "    out = invoke(deviceObj, '" + string + "');");
        string2 = this.addLine(string2, " ");
        string2 = this.addLine(string2, "See also ICDEVICE, MIDTEST, METHODS.");
        string2 = this.addLine(string2, "");
        return string2;
    }

    private String addLine(String string, String string2) {
        return string + string2 + "\n";
    }

    private static String getDisplayFunction(boolean bl) {
        String string = "fprintf";
        if (bl) {
            string = "MessageService.publish";
        }
        return string;
    }

    private static String getDisplayInsert(boolean bl) {
        if (bl) {
            return "";
        }
        return "\\n";
    }

    private String makeValidForLabel(String string) {
        string = string.replaceAll("[']", "''");
        return string;
    }

    private String makeValidForMatlabVariable(String string) {
        string = string.replaceAll("[']", "");
        return string;
    }
}

