/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.editors;

import com.mathworks.beans.editors.ApplyPropertyEditor;
import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.device.InstrumentDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.XMLDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.instrument.device.editors.MultipleConstraintEditorData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public final class MultipleConstraintEditor
extends MWPropertyEditorSupport
implements EnhancedPropertyEditor,
ApplyPropertyEditor {
    public static final String VALUE_KEY = "EnumTags";
    private Image icon;
    private JPanel outerPanel;
    private JPanel valuePanel;
    private ButtonGroup buttonGroup;
    private String propertyName;
    private String type;
    private int numOfConstraints = 0;
    private InstrumentDriver driver;
    private Hashtable<JRadioButton, PropertyConstraint> constraintTable = new Hashtable();

    public Component getCustomEditor() {
        if (this.outerPanel == null) {
            this.layoutPanel();
        } else {
            this.update();
        }
        int n = this.numOfConstraints * 28 + 25;
        this.outerPanel.setPreferredSize(new Dimension(300, n));
        return this.outerPanel;
    }

    private void update() {
        this.removeAllRadioButtons(this.buttonGroup);
        this.constraintTable = null;
        this.constraintTable = new Hashtable();
        this.outerPanel.remove(this.valuePanel);
        this.valuePanel = this.createValuePanel();
        this.outerPanel.add((Component)this.valuePanel, "Center");
    }

    private void layoutPanel() {
        this.outerPanel = new JPanel(new BorderLayout(5, 5));
        this.outerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.outerPanel.add((Component)this.createInstructionPanel(), "North");
        this.valuePanel = this.createValuePanel();
        this.outerPanel.add((Component)this.valuePanel, "Center");
    }

    private JPanel createInstructionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(jPanel.getBackground());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        JTextArea jTextArea = new JTextArea();
        jPanel.add((Component)jTextArea, "Center");
        jTextArea.setBackground(jPanel.getBackground());
        jTextArea.setText("Select the value to configure the property to.");
        jTextArea.setFont(new Font("Dialog", 0, 12));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        return jPanel;
    }

    private JPanel createValuePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        PropertyDefinition propertyDefinition = (PropertyDefinition)((XMLDriver)((Object)this.driver)).getPropertyDefinition(this.propertyName, this.type);
        PropertyConstraint[] propertyConstraintArray = propertyDefinition.getValidConstraints((XMLDriver)((Object)this.driver));
        this.numOfConstraints = propertyConstraintArray.length;
        JPanel jPanel2 = new JPanel(new GridLayout(propertyConstraintArray.length, 1, 2, 2));
        JPanel jPanel3 = new JPanel(new GridLayout(propertyConstraintArray.length, 1, 2, 2));
        this.buttonGroup = new ButtonGroup();
        for (int i = 0; i < propertyConstraintArray.length; ++i) {
            JRadioButton jRadioButton = new JRadioButton();
            this.buttonGroup.add(jRadioButton);
            jPanel2.add(jRadioButton);
            jPanel3.add(propertyConstraintArray[i].getPanel());
            this.constraintTable.put(jRadioButton, propertyConstraintArray[i]);
        }
        this.selectIndexInButtonGroup(this.buttonGroup, 0);
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, "West");
        jPanel4.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "North");
        return jPanel;
    }

    public void apply() {
        JRadioButton jRadioButton = this.getSelectedRadioButtonInButtonGroup(this.buttonGroup);
        PropertyConstraint propertyConstraint = this.constraintTable.get(jRadioButton);
        this.setValue(propertyConstraint.getPanelValue());
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public boolean supportsInPlaceEditing() {
        return false;
    }

    public boolean canApply() {
        return true;
    }

    public boolean isPaintable() {
        return false;
    }

    public Image getIcon() {
        if (this.icon == null) {
            ImageIcon imageIcon = new ImageIcon(InstrumentControlBrowser.class.getResource("/com/mathworks/toolbox/instrument/resources/enumerated_bounded.gif"));
            this.icon = imageIcon.getImage();
        }
        return this.icon;
    }

    public void setFrame(Frame frame) {
    }

    public boolean hasAttachedData() {
        return true;
    }

    public String getDataKey() {
        return VALUE_KEY;
    }

    public void setData(Object object) {
        if (object instanceof MultipleConstraintEditorData) {
            MultipleConstraintEditorData multipleConstraintEditorData = (MultipleConstraintEditorData)object;
            this.propertyName = multipleConstraintEditorData.getPropertyName();
            this.driver = multipleConstraintEditorData.getDriver();
            this.type = multipleConstraintEditorData.getType();
        }
    }

    private void selectIndexInButtonGroup(ButtonGroup buttonGroup, int n) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (n2 == n) {
                jRadioButton.setSelected(true);
                break;
            }
            ++n2;
        }
    }

    private JRadioButton getSelectedRadioButtonInButtonGroup(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            if (!jRadioButton.isSelected()) continue;
            return jRadioButton;
        }
        return null;
    }

    private void removeAllRadioButtons(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
            buttonGroup.remove(jRadioButton);
        }
    }
}

