/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.xml.property;

import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class DoubleEnumProperty
extends PropertyConstraint {
    private Vector<String> values = new Vector();
    private double[] validValues;
    private JComboBox valueComboBox = null;

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getConstraint() {
        return 1;
    }

    @Override
    public Object getDefaultValue() {
        Object[] objectArray = this.getConstraintValues();
        if (objectArray == null || objectArray.length == 0) {
            return String.valueOf(0);
        }
        return String.valueOf(objectArray[0]);
    }

    @Override
    public Object[] getConstraintValues() {
        if (this.validValues == null) {
            this.createValidValuesArray();
        }
        Object[] objectArray = new Double[this.validValues.length];
        for (int i = 0; i < this.validValues.length; ++i) {
            objectArray[i] = new Double(this.validValues[i]);
        }
        return objectArray;
    }

    @Override
    public void addValue(String string) {
        this.values.addElement(string);
    }

    @Override
    public boolean isValidValue(Object object) {
        if (object instanceof Double) {
            return this.isValidValue((Double)object);
        }
        if (object instanceof String && TMStringUtil.isdouble((String)((String)object))) {
            return this.isValidValue(Double.valueOf((String)object));
        }
        return false;
    }

    public boolean isValidValue(double d) {
        if (this.validValues == null) {
            this.createValidValuesArray();
        }
        for (int i = 0; i < this.validValues.length; ++i) {
            if (d != this.validValues[i]) continue;
            return true;
        }
        return false;
    }

    private void createValidValuesArray() {
        this.validValues = new double[this.values.size()];
        for (int i = 0; i < this.validValues.length; ++i) {
            this.validValues[i] = TMStringUtil.str2double((String)this.values.elementAt(i));
        }
    }

    @Override
    public String getSetList() {
        if (this.validValues == null) {
            this.createValidValuesArray();
        }
        if (this.validValues.length == 0) {
            return "";
        }
        String string = "[ ";
        for (int i = 0; i < this.validValues.length; ++i) {
            string = string + this.validValues[i] + " | ";
        }
        return string.substring(0, string.length() - 2) + "]";
    }

    @Override
    public String getSetError() {
        if (this.validValues == null) {
            this.createValidValuesArray();
        }
        if (this.validValues.length == 0) {
            return "";
        }
        String string = "";
        for (int i = 0; i < this.validValues.length; ++i) {
            string = string + this.validValues[i] + ", ";
        }
        return string.substring(0, string.length() - 2);
    }

    @Override
    public JPanel getPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.valueComboBox = new JComboBox();
        for (int i = 0; i < this.values.size(); ++i) {
            this.valueComboBox.addItem(this.values.elementAt(i));
        }
        jPanel.add(this.valueComboBox);
        Dimension dimension = this.valueComboBox.getPreferredSize();
        if (dimension.width < 93) {
            dimension.width = 93;
        }
        this.valueComboBox.setPreferredSize(dimension);
        return jPanel;
    }

    @Override
    public Object getPanelValue() {
        return this.valueComboBox.getSelectedItem();
    }

    @Override
    public void setPanelValue(Object object) {
        this.valueComboBox.setSelectedItem(object);
    }

    @Override
    public String getCellArrayOfValues() {
        String string = "";
        Object[] objectArray = this.getConstraintValues();
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + String.valueOf(objectArray[i]) + ", ";
        }
        string = string.substring(0, string.length() - 2);
        string = "{" + string + "}";
        return string;
    }
}

