/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.xml;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.toolbox.instrument.device.PropertyInfo;
import com.mathworks.toolbox.instrument.device.drivers.xml.MethodDefinition;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Vector;

public abstract class XMLDriver {
    protected static boolean OK_TO_WARN = true;
    protected Parser xmlParser;
    protected String[] capabilityGroups = null;
    protected String driverName = "";
    protected String driverNameWithPath = "";
    protected int currentChannelIndex = 1;
    protected MatlabMCR matlabMCR = MatlabMCRFactory.getForCurrentMCR();
    protected String optionString = "";

    public static void isOKToWarn(boolean bl) {
        OK_TO_WARN = bl;
    }

    public Parser getParser() {
        return this.xmlParser;
    }

    public void setOptionString(String string) {
        this.optionString = string;
    }

    public String getOptionString() {
        return this.optionString;
    }

    public void setDriverName(String string) {
    }

    public String getCreateInitializationCode() {
        return this.xmlParser.getCreateInitializationCode();
    }

    public String getConnectInitializationCode() {
        return this.xmlParser.getConnectInitializationCode();
    }

    public String getCleanupCode() {
        return this.xmlParser.getCleanupCode();
    }

    public String getInstrumentType() {
        return this.xmlParser.getInstrumentType();
    }

    public String getDriverVersion() {
        return this.xmlParser.getInstrumentVersion();
    }

    public String getInstrumentManufacturer() {
        return this.xmlParser.getInstrumentManufacturer();
    }

    public String getHwInstrumentModel() {
        return this.xmlParser.getInstrumentModel();
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String parseDriverName(String string) {
        int n = string.lastIndexOf("\\");
        if (n == -1) {
            n = string.lastIndexOf("/");
        }
        this.driverName = n != -1 ? string.substring(n + 1) : string;
        return this.driverName;
    }

    public String[] getAvailableCapabilityGroups() {
        if (this.capabilityGroups == null) {
            this.capabilityGroups = TMStringUtil.vector2StringArray(this.xmlParser.getCapabilityGroups());
        }
        return this.capabilityGroups;
    }

    public String[] getCapabilityGroupProperties(String string) {
        return TMStringUtil.vector2StringArray(this.xmlParser.getCapabilityGroupProperties(string));
    }

    public String[] getCapabilityGroupMethods(String string) {
        return TMStringUtil.vector2StringArray(this.xmlParser.getCapabilityGroupMethods(string));
    }

    public void setGroupSize(String string, int n) {
        this.xmlParser.setGroupSize(string, n);
    }

    public void setGroupObjectName(String string, int n, String string2) {
        this.xmlParser.setGroupObjectName(string, n, string2);
    }

    public String[] getMethods(String string) throws TMException {
        return TMStringUtil.vector2StringArray(this.xmlParser.getMethods(string));
    }

    public MethodDefinition getMethodDefinition(String string, String string2) throws TMException {
        MethodDefinition methodDefinition = this.xmlParser.getMethodDefinition(string, string2);
        if (methodDefinition == null) {
            TMStringUtil.error((String)("Invalid method: " + string + "."));
        }
        return methodDefinition;
    }

    public String getMethodType(String string, String string2) throws TMException {
        return this.getMethodDefinition(string, string2).getLocation();
    }

    public boolean isMethodMCode(String string, String string2) throws TMException {
        return this.getMethodDefinition(string, string2).getType().equals("MCode");
    }

    public String getMethodMCode(String string, String string2) throws TMException {
        return this.getMethodDefinition(string, string2).getMCodeToEvaluate();
    }

    public String getMethodHelp(String string, String string2) throws TMException {
        MethodDefinition methodDefinition = this.getMethodDefinition(string, string2);
        String string3 = methodDefinition.getDescription();
        if (string3 == null || string3.equals("")) {
            string3 = methodDefinition.getInvokeCommand();
        }
        return string3;
    }

    public String getMethodSignature(String string, String string2) throws TMException {
        return this.getMethodDefinition(string, string2).getSignature();
    }

    public Vector<String> getPropertyGroups() {
        return this.xmlParser.getPropertyGroups();
    }

    public int getPropertyGroupSize(String string) {
        return this.xmlParser.getGroupSize(string);
    }

    public String getGroupName(String string, int n) {
        return this.xmlParser.getGroupCommandNameAt(string, n);
    }

    public String getGroupHelp(String string) {
        return this.xmlParser.getGroupDescription(string);
    }

    public Vector<String> getProperties(String string) {
        return this.xmlParser.getProperties(string);
    }

    public boolean isPropertyTypeMCode(String string, String string2) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        return propertyDefinition.isPropertyTypeMCode();
    }

    public String getPropertySetMCode(String string, String string2) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        return propertyDefinition.getSetMCodeToEvaluate();
    }

    public String getPropertyGetMCode(String string, String string2) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        return propertyDefinition.getGetMCodeToEvaluate();
    }

    public String findLocationOfProperty(String string) {
        return this.xmlParser.findLocationOfProperty(string);
    }

    public Object getDefaultValue(String string, String string2) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        propertyDefinition.configurePropInfo(this);
        String string3 = (String)propertyDefinition.getDefaultValue();
        return propertyDefinition.getOutputValue(string3);
    }

    public Object getDisplayValue(String string, String string2, int n) {
        this.currentChannelIndex = n;
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        return propertyDefinition.getDisplayValue(this, string2, n);
    }

    public Object getDisplayValue(String string, String string2) {
        this.currentChannelIndex = -1;
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        return propertyDefinition.getDisplayValue(this, string2);
    }

    public void setCurrentValue(String string, String string2, Object object) {
        ((PropertyDefinition)this.getPropertyDefinition(string, string2)).setCurrentValue(object);
    }

    public void setCurrentValue(String string, String string2, Object object, int n) {
        ((PropertyDefinition)this.getPropertyDefinition(string, string2)).setCurrentValue(object, n);
    }

    public PropertyInfo getPropertyInformation(String string, String string2) {
        PropertyInfo propertyInfo = this.xmlParser.getPropertyInformation(string, string2);
        ((PropertyDefinition)propertyInfo).configurePropInfo(this);
        Object object = ((PropertyDefinition)propertyInfo).getOutputValue((String)propertyInfo.defaultValue);
        if (propertyInfo.type.equals("string") && propertyInfo.constraint.equals("none")) {
            return new PropertyInfo(propertyInfo.name, propertyInfo.type, propertyInfo.constraint, "", object, propertyInfo.readOnly, propertyInfo.interfaceSpecific, propertyInfo.hidden);
        }
        return new PropertyInfo(propertyInfo.name, propertyInfo.type, propertyInfo.constraint, propertyInfo.constraintValue, object, propertyInfo.readOnly, propertyInfo.interfaceSpecific, propertyInfo.hidden);
    }

    public PropertyInfo getPropertyDefinition(String string, String string2) {
        return this.xmlParser.getPropertyInformation(string, string2);
    }

    public PropertyDefinition[] getPropertyDefinitions(String string) {
        int n;
        Vector<String> vector = this.getProperties(string);
        if (vector == null) {
            vector = new Vector();
        }
        Vector<String> vector2 = this.getPropertyGroups();
        vector2.removeElement("parent");
        int n2 = vector.size();
        if (string.equals("parent")) {
            n2 += vector2.size();
        }
        PropertyDefinition[] propertyDefinitionArray = new PropertyDefinition[n2];
        int n3 = 0;
        for (n = 0; n < vector.size(); ++n) {
            propertyDefinitionArray[n3++] = (PropertyDefinition)this.getPropertyDefinition(vector.elementAt(n), string);
        }
        if (string.equals("parent")) {
            for (n = 0; n < vector2.size(); ++n) {
                propertyDefinitionArray[n3++] = this.getGroupPropertyDefinition(vector2.elementAt(n));
            }
        }
        if (n2 == 0) {
            return null;
        }
        return propertyDefinitionArray;
    }

    private PropertyDefinition getGroupPropertyDefinition(String string) {
        PropertyDefinition propertyDefinition = new PropertyDefinition(string, "group");
        propertyDefinition.setReadOnly("never");
        propertyDefinition.setType("object");
        propertyDefinition.setConstraint("none");
        propertyDefinition.setIsGroupProperty(true);
        return propertyDefinition;
    }

    public boolean isValidPropertyValue(String string, String string2, Object object) throws TMException {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        if (propertyDefinition.isValidValue(object, string2, this)) {
            return true;
        }
        TMStringUtil.error((String)propertyDefinition.getErrorMessage(this));
        return false;
    }

    public Object[] getValidRange(String string, String string2) {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        return propertyDefinition.getValidRange(this, string2);
    }

    public String getPropertyHelp(String string, String string2) throws TMException {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        if (propertyDefinition == null) {
            TMStringUtil.error((String)("Invalid property: " + string));
        }
        return propertyDefinition.getDescription();
    }

    public int getNumberOfEnums(String string, String string2) {
        return ((PropertyDefinition)this.getPropertyDefinition(string, string2)).getNumberOfEnums();
    }

    public String getSetList(String string, String string2) {
        return ((PropertyDefinition)this.getPropertyDefinition(string, string2)).getSetList(this);
    }

    public String getCommandToQueryHardware(String string, String string2) throws TMException {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        String string3 = propertyDefinition.getQueryCommand();
        String string4 = propertyDefinition.getLocation();
        if (this.xmlParser.isPropertyGroup(string4)) {
            string3 = this.xmlParser.substituteMappingInCommand(string4, string3, this.currentChannelIndex);
        }
        return string3;
    }

    public String getCommandToConfigureHardware(String string, String string2) throws TMException {
        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinition(string, string2);
        String string3 = propertyDefinition.getConfigureCommand();
        String string4 = propertyDefinition.getLocation();
        if (this.xmlParser.isPropertyGroup(string4)) {
            string3 = this.xmlParser.substituteMappingInCommand(string4, string3, this.currentChannelIndex);
        }
        return string3;
    }

    public abstract boolean isValidConstraint(String var1, String var2, String var3);
}

