/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.objects;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.UDP;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;

public class UDPObject
extends BrowserObject
implements Runnable {
    private static final String[] LOCALPORTMODE = new String[]{"auto", "manual"};
    private String remoteHost;
    private String remotePort;
    private String localHost = "";
    private Double localPort = null;
    private String localPortMode = "auto";
    private MLArrayRef terminator = null;
    private String datagramTerminateMode = "on";

    public UDPObject(String string, String string2, String string3, String string4) {
        super(string3, string4);
        if (string == null || string.length() == 0) {
            string = "127.0.0.1";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "9090";
        }
        this.remoteHost = string;
        this.remotePort = string2;
        Matlab.whenMatlabReady((Runnable)this);
    }

    @Override
    public void run() {
        try {
            Object[] objectArray = new Object[]{new Integer(45), "LF"};
            this.terminator = (MLArrayRef)Matlab.mtFeval((String)"system_dependent", (Object[])objectArray, (int)1);
        }
        catch (Exception exception) {
            System.out.println("TCPIPObject Exception: " + exception.getMessage());
        }
    }

    @Override
    public String[] getHeadingInfoColumnOne() {
        String[] stringArray = new String[]{"Address:", this.remoteHost, "Port:", this.remotePort, " ", " "};
        return stringArray;
    }

    @Override
    public String getDescriptiveText() {
        return this.remoteHost + ":" + this.remotePort;
    }

    @Override
    public String getType() {
        return "UDP";
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemotePort() {
        return this.remotePort;
    }

    public String getDatagramTerminateMode() {
        return this.datagramTerminateMode;
    }

    public void setDatagramTerminateMode(String string) {
        this.datagramTerminateMode = string;
        if (this.instrumentObject == null) {
            return;
        }
        ((UDP)this.instrumentObject).setDatagramTerminateMode(this.str2bool(this.datagramTerminateMode));
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String string) {
        if (this.instrumentObject == null) {
            this.localHost = string;
            return;
        }
        try {
            ((UDP)this.instrumentObject).setLocalHost(string);
            this.localHost = string;
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting LocalHost", (String)tMException.getMessage());
        }
    }

    public Double getLocalPort() {
        if (this.instrumentObject != null) {
            this.localPort = new Double(Integer.valueOf(((UDP)this.instrumentObject).getLocalPort()).doubleValue());
        }
        return this.localPort;
    }

    public void setLocalPort(Double d) {
        if (this.instrumentObject == null) {
            this.localPort = d;
            return;
        }
        try {
            ((UDP)this.instrumentObject).setLocalPort(d.intValue());
            this.localPort = d;
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting LocalPort", (String)tMException.getMessage());
        }
        this.getLocalPortMode();
    }

    public String getLocalPortMode() {
        if (this.instrumentObject != null) {
            this.localPortMode = LOCALPORTMODE[((UDP)this.instrumentObject).getLocalPortMode()];
        }
        return this.localPortMode;
    }

    public void setLocalPortMode(String string) {
        this.localPortMode = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((UDP)this.instrumentObject).setLocalPortMode(this.getIndex(LOCALPORTMODE, this.localPortMode));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting LocalPortMode", (String)tMException.getMessage());
        }
        this.getLocalPort();
    }

    public MLArrayRef getTerminator() {
        return this.terminator;
    }

    public void setTerminator(MLArrayRef mLArrayRef) {
        if (this.terminator != mLArrayRef) {
            this.terminator.dispose();
        }
        this.terminator = mLArrayRef;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((UDP)this.instrumentObject).setTerminator(this.terminator);
        }
        catch (Exception exception) {
            TMStringUtil.error((String)"Error Setting Terminator", (String)exception.getMessage());
        }
    }
}

