/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.ivicWrapper;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.driver.DriverPage;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.AddIviCInstrumentPage;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentObject;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentObjectStore;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviCInstrumentStore;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IviInstrumentInfo;
import com.mathworks.toolbox.instrument.browser.ivicWrapper.IvicInstrument;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IviCInstrumentPage
extends DriverPage
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private InstrumentControlBrowser fBrowser = null;
    private String fInstrumentType;
    private IvicInstrument fCurrentIviCInstrument;
    private MJList fResourcesListBox;
    private DefaultListModel fInstrumentListModel;
    private MJButton fAddInstrumentButton;
    private MJButton fScanInstrumentsButton;
    private MJButton fCreateIviCInstrumentObjButton;
    private MJPanel fResourcePanel;
    private MJLabel fInstrumentLabel;
    private MJLabel fTypeLabel;
    private MJLabel fPathLabel;

    public IviCInstrumentPage(InstrumentControlBrowser instrumentControlBrowser) {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layoutPanel();
        this.fBrowser = instrumentControlBrowser;
    }

    private void layoutPanel() {
        this.add(this.createHeadingPanel(), "North");
        this.fResourcePanel = this.createInstruemntInfoPanel();
        MJPanel mJPanel = this.add((JComponent)this.fResourcePanel, this.createButtonsPanel(), 4);
        this.add((Component)mJPanel, "Center");
    }

    private JPanel createHeadingPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(13, 0));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridLayout(3, 1, 0, 4));
        mJPanel2.add((Component)new MJLabel(sResources.getString("IviCInstrumentPage.InstrumentType")));
        mJPanel2.add((Component)new MJLabel(sResources.getString("IviCInstrumentPage.Path")));
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(3, 1, 0, 4));
        this.fTypeLabel = new MJLabel();
        this.fPathLabel = new MJLabel();
        mJPanel3.add((Component)this.fTypeLabel);
        mJPanel3.add((Component)this.fPathLabel);
        mJPanel.add((Component)mJPanel2, (Object)"West");
        mJPanel.add((Component)mJPanel3, (Object)"Center");
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Summary"));
        return mJPanel;
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 5));
        jPanel.setMinimumSize(new Dimension(400, 200));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, 5));
        this.fScanInstrumentsButton = new MJButton(sResources.getString("IviCInstrumentPage.ScanInstrument"));
        this.fScanInstrumentsButton.addActionListener((ActionListener)this);
        this.fAddInstrumentButton = new MJButton(sResources.getString("IviCInstrumentPage.AddInstrument"));
        this.fAddInstrumentButton.addActionListener((ActionListener)this);
        this.fCreateIviCInstrumentObjButton = new MJButton(sResources.getString("IviCInstrumentPage.CreateLabel"));
        this.fCreateIviCInstrumentObjButton.setEnabled(false);
        this.fCreateIviCInstrumentObjButton.addActionListener((ActionListener)this);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.fScanInstrumentsButton, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.fAddInstrumentButton, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)this.fCreateIviCInstrumentObjButton, "Center");
        Dimension dimension = this.fAddInstrumentButton.getPreferredSize();
        jPanel3.setMinimumSize(dimension);
        jPanel4.setMinimumSize(dimension);
        jPanel5.setMinimumSize(dimension);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel5);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private MJPanel createInstruemntInfoPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(4, 0));
        this.fInstrumentListModel = new DefaultListModel();
        this.fResourcesListBox = new MJList((ListModel)this.fInstrumentListModel);
        this.fResourcesListBox.setSelectionMode(0);
        this.fResourcesListBox.addListSelectionListener((ListSelectionListener)this);
        JScrollPane jScrollPane = new JScrollPane((Component)this.fResourcesListBox);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        this.fInstrumentLabel = new MJLabel();
        mJPanel.add((Component)this.fInstrumentLabel, (Object)"North");
        mJPanel.add((Component)jScrollPane, (Object)"Center");
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder("Resources"));
        return mJPanel;
    }

    @Override
    public void update(BrowserTreeNode browserTreeNode) {
        this.fInstrumentListModel.clear();
        this.fInstrumentType = (String)browserTreeNode.getUserData();
        this.fInstrumentLabel.setText("Available " + this.fInstrumentType + " instruments:");
        this.fCurrentIviCInstrument = IviCInstrumentStore.getIviCInstrument(this.fInstrumentType);
        this.fTypeLabel.setText(this.fCurrentIviCInstrument.getType());
        this.fPathLabel.setText(this.fCurrentIviCInstrument.getPath());
        if (this.fCurrentIviCInstrument.availableIviCInstruments == null) {
            this.fCurrentIviCInstrument.availableIviCInstruments = new Vector();
        }
        for (int i = 0; i < this.fCurrentIviCInstrument.availableIviCInstruments.size(); ++i) {
            IviInstrumentInfo iviInstrumentInfo = this.fCurrentIviCInstrument.availableIviCInstruments.get(i);
            this.fInstrumentListModel.addElement(iviInstrumentInfo.instrumentName == null ? iviInstrumentInfo.resource : iviInstrumentInfo.instrumentName);
        }
    }

    @Override
    public void cleanup() {
        this.fResourcesListBox.removeListSelectionListener((ListSelectionListener)this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    private void createIvicInstrumentObject() {
        Object object = this.fResourcesListBox.getSelectedValue();
        if (object == null) {
            JOptionPane.showMessageDialog(null, "Please select the instrument you want to communicate with!");
            return;
        }
        String string = IviCInstrumentObjectStore.generateObjName(this.fInstrumentType);
        if (string.length() == 0) {
            return;
        }
        int n = this.fResourcesListBox.getSelectedIndex();
        String string2 = this.fCurrentIviCInstrument.availableIviCInstruments.get((int)n).driverName;
        String string3 = this.fCurrentIviCInstrument.availableIviCInstruments.get((int)n).resource;
        IviCInstrumentObject iviCInstrumentObject = new IviCInstrumentObject(string, this.fInstrumentType, string3, string2, this.fBrowser);
    }

    private void getAvailableInstruments() {
        IviCInstrumentManager iviCInstrumentManager = new IviCInstrumentManager();
        iviCInstrumentManager.start();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fScanInstrumentsButton) {
            this.getAvailableInstruments();
            this.fCreateIviCInstrumentObjButton.setEnabled(false);
        } else if (actionEvent.getSource() == this.fAddInstrumentButton) {
            this.addInstrument();
        } else if (actionEvent.getSource() == this.fCreateIviCInstrumentObjButton) {
            this.createIvicInstrumentObject();
        }
    }

    private void addInstrument() {
        AddIviCInstrumentPage addIviCInstrumentPage = new AddIviCInstrumentPage(this.fInstrumentType);
        IviInstrumentInfo iviInstrumentInfo = addIviCInstrumentPage.getInstrument();
        if (iviInstrumentInfo == null) {
            return;
        }
        this.fCreateIviCInstrumentObjButton.setEnabled(true);
        this.fCurrentIviCInstrument.availableIviCInstruments.add(iviInstrumentInfo);
        this.fInstrumentListModel.addElement(iviInstrumentInfo.instrumentName);
    }

    private class IviCInstrumentManager
    extends MatlabWorker {
        private IviCInstrumentManager() {
        }

        public void runOnAWTEventDispatchThread(Object object) {
            IviCInstrumentPage.this.fInstrumentListModel.clear();
            ((IviCInstrumentPage)IviCInstrumentPage.this).fCurrentIviCInstrument.availableIviCInstruments.removeAllElements();
            IviCInstrumentPage.this.fBrowser.postBlockEventsEvent(false);
            if (object == null) {
                return;
            }
            String[] stringArray = (String[])object;
            try {
                for (int i = 0; i < stringArray.length; i += 3) {
                    ((IviCInstrumentPage)IviCInstrumentPage.this).fCurrentIviCInstrument.availableIviCInstruments.add(new IviInstrumentInfo(stringArray[i], stringArray[i + 1], stringArray[i + 2]));
                    IviCInstrumentPage.this.fInstrumentListModel.addElement(stringArray[i]);
                }
                IviCInstrumentPage.this.fCreateIviCInstrumentObjButton.setEnabled(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Object runOnMatlabThread() throws Exception {
            Object object = null;
            try {
                IviCInstrumentPage.this.fBrowser.postBlockEventsEvent(true);
                object = IviCInstrumentManager.feval((String)"instrument.internal.util.getIviInstruments", (Object[])new Object[]{"ivic", IviCInstrumentPage.this.fInstrumentType}, (int)1, (boolean)false);
            }
            catch (Exception exception) {
                IviCInstrumentPage.this.fBrowser.postBlockEventsEvent(false);
            }
            return object;
        }
    }
}

