/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationPage;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.browser.objects.SerialObject;
import com.mathworks.toolbox.instrument.guiutil.MatrixTableModel;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;

public class SerialHardwarePage
extends InstrumentControlBrowserPage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String[] headings = new String[]{"Port", "Identification"};
    private Object[][] data;
    private DefaultSortableTable table;
    private MatrixTableModel tableModel;
    private JButton scanButton;
    private JLabel lastScanDateLabel;
    private String initialDate;
    private InstrumentControlBrowser browser;
    private String[] path = new String[]{"Instrument Control Toolbox", "Hardware", "Serial"};
    private Object[] matlabArgs;
    private Vector<BrowserTreeNode> currentNodes = new Vector();
    private Vector<BrowserTreeNode> lastNodes = new Vector();
    private boolean disableOnStart = false;
    private boolean enableOnFinish = false;
    private ScanSerialRunnable scanSerialRunnable = null;

    public SerialHardwarePage(InstrumentControlBrowser instrumentControlBrowser) {
        this.browser = instrumentControlBrowser;
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.layoutPanel();
        this.matlabArgs = new Object[2];
        this.matlabArgs[0] = "privateBrowserHelper";
        this.matlabArgs[1] = "identifySerial";
        this.cleanup();
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 10));
        this.add(jPanel, "Center");
        this.tableModel = new MatrixTableModel(this.headings);
        this.tableModel.setData(this.data);
        this.table = new DefaultSortableTable((TableModel)this.tableModel);
        this.table.setName("Serial Hardware Table");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(1000);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.table);
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.setPreferredSize(new Dimension(50, 50));
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        this.initialDate = TMStringUtil.getDate();
        this.lastScanDateLabel = new JLabel("Last scan date: " + this.initialDate);
        jPanel2.add((Component)this.lastScanDateLabel, "West");
        jPanel2.add((Component)this.createButtonPanel(), "Center");
        jPanel.add((Component)jPanel2, "South");
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 0));
        this.scanButton = new JButton("Scan");
        this.scanButton.addActionListener(this);
        this.scanButton.setName("Serial Scan Button");
        jPanel2.add(this.scanButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void setup() {
        this.scanButton.addActionListener(this);
    }

    @Override
    public void cleanup() {
        this.scanButton.removeActionListener(this);
    }

    @Override
    public void dispose() {
        this.cleanup();
        this.headings = null;
        this.data = null;
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
        if (this.data == null) {
            return;
        }
        String string = this.lastScanDateLabel.getText();
        for (int i = 0; i < this.data.length; ++i) {
            String string2 = (String)this.data[i][1];
            if (string2.equals("No serial ports were found")) continue;
            Element element2 = browserConfigFileWriter.addNode(element, "Instrument");
            element2.setAttribute("Type", "serial");
            element2.setAttribute("LastScanDate", string);
            element2.setAttribute("Identification", (String)this.data[i][1]);
            element2.setAttribute("Port", (String)this.data[i][0]);
        }
    }

    public void load(String string, String string2, Element element) {
        this.lastScanDateLabel.setText(string2);
        int n = string2.indexOf(": ");
        string2 = string2.substring(n + 2);
        String string3 = element.getAttribute("Port");
        Object[] objectArray = new Object[]{string3, string};
        this.tableModel.append(objectArray);
        this.data = this.tableModel.getData();
        BrowserTreeNode browserTreeNode = this.createNode(string3, string, string2, this.data.length - 1);
        this.lastNodes.add(browserTreeNode);
    }

    public void addInitialNodes(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            BrowserTreeNode browserTreeNode = this.createNode(stringArray[i], "No instrument was identified", this.initialDate, i);
            this.lastNodes.add(browserTreeNode);
        }
        this.initTableData(stringArray);
    }

    private void initTableData(String[] stringArray) {
        this.data = null;
        if (stringArray == null) {
            return;
        }
        this.data = new Object[stringArray.length][this.headings.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.data[i][0] = stringArray[i];
            this.data[i][1] = "No instrument was identified";
        }
        if (this.tableModel != null) {
            this.tableModel.setData(this.data);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.disableOnStart = true;
        this.enableOnFinish = true;
        this.getGUIReadyForMATLABCall();
    }

    public void scanForAll() {
        this.disableOnStart = true;
        this.enableOnFinish = true;
        this.getGUIReadyForMATLABCall();
    }

    @Override
    public void scanForAll(boolean bl, boolean bl2) {
        this.disableOnStart = bl;
        this.enableOnFinish = bl2;
        this.getGUIReadyForMATLABCall();
    }

    public void getGUIReadyForMATLABCall() {
        this.scanButton.setEnabled(false);
        if (this.disableOnStart) {
            this.browser.postBlockEventsEvent(true);
        }
        this.browser.postStatusBarUpdateEvent("Scanning for serial instruments");
        Instrument.enableInstrumentObjectEvents(false);
        if (this.scanSerialRunnable == null) {
            this.scanSerialRunnable = new ScanSerialRunnable();
        }
        Matlab.whenMatlabReady((Runnable)this.scanSerialRunnable);
    }

    private void updateTableData(Object object) {
        if (this.headings == null) {
            return;
        }
        String string = TMStringUtil.getDate();
        this.lastScanDateLabel.setText("Last scan date: " + string);
        String[] stringArray = (String[])object;
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length / 2;
        }
        this.data = new Object[n][this.headings.length];
        int n2 = 0;
        if (this.data.length == 0) {
            this.data = new Object[1][this.headings.length];
            this.data[0][0] = "";
            this.data[0][1] = "No serial ports were found";
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i][0] = stringArray[n2++];
                this.data[i][1] = stringArray[n2++];
                BrowserTreeNode browserTreeNode = this.createNode((String)this.data[i][0], (String)this.data[i][1], string, i);
                this.currentNodes.add(browserTreeNode);
            }
        }
        if (this.tableModel != null) {
            this.tableModel.setData(this.data);
        }
        this.cleanupNodes();
    }

    private BrowserTreeNode createNode(String string, String string2, String string3, int n) {
        String string4 = this.defineNodeIDString(string2);
        BrowserTreeNode browserTreeNode = this.browser.getNode(this.path, string);
        if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(string + string4, (BrowserClient)this.browser);
            browserTreeNode.setType(4);
            browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\serial_instrument.html");
            browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "serial_config");
            SerialObject serialObject = new SerialObject(string, string2, string3, n);
            CommunicationPage communicationPage = CommunicationPage.getInstance(this.browser);
            CommunicationInfo communicationInfo = new CommunicationInfo(serialObject);
            this.browser.addToCommunicationInfoStore(communicationInfo);
            serialObject.setPanel(communicationPage);
            browserTreeNode.setPanel((JPanel)((Object)communicationPage));
            browserTreeNode.setUserData((Object)communicationInfo);
            this.browser.addNode(string, this.path, browserTreeNode);
        } else {
            CommunicationInfo communicationInfo = (CommunicationInfo)browserTreeNode.getUserData();
            BrowserObject browserObject = communicationInfo.getBrowserObject();
            browserObject.setIdentification(string2);
            browserObject.setScanDate(string3);
            browserTreeNode.setName(string + string4);
        }
        return browserTreeNode;
    }

    private String defineNodeIDString(String string) {
        String string2 = string;
        string2 = string2.equals("No instrument was identified") ? "" : " (" + string2 + ")";
        return string2;
    }

    private void cleanupNodes() {
        for (int i = 0; i < this.lastNodes.size(); ++i) {
            if (this.currentNodes.contains(this.lastNodes.elementAt(i))) continue;
            BrowserTreeNode browserTreeNode = this.lastNodes.elementAt(i);
            this.browser.removeNode(browserTreeNode.getName(), this.path, browserTreeNode.getUserData());
            this.browser.removeBrowserObjectFromCommunicationInfoStore((CommunicationInfo)browserTreeNode.getUserData());
        }
        this.lastNodes = this.currentNodes;
        this.currentNodes = null;
        this.currentNodes = new Vector();
    }

    public class ScanSerialRunnable
    implements Runnable,
    MatlabListener {
        private Matlab matlab = new Matlab();

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", SerialHardwarePage.this.matlabArgs, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            try {
                Instrument.enableInstrumentObjectEvents(true);
                if (matlabEvent.getStatus() == 0) {
                    Object object = matlabEvent.getResult();
                    SerialHardwarePage.this.updateTableData(object);
                }
                SerialHardwarePage.this.browser.postStatusBarUpdateEvent("");
                if (SerialHardwarePage.this.enableOnFinish) {
                    SerialHardwarePage.this.browser.postBlockEventsEvent(false);
                }
                SerialHardwarePage.this.scanButton.setEnabled(true);
                SerialHardwarePage.this.browser.postRefreshFinishedEvent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

