/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.hardware.GPIBBoardPage;
import com.mathworks.toolbox.instrument.browser.hardware.ProtocolPage;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import java.util.Vector;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class GPIBPage
extends ProtocolPage {
    private static final long serialVersionUID = 1L;

    public GPIBPage(InstrumentControlBrowser instrumentControlBrowser) {
        super(instrumentControlBrowser);
        this.init();
    }

    @Override
    protected void init() {
        this.headings[1] = "Board Index";
        this.path[2] = "GPIB";
        this.matlabArgs[1] = "identifyGPIB";
        this.panelTitle = "Installed GPIB Boards";
        this.statusMessage = "Scanning for GPIB boards";
        super.init();
    }

    @Override
    protected void constructDataArray(Object object, String string) {
        Object object2;
        String string2;
        int n;
        Object[] objectArray = (Object[])object;
        Vector<String> vector = new Vector<String>();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        for (n = 0; n < objectArray.length; ++n) {
            Object[] objectArray2 = (Object[])objectArray[n];
            string2 = (String)objectArray2[0];
            object2 = (String[])objectArray2[1];
            for (int i = 0; i < ((String[])object2).length; ++i) {
                vector.addElement(string2);
                vector.addElement(object2[i]);
                vector2.addElement(objectArray2);
            }
        }
        this.data = new Object[vector.size() / 2][this.headings.length];
        n = 0;
        if (this.data.length == 0) {
            this.data = new Object[1][this.headings.length];
            this.data[0][0] = "No boards were found";
            this.data[0][1] = "";
            this.cleanupNodes();
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            string2 = (String)vector.elementAt(n++);
            this.data[i][0] = this.createVendorStr(string2);
            this.data[i][1] = vector.elementAt(n++);
            object2 = string2 + "-Board-" + this.data[i][1];
            BrowserTreeNode browserTreeNode = this.createNode((String)object2, string2, (String)this.data[i][1], (Object[])vector2.elementAt(i));
            this.currentNodes.add(browserTreeNode);
        }
        this.cleanupNodes();
    }

    private BrowserTreeNode createNode(String string, String string2, String string3, Object[] objectArray) {
        BrowserTreeNode browserTreeNode = this.browser.getNode(this.path, string);
        if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(string, (BrowserClient)this.browser);
            browserTreeNode.setTag("Scan for GPIB instruments");
            browserTreeNode.setType(3);
            GPIBBoardPage gPIBBoardPage = new GPIBBoardPage(this.browser, string, string2, string3, objectArray);
            browserTreeNode.setPanel((JPanel)((Object)gPIBBoardPage));
            this.pages.addElement(gPIBBoardPage);
            this.browser.addNode(string, this.path, browserTreeNode);
        } else {
            GPIBBoardPage gPIBBoardPage = (GPIBBoardPage)((Object)browserTreeNode.getPanel());
            gPIBBoardPage.updateInfo(objectArray);
            this.pages.addElement(gPIBBoardPage);
        }
        browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\gpib_board.html");
        browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "gpib_board");
        return browserTreeNode;
    }

    @Override
    protected void createNodeOnLoad(String string, String string2) {
        String string3 = this.extractVendorAbbrv(string);
        String string4 = string3 + "-Board-" + string2;
        BrowserTreeNode browserTreeNode = this.createNode(string4, string3, string2, null);
        this.lastNodes.addElement(browserTreeNode);
    }

    @Override
    protected void createInstrumentNodeOnLoad(String string, String string2, String string3, Element element) {
        String string4 = string + "-Board-" + string2;
        BrowserTreeNode browserTreeNode = this.browser.getNode(this.path, string4);
        ((GPIBBoardPage)((Object)browserTreeNode.getPanel())).load(string, string3, string2, element);
    }
}

