/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.instrument.browser.driver.DriverPage;
import com.mathworks.toolbox.instrument.browser.driver.VXIPnPDriverPageInfo;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VXIPnPDriverPage
extends DriverPage
implements ListSelectionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private VXIPnPDriverPageInfo currentInfo;
    private JLabel inputArgs;
    private String inputArgsStr = "";
    private boolean needTooltip = false;
    private JLabel tempLabel = new JLabel("");

    public VXIPnPDriverPage() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layoutPanel();
    }

    @Override
    public void update(BrowserTreeNode browserTreeNode) {
        this.currentInfo = (VXIPnPDriverPageInfo)browserTreeNode.getUserData();
        this.currentInfo.setup();
        this.updateHeadingPanel();
        this.updateListBox();
        this.updateInputArgs();
        this.updateHelp();
        this.nameScrollPane.getViewport().setViewPosition(TOP_POINT);
        this.list.addListSelectionListener((ListSelectionListener)this);
    }

    @Override
    public void cleanup() {
        this.list.removeListSelectionListener((ListSelectionListener)this);
    }

    private void layoutPanel() {
        MJPanel mJPanel = this.add((JComponent)this.createHeadingPanel(false), (JComponent)this.createInfoPanel(), 4);
        MJPanel mJPanel2 = this.add((JComponent)mJPanel, this.createInputArgsPanel(), 4);
        this.add((Component)mJPanel2, "North");
        this.add((Component)this.getHelpPanel(), "Center");
    }

    private JPanel createInputArgsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.inputArgs = new JLabel("Input Arguments: ");
        this.inputArgs.addMouseListener(this);
        jPanel.add(this.inputArgs);
        return jPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateHelp();
        this.updateInputArgs();
    }

    private void updateHeadingPanel() {
        this.driverLabel.setText(this.currentInfo.getDirectory());
        this.manufacturerLabel.setText(this.currentInfo.getManufacturer());
        this.modelLabel.setText(this.currentInfo.getModel());
    }

    private void updateListBox() {
        this.list.setListData(this.currentInfo.getMethodList());
        if (this.list.getModel().getSize() > 1) {
            this.list.setSelectedIndex(1);
        }
        this.updateHelp();
    }

    private void updateInputArgs() {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            this.inputArgs.setText("");
            return;
        }
        this.inputArgsStr = this.currentInfo.getMethodInputs(n);
        this.tempLabel.setText("Input arguments: " + this.inputArgsStr);
        int n2 = this.getWidth();
        int n3 = this.tempLabel.getPreferredSize().width;
        if (n3 <= n2) {
            this.needTooltip = false;
            this.inputArgs.setText(this.tempLabel.getText());
        } else {
            this.needTooltip = true;
            this.inputArgs.setText(this.getInputArgsAbbreviatedText(this.tempLabel.getText(), n2) + "...");
        }
    }

    private void updateHelp() {
        int n = this.list.getSelectedIndex();
        if (n == -1) {
            this.help.setText("<html></html>");
            return;
        }
        this.help.setText("<html>" + this.currentInfo.getMethodHelp(n) + "<p><b>Please refer to vendor driver documentation for additional help.</b></p></html>");
    }

    private String getInputArgsAbbreviatedText(String string, int n) {
        if (n == 0) {
            return string;
        }
        this.tempLabel.setText(string);
        while (this.tempLabel.getPreferredSize().width >= n - 16) {
            string = this.tempLabel.getText();
            this.tempLabel.setText(string.substring(0, string.length() - 1));
        }
        return this.tempLabel.getText();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.needTooltip) {
            this.inputArgs.setToolTipText(this.inputArgsStr);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.inputArgs.setToolTipText("");
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

