/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.deviceobj;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTabbedPane;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.PropertyChangedListener;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceMCodeBank;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectCommunicationPage;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectConfigurePage;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectPageInfo;
import com.mathworks.toolbox.instrument.device.drivers.mwid.MWIDDriver;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.instrument.guiutil.ICSaveDialog;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DeviceObjectPage
extends InstrumentControlBrowserPage
implements PropertyChangedListener,
com.mathworks.toolbox.instrument.device.PropertyChangedListener,
ChangeListener,
ActionListener {
    static final long serialVersionUID = 0L;
    private static final String ACTION = "ACTION";
    private static final int CONNECT = 0;
    private static final int DISCONNECT = 1;
    private static final int SAVE = 10;
    private static DeviceObjectPage deviceObjectPage = null;
    private DeviceObjectPageInfo info;
    private MJLabel driverNameLabel;
    private MJLabel interfaceNameLabel;
    private MJLabel driverVersionLabel;
    private String instrumentType = "";
    private String instrumentModel = "";
    private MJButton connectButton;
    private MJButton disconnectButton;
    private MJLabel fConnectionStatusLabel;
    private MJLabel fConnectionLabel;
    private MJTabbedPane tabPanel;
    private DeviceObjectCommunicationPage communicationPage;
    private DeviceObjectConfigurePage configurePage;
    private SyntaxTextPane MCodeTextArea;
    private JComponent MCodeTextAreaPane;
    private MJButton saveButton;
    private String mCode = "";
    private DeviceMCodeBank codeBank = null;
    private Hashtable<DeviceObjectPageInfo, ICDevice> store;
    private InstrumentControlBrowser browser = null;
    private ConnectRunnable connectRunnable = null;
    private ICDevice deviceObject;
    private int driverType = 0;
    private Instrument interfaceObject;
    private static String sConnected = "Connected";
    private static String sDisconnected = "Disconnected";

    public static DeviceObjectPage getInstance() {
        if (deviceObjectPage == null) {
            deviceObjectPage = new DeviceObjectPage();
        }
        return deviceObjectPage;
    }

    public static boolean hasInstance() {
        return deviceObjectPage != null;
    }

    public DeviceObjectPage() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layoutPanel();
    }

    protected String getDescriptiveText() {
        return this.instrumentModel + " (" + this.instrumentType + ")";
    }

    public void addToStore(DeviceObjectPageInfo deviceObjectPageInfo, ICDevice iCDevice) {
        if (this.store == null) {
            this.store = new Hashtable();
        }
        this.store.put(deviceObjectPageInfo, iCDevice);
    }

    public void removeFromStore(DeviceObjectPageInfo deviceObjectPageInfo) {
        if (this.store == null) {
            return;
        }
        this.store.remove(deviceObjectPageInfo);
    }

    public DeviceObjectPageInfo getInfoFromStore(ICDevice iCDevice) {
        if (this.store == null) {
            return null;
        }
        Enumeration<DeviceObjectPageInfo> enumeration = this.store.keys();
        while (enumeration.hasMoreElements()) {
            DeviceObjectPageInfo deviceObjectPageInfo = enumeration.nextElement();
            ICDevice iCDevice2 = this.store.get(deviceObjectPageInfo);
            if (!iCDevice2.equals(iCDevice)) continue;
            return deviceObjectPageInfo;
        }
        return null;
    }

    public ICDevice getObjectFromStore(DeviceObjectPageInfo deviceObjectPageInfo) {
        if (this.store == null) {
            return null;
        }
        return this.store.get(deviceObjectPageInfo);
    }

    public void setDeviceIsConnected(final boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DeviceObjectPage.this.setDeviceIsConnected(bl);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        this.connectButton.setEnabled(!bl);
        this.disconnectButton.setEnabled(bl);
        if (bl) {
            this.fConnectionStatusLabel.setText(sConnected);
        } else {
            this.fConnectionStatusLabel.setText(sDisconnected);
        }
    }

    @Override
    public void dispose() {
        this.cleanup();
        this.communicationPage.dispose();
        this.configurePage.dispose();
        deviceObjectPage = null;
    }

    @Override
    public void cleanup() {
        this.communicationPage.cleanup(this.info);
        this.configurePage.cleanup(this.info);
        if (this.codeBank != null) {
            this.codeBank.cleanup();
        }
        ICDevice.removePropertyChangedListener(this);
        if (this.driverType == 0) {
            Instrument.removePropertyChangedListener(this);
        }
    }

    @Override
    public void update(BrowserTreeNode browserTreeNode) {
        this.info = (DeviceObjectPageInfo)browserTreeNode.getUserData();
        this.deviceObject = this.info.getObject();
        this.driverType = this.deviceObject.getDriverType();
        this.codeBank = this.info.getCodeBank();
        if (this.codeBank == null) {
            this.codeBank = this.driverType == 0 ? new DeviceMCodeBank(this.deviceObject, ((MWIDDriver)this.deviceObject.getDriver()).getInterfaceObject()) : new DeviceMCodeBank(this.deviceObject, null);
            this.info.setCodeBank(this.codeBank);
        }
        this.communicationPage.setCodeBank(this.codeBank);
        this.codeBank.setup();
        this.driverNameLabel.setText(this.info.getDriverName());
        this.interfaceNameLabel.setText(this.info.getInterfaceName());
        this.driverVersionLabel.setText(this.info.getDriverVersion());
        this.instrumentType = this.info.getInstrumentType();
        this.instrumentModel = this.info.getInstrumentModel();
        this.fConnectionLabel.setText("Connection status to " + this.getDescriptiveText() + ":");
        int n = this.info.getStatus();
        if (n == 1) {
            this.setDeviceIsConnected(true);
        } else {
            this.setDeviceIsConnected(false);
        }
        this.communicationPage.update(this.info);
        this.configurePage.update(this.info);
        ICDevice.addPropertyChangedListener(this);
        if (this.deviceObject.getDriverType() == 0) {
            this.interfaceObject = ((MWIDDriver)this.deviceObject.getDriver()).getInterfaceObject();
            Instrument.addPropertyChangedListener(this);
        }
        this.stateChanged(null);
    }

    public void setBrowser(InstrumentControlBrowser instrumentControlBrowser) {
        this.browser = instrumentControlBrowser;
    }

    public void postBlockEventsEvent(boolean bl) {
        this.browser.postBlockEventsEvent(bl);
    }

    private void layoutPanel() {
        this.tabPanel = new MJTabbedPane();
        this.tabPanel.setName("Device Object Tab Panel");
        this.tabPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.communicationPage = new DeviceObjectCommunicationPage(this);
        this.tabPanel.add("Functions", (Component)this.communicationPage);
        this.configurePage = new DeviceObjectConfigurePage(this, this.communicationPage.getTable());
        this.tabPanel.add("Properties", (Component)this.configurePage);
        this.tabPanel.add("Session Log", (Component)this.createSessionLogPanel());
        this.add((Component)this.tabPanel, "Center");
        this.add((Component)this.createHeadingPanel(), "North");
        this.tabPanel.addChangeListener((ChangeListener)this);
    }

    private MJPanel createHeadingPanel() {
        this.connectButton = new MJButton("Connect");
        this.connectButton.setEnabled(true);
        this.connectButton.putClientProperty((Object)ACTION, (Object)new Integer(0));
        this.connectButton.addActionListener((ActionListener)this);
        this.disconnectButton = new MJButton("Disconnect");
        this.disconnectButton.putClientProperty((Object)ACTION, (Object)new Integer(1));
        this.disconnectButton.addActionListener((ActionListener)this);
        this.connectButton.setEnabled(false);
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder("Connection"));
        this.fConnectionLabel = new MJLabel("Connection status to " + this.getDescriptiveText() + ":");
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0);
        mJPanel2.add((Component)this.fConnectionLabel, (Object)gridBagConstraints);
        this.fConnectionStatusLabel = new MJLabel(sDisconnected);
        gridBagConstraints.gridx = 1;
        mJPanel2.add((Component)this.fConnectionStatusLabel, (Object)gridBagConstraints);
        Font font = this.fConnectionStatusLabel.getFont();
        font = font.deriveFont(1);
        this.fConnectionStatusLabel.setFont(font);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(1, 2, 4, 0));
        mJPanel3.add((Component)this.connectButton);
        mJPanel3.add((Component)this.disconnectButton);
        mJPanel2.add((Component)mJPanel3, (Object)gridBagConstraints);
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0);
        mJPanel2.add((Component)mJPanel4, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 0, 0), 0, 0);
        mJPanel4.add((Component)new MJLabel("Interface:"), (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0);
        this.interfaceNameLabel = new MJLabel();
        this.interfaceNameLabel.setAlignmentX(0.0f);
        mJPanel4.add((Component)this.interfaceNameLabel, (Object)gridBagConstraints);
        mJPanel.add((Component)mJPanel2, (Object)"North");
        MJPanel mJPanel5 = new MJPanel((LayoutManager)new GridBagLayout());
        mJPanel5.setBorder((Border)BorderFactory.createTitledBorder("Driver"));
        this.driverNameLabel = new MJLabel();
        this.driverNameLabel.setAlignmentX(0.0f);
        this.driverVersionLabel = new MJLabel();
        this.driverVersionLabel.setAlignmentX(0.0f);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0);
        mJPanel5.add((Component)new MJLabel("Name:"), (Object)gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        mJPanel5.add((Component)new MJLabel("Version:"), (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0);
        mJPanel5.add((Component)this.driverNameLabel, (Object)gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        mJPanel5.add((Component)this.driverVersionLabel, (Object)gridBagConstraints);
        mJPanel.add((Component)mJPanel5, (Object)"Center");
        return mJPanel;
    }

    private MJPanel createSessionLogPanel() {
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.MCodeTextArea = new SyntaxTextPane();
        this.MCodeTextArea.setContentType(MLanguage.M_MIME_TYPE);
        this.MCodeTextArea.setEditable(false);
        this.MCodeTextArea.setShowLineNumbers(true, true);
        this.MCodeTextArea.setName("MCode TextArea");
        this.MCodeTextAreaPane = SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.MCodeTextArea);
        mJPanel.add((Component)this.MCodeTextAreaPane, (Object)"Center");
        this.MCodeTextAreaPane.setPreferredSize(new Dimension(100, 100));
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FlowLayout(0, 0, 0));
        mJPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.saveButton = new MJButton("Save Session...");
        this.saveButton.putClientProperty((Object)ACTION, (Object)new Integer(10));
        this.saveButton.addActionListener((ActionListener)this);
        mJPanel2.add((Component)this.saveButton);
        mJPanel.add((Component)mJPanel2, (Object)"South");
        return mJPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                if (this.connectRunnable == null) {
                    this.connectRunnable = new ConnectRunnable();
                }
                this.connectRunnable.setAction("connect");
                this.connectRunnable.setObject(this.deviceObject);
                Matlab.whenMatlabReady((Runnable)this.connectRunnable);
                break;
            }
            case 1: {
                if (this.connectRunnable == null) {
                    this.connectRunnable = new ConnectRunnable();
                }
                this.connectRunnable.setAction("disconnect");
                this.connectRunnable.setObject(this.deviceObject);
                Matlab.whenMatlabReady((Runnable)this.connectRunnable);
                break;
            }
            case 10: {
                this.saveMCode();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        switch (this.tabPanel.getSelectedIndex()) {
            case 0: {
                this.communicationPage.addTable();
                break;
            }
            case 1: {
                this.configurePage.addTable();
                break;
            }
            case 2: {
                this.updateMCodeTextArea();
            }
        }
    }

    private void saveMCode() {
        if (!ICSaveDialog.save(".m", "Save Session Log", "MATLAB Files (*.m)", new MJFrame())) {
            return;
        }
        this.codeBank.createFile(ICSaveDialog.getFileNameWithPath(), ICSaveDialog.getFileName());
    }

    private void updateMCodeTextArea() {
        int n = this.MCodeTextArea.getCaretPosition();
        this.mCode = this.communicationPage.generateCodeForSession();
        if (this.mCode.length() > 0) {
            this.saveButton.setEnabled(true);
        } else {
            this.saveButton.setEnabled(false);
        }
        this.MCodeTextArea.setText(this.mCode);
        if (n < 0 || n > this.mCode.length()) {
            n = 0;
        }
        this.MCodeTextArea.setCaretPosition(n);
    }

    @Override
    public void propertyChanged(Object object, String string, Object object2) {
        if (!object.equals(this.deviceObject)) {
            return;
        }
        if (!string.equals("Status")) {
            return;
        }
        if (object2.equals("open")) {
            this.setDeviceIsConnected(true);
        } else {
            this.setDeviceIsConnected(false);
        }
        if (this.tabPanel.getSelectedIndex() == 2) {
            this.updateMCodeTextArea();
        }
    }

    @Override
    public void propertyChanged(Instrument instrument, String string, Object object) {
        if (!this.interfaceObject.equals(instrument)) {
            return;
        }
        if (!string.equals("Name")) {
            return;
        }
        this.interfaceNameLabel.setText(instrument.getName());
    }

    public void exportHistoryTable(MJFrame mJFrame) {
        this.communicationPage.exportHistoryTable(mJFrame);
    }

    public void saveHistoryTable() {
        this.saveMCode();
    }

    public class ConnectRunnable
    implements Runnable,
    MatlabListener {
        private Object[] args = new Object[]{"privateBrowserHelper", "", ""};
        private Matlab matlab = new Matlab();

        public void setAction(String string) {
            this.args[1] = string;
        }

        public void setObject(ICDevice iCDevice) {
            this.args[2] = iCDevice.getMATLABObject();
        }

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", this.args, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (DeviceObjectPage.this.deviceObject.getStatus() == 1) {
                DeviceObjectPage.this.setDeviceIsConnected(true);
            } else {
                DeviceObjectPage.this.setDeviceIsConnected(false);
            }
        }
    }
}

