/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.ASCIITableConverter;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.ICProp;
import com.mathworks.toolbox.instrument.LineInputStream;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.Serial;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.instrument.util.DefaultICProp;
import com.mathworks.toolbox.instrument.util.Displays;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.Timer;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

public final class SerialComm
extends Serial
implements SerialPortEventListener,
ActionListener {
    private static final int SUCCESS = 0;
    private static final int WRITE_EC = -1;
    private static final int WRITE_CTRLC_EC = -2;
    private static final int WRITE_TIMEOUT_EC = -3;
    private static final int WRITE_CTRLC_TIMEOUT_EC = -4;
    private static final int READ_TIMEOUT_EC = -5;
    private static final int WRITE_ASYNC_EC = -6;
    private static final String WRITE_ERROR = "An error occurred during writing.";
    private static final String WRITE_CTRLC = "Ctrl-C interrupted the write operation.";
    private static final String WRITE_TIMEOUT = "A timeout occurred during the write operation.";
    private static final String WRITE_CTRLC_TIMEOUT = "A timeout or Ctrl-C occurred during the write operation.";
    private static final String READ_TIMEOUT = "A timeout occurred before the read operation completed.";
    private static final String WRITE_ASYNC = "An error occurred during the asynchronous write.";
    private static final String[] ERROR_MSG = new String[]{"An error occurred during writing.", "Ctrl-C interrupted the write operation.", "A timeout occurred during the write operation.", "A timeout or Ctrl-C occurred during the write operation.", "A timeout occurred before the read operation completed.", "An error occurred during the asynchronous write."};
    private static final int NO_FLOWCONTROL = 0;
    private static final int SOFTWARE_FLOWCONTROL = 12;
    private static final int HARDWARE_FLOWCONTROL = 3;
    private static String[] allPorts = SerialComm.findAllPorts();
    private static final int JAR_FILE_VERSION = 0;
    private static final String[] HWINFO_FIELDS = new String[]{"JarFileVersion"};
    protected MLArrayRef breakInterruptFcn = ACTION;
    protected MLArrayRef pinStatusFcn = ACTION;
    private SerialPort serialPort;
    private InputStreamReader reader;
    private LineInputStream lineInputStream;
    private InputStream inputStream;
    private DataInputStream dataInputStream;
    private OutputStream outputStream;
    private OutputStreamWriter outputStreamWriter;
    private DataOutputStream dataOutputStream;
    private String[] info = new String[1];
    private static final Object[] StopVals = new Object[]{new Double(1.0), new Double(1.5), new Double(2.0)};
    private static final Object[] AsciiVals = new Object[]{TermVals, "CR/LF", "LF/CR"};
    static ICProp[] objectICProps = new ICProp[]{new ICProp("BaudRate", "double", "none", "", new Integer(9600), "never", 1, 0), new ICProp("BreakInterruptFcn", "callback", "callback", "", "", "never", 1, 0), new ICProp("ByteOrder", "string", "enum", byteOVals, "littleEndian", "never", 0, 0), new ICProp("BytesAvailableFcnMode", "string", "enum", dModeVals, "terminator", "whileOpen", 0, 0), new ICProp("DataBits", "double", "bounded", dBitVals, new Integer(8), "never", 1, 0), new ICProp("DataTerminalReady", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("FlowControl", "string", "enum", flowVals, "none", "never", 1, 0), new ICProp("Parity", "string", "enum", ParVals, "none", "never", 1, 0), new ICProp("PinStatus", "struct", "none", null, pss, "always", 1, 0), new ICProp("PinStatusFcn", "callback", "callback", "", "", "never", 1, 0), new ICProp("Port", "string", "none", "", "", "whileOpen", 1, 0), new ICProp("ReadAsyncMode", "string", "enum", AsyncVals, "continuous", "never", 1, 0), new ICProp("RequestToSend", "string", "enum", boolVals, "on", "never", 1, 0), new ICProp("StopBits", "double", "enum", StopVals, new Integer(1), "never", 1, 0), new ICProp("Terminator", "ASCII Value", "ASCII Value", AsciiVals, "LF", "never", 1, 0), new ICProp("Type", "string", "none", "", "serial", "always", 0, 0)};

    public SerialComm() {
        this.deleteInstrumentObject(this);
    }

    public SerialComm(String string) throws TMException {
        try {
            this.port = platform == 0 ? string.toUpperCase() : string;
            this.type = "serial";
            this.name = "Serial-" + this.port;
            this.displayName = "serial port";
            this.objectProps = DefaultICProp.addObjectProps(objectICProps);
        }
        catch (Exception exception) {
            this.deleteInstrumentObject(this);
            throw new TMException(exception.getMessage());
        }
    }

    public String getInspectorToolbarObjectName() {
        return "serial port";
    }

    public void setBreakInterruptFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("BreakInterruptFcn", 0, mLArrayRef);
        if (this.breakInterruptFcn != ACTION) {
            this.breakInterruptFcn.dispose();
        }
        this.breakInterruptFcn = mLArrayRef2;
        this.disabledCallbacks[0] = 0;
        this.postPropertyChangedEvent("BreakInterruptFcn", this.breakInterruptFcn);
    }

    public MLArrayRef getBreakInterruptFcn() {
        return this.breakInterruptFcn;
    }

    public final void setPinStatusFcn(MLArrayRef mLArrayRef) throws TMException {
        MLArrayRef mLArrayRef2 = this.verifyActionValue("PinStatusFcn", 5, mLArrayRef);
        if (this.pinStatusFcn != ACTION) {
            this.pinStatusFcn.dispose();
        }
        this.pinStatusFcn = mLArrayRef2;
        this.disabledCallbacks[5] = 0;
        this.postPropertyChangedEvent("PinStatusFcn", this.pinStatusFcn);
    }

    public final MLArrayRef getPinStatusFcn() {
        return this.pinStatusFcn;
    }

    private String fixCommErrorMessage(String string, String string2) {
        if (string.indexOf("baud rate") != -1 || string.indexOf("BaudRate") != -1 || string.indexOf("translate_speed") != -1) {
            return "BaudRate could not be set to the specified value.";
        }
        if (string.indexOf("parity") != -1) {
            return "Parity could not be set to the specified value.";
        }
        if (string.indexOf("databits") != -1) {
            return "DataBits could not be set to the specified value.";
        }
        if (string.indexOf("stopbits") != -1) {
            return "StopBits could not be set to the specified value.";
        }
        return string2 + " could not be set to the specified value.";
    }

    @Override
    protected void setHardwareBaudRate(int n) throws TMException {
        try {
            this.serialPort.setSerialPortParams(n, this.dataBits, this.convertStopBits(this.stopBits), this.parity);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new TMException(this.fixCommErrorMessage(unsupportedCommOperationException.getMessage(), "BaudRate"));
        }
    }

    @Override
    protected void setHardwareDataBits(int n) throws TMException {
        try {
            this.serialPort.setSerialPortParams(this.baudRate, n, this.convertStopBits(this.stopBits), this.parity);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new TMException(this.fixCommErrorMessage(unsupportedCommOperationException.getMessage(), "DataBits"));
        }
    }

    @Override
    protected void setHardwareDataTerminalReady(boolean bl) {
        this.serialPort.setDTR(bl);
    }

    @Override
    protected boolean getHardwareDataTerminalReady() {
        return this.serialPort.isDTR();
    }

    @Override
    protected void setHardwareFlowControl(int n) throws TMException {
        try {
            switch (n) {
                case 0: {
                    this.serialPort.setFlowControlMode(0);
                    break;
                }
                case 1: {
                    this.serialPort.setFlowControlMode(3);
                    break;
                }
                case 2: {
                    this.serialPort.setFlowControlMode(12);
                }
            }
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new TMException("Flowcontrol could not be set to the specified value.");
        }
    }

    @Override
    protected void nameStandardFormat() {
        this.nameStandardFormat = this.name.equals("Serial-" + this.port);
    }

    @Override
    protected void setHardwareParity(int n) throws TMException {
        try {
            this.serialPort.setSerialPortParams(this.baudRate, this.dataBits, this.convertStopBits(this.stopBits), n);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new TMException(this.fixCommErrorMessage(unsupportedCommOperationException.getMessage(), "Parity"));
        }
    }

    @Override
    protected String getHardwareCarrierDetect() {
        return this.bool2OnOff(this.serialPort.isCD());
    }

    @Override
    protected String getHardwareClearToSend() {
        return this.bool2OnOff(this.serialPort.isCTS());
    }

    @Override
    protected String getHardwareDataSetReady() {
        return this.bool2OnOff(this.serialPort.isDSR());
    }

    @Override
    protected String getHardwareRingIndicator() {
        return this.bool2OnOff(this.serialPort.isRI());
    }

    @Override
    protected void setHardwarePort() {
        if (this.nameStandardFormat) {
            this.setName("Serial-" + this.port);
        }
    }

    @Override
    protected void setHardwareRequestToSend(boolean bl) {
        this.serialPort.setRTS(bl);
    }

    @Override
    protected boolean getHardwareRequestToSend() {
        return this.serialPort.isRTS();
    }

    @Override
    protected void setHardwareStopBits(double d) throws TMException {
        try {
            this.serialPort.setSerialPortParams(this.baudRate, this.dataBits, this.convertStopBits(d), this.parity);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new TMException(this.fixCommErrorMessage(unsupportedCommOperationException.getMessage(), "StopBits"));
        }
    }

    @Override
    protected double[] getValidStopBits() {
        double[] dArray = new double[]{1.0, 1.5, 2.0};
        return dArray;
    }

    protected int convertStopBits(double d) {
        if (d == 1.5) {
            return 3;
        }
        return (int)d;
    }

    @Override
    protected void setHardwareTerminator(int n) {
    }

    @Override
    protected int[] getTerminatorInteger(MLArrayRef mLArrayRef) throws TMException {
        return ASCIITableConverter.convertTerminatorObjectToInt(mLArrayRef, true);
    }

    @Override
    protected void setHardwareTimeout(double d) {
        this.timeout = d;
    }

    @Override
    protected double getHardwareTimeout() {
        return this.timeout;
    }

    protected static String[] getAvailablePorts() {
        return SerialComm.findAllPorts();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", SerialComm.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "SerialCommTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    public void openHardware() throws Exception {
        allPorts = SerialComm.findAllPorts();
        if (!this.isValidPort(this.port) || this.isInUse(this.port)) {
            SerialComm.displayError(this.errorSincePortIsInUse());
        }
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.port);
            this.serialPort = (SerialPort)commPortIdentifier.open("MATLAB", 2000);
        }
        catch (PortInUseException portInUseException) {
        }
        catch (NoSuchPortException noSuchPortException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {
            SerialComm.displayError("Cannot connect to the " + this.port + " port. Possible reasons are another" + LINESEP + "application is connected to the port or the port does not exist.");
        }
        if (this.serialPort == null) {
            SerialComm.displayError("Cannot connect to the " + this.port + " port. Possible reasons are another" + LINESEP + "application is connected to the port or the port does not exist.");
        }
        this.inputStream = this.serialPort.getInputStream();
        if (this.inputStream != null) {
            this.reader = new InputStreamReader(this.inputStream);
            this.lineInputStream = new LineInputStream(this.inputStream);
            this.dataInputStream = new DataInputStream(this.inputStream);
        }
        this.outputStream = this.serialPort.getOutputStream();
        if (this.outputStream != null) {
            this.outputStreamWriter = new OutputStreamWriter(this.outputStream);
            this.dataOutputStream = new DataOutputStream(this.outputStream);
        }
        this.serialPort.setInputBufferSize(4096);
        this.serialPort.addEventListener((SerialPortEventListener)this);
        this.updateSerialListeners(true);
        int n = (int)(this.timeout * 1000.0);
        this.serialPort.enableReceiveTimeout(n);
    }

    @Override
    public void closeHardware() throws Exception {
        Poller.removeInstrument(this);
        if (this.wasTimerStarted) {
            this.timer.hold();
        }
        Thread.sleep(100L);
        this.updateSerialListeners(false);
        this.serialPort.removeEventListener();
        this.setHardwareFlowControl(0);
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.lineInputStream != null) {
            this.lineInputStream.close();
            this.lineInputStream = null;
        }
        if (this.dataInputStream != null) {
            this.dataInputStream.close();
            this.dataInputStream = null;
        }
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        try {
            if (this.dataOutputStream != null) {
                this.dataOutputStream.close();
                this.dataOutputStream = null;
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.outputStreamWriter != null) {
                this.outputStreamWriter.close();
                this.outputStreamWriter = null;
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (platform == 0) {
            if (this.isInUse(this.port.toUpperCase())) {
                SerialComm.displayError("Could not disconnect object from hardware.");
            }
        } else if (this.isInUse(this.port)) {
            SerialComm.displayError("Could not disconnect object from hardware.");
        }
        this.serialPort.close();
    }

    @Override
    protected void disposeMLArrayRefs() {
        this.superDisposeMLArrayRef();
        this.terminatorObject.dispose();
        if (this.timer != null) {
            this.timer.removeActionListener((ActionListener)this);
        }
        if (this.breakInterruptFcn != ACTION) {
            this.breakInterruptFcn.dispose();
        }
        if (this.pinStatusFcn != ACTION) {
            this.pinStatusFcn.dispose();
        }
    }

    private void updateSerialListeners(boolean bl) {
        this.serialPort.notifyOnOutputEmpty(false);
        this.serialPort.notifyOnBreakInterrupt(bl);
        this.serialPort.notifyOnCarrierDetect(bl);
        this.serialPort.notifyOnCTS(bl);
        this.serialPort.notifyOnDSR(bl);
        this.serialPort.notifyOnRingIndicator(bl);
        this.serialPort.notifyOnFramingError(bl);
        this.serialPort.notifyOnParityError(bl);
        this.serialPort.notifyOnOverrunError(bl);
    }

    private boolean checkForCtrlC() {
        if (ctrlc_flag) {
            ctrlc_flag = false;
            return true;
        }
        return false;
    }

    private boolean isInUse(String string) {
        for (int i = 0; i < allInstrumentObjects.size(); ++i) {
            Object e = allInstrumentObjects.elementAt(i);
            if (!(e instanceof SerialComm)) continue;
            SerialComm serialComm = (SerialComm)e;
            if (!serialComm.port.equals(string) || serialComm.status != 1) continue;
            return true;
        }
        return false;
    }

    private boolean isValidPort(String string) {
        for (int i = 0; i < allPorts.length; ++i) {
            if (!string.equals(allPorts[i])) continue;
            return true;
        }
        return false;
    }

    private final String errorSincePortIsInUse() {
        String string = "";
        for (int i = 0; i < allPorts.length; ++i) {
            if (this.isInUse(allPorts[i])) continue;
            string = string + allPorts[i] + ", ";
        }
        if (string.length() != 0) {
            string = string.substring(0, string.length() - 2);
            return "Port: " + this.port + " is not available. Available ports: " + string + "." + LINESEP + "Use INSTRFIND to determine if " + "other instrument objects are connected to the requested device.";
        }
        return "Port: " + this.port + " is not available. No ports are available." + LINESEP + "Use INSTRFIND to determine if other instrument objects " + "are connected to the requested device.";
    }

    @Override
    public final Object[] constructorargs() {
        Object[] objectArray = new Object[]{this.port};
        return objectArray;
    }

    @Override
    public final String getConstructor() {
        return "serial('" + this.port + "');";
    }

    @Override
    public String getConstructorDescription() {
        return "Port - " + this.port;
    }

    @Override
    public String getInstrfindArgs() {
        return "('Type', '" + this.type + "', 'Port', '" + this.port + "', 'Tag', '" + this.tag + "');";
    }

    @Override
    protected void hardwareFlushInput() {
        if (this.lineInputStream != null) {
            this.lineInputStream.flush();
        }
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 2: {
                break;
            }
            case 6: {
                this.reportPinStatusEvent("Carrier Detect", serialPortEvent.getNewValue());
                break;
            }
            case 3: {
                this.reportPinStatusEvent("Clear To Send", serialPortEvent.getNewValue());
                break;
            }
            case 4: {
                this.reportPinStatusEvent("Data Set Ready", serialPortEvent.getNewValue());
                break;
            }
            case 5: {
                this.reportPinStatusEvent("Ring Indicator", serialPortEvent.getNewValue());
                break;
            }
            case 10: {
                if (this.breakInterruptFcn.equals(ACTION)) break;
                this.eventTime = Calendar.getInstance();
                this.executeEvent(0, "BreakInterrupt", this.eventTime, new ICEvent("BreakInterrupt", SerialComm.constructClockVector(this.eventTime)));
                break;
            }
            case 9: {
                this.executeErrorEvent(Calendar.getInstance(), "Serial: A framing error occurred.");
                break;
            }
            case 7: {
                this.executeErrorEvent(Calendar.getInstance(), "Serial: An overrun error occurred.");
                break;
            }
            case 8: {
                this.executeErrorEvent(Calendar.getInstance(), "Serial: A parity error occurred.");
            }
        }
    }

    @Override
    public int getSuccessValue() {
        return 0;
    }

    @Override
    public String getErrorMessageFromHardware(int n) {
        return ERROR_MSG[-1 * n - 1];
    }

    @Override
    protected int getReadTimeoutErrorCode() {
        return -5;
    }

    private void reportPinStatusEvent(String string, boolean bl) {
        if (!this.pinStatusFcn.equals(ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(5, "PinStatus", this.eventTime, new ICEvent("PinStatus", SerialComm.constructClockVector(this.eventTime), string, this.bool2OnOff(bl)));
        }
    }

    @Override
    protected int writeAsciiToHardware(String string) {
        int n = string.length();
        int n2 = this.baudRate;
        long l = SerialComm.currentNanoTicTime();
        int n3 = n2;
        this.localBytesToOutput = n;
        this.updateWriteTransferStatus(true);
        int n4 = 0;
        try {
            for (int i = 0; i < string.length(); i += n2) {
                if (this.checkForCtrlC()) {
                    this.valuesSent += (long)n4;
                    return this.returnWriteErrorCode(-2);
                }
                if (SerialComm.nanoTicTimeout(l, this.timeout)) {
                    this.valuesSent += (long)n4;
                    return this.returnWriteErrorCode(-3);
                }
                n3 = i + n2;
                if (n3 > n) {
                    n3 = n;
                }
                byte[] byArray = string.substring(i, n3).getBytes();
                this.dataOutputStream.write(byArray, 0, byArray.length);
                this.localBytesToOutput -= n3 - i;
                n4 += n3 - i;
            }
            this.localBytesToOutput = 0;
            this.dataOutputStream.flush();
            if (SerialComm.nanoTicTimeout(l, this.timeout)) {
                this.valuesSent += (long)n4;
                return this.returnWriteErrorCode(-3);
            }
            this.updateWriteTransferStatus(false);
            return string.length();
        }
        catch (Exception exception) {
            this.valuesSent += (long)n4;
            return this.returnWriteErrorCode(-1);
        }
    }

    @Override
    protected int writeBinaryToHardware(Object object, int n, int n2) {
        long l = SerialComm.currentNanoTicTime();
        int n3 = this.baudRate / 100;
        this.updateWriteTransferStatus(true);
        try {
            byte[] byArray = this.getBinaryDataToWrite(object, n2);
            this.localBytesToOutput = byArray.length;
            for (int i = 0; i < byArray.length; i += n3) {
                if (n3 > this.localBytesToOutput) {
                    n3 = this.localBytesToOutput;
                }
                this.outputStream.write(byArray, i, n3);
                this.outputStream.flush();
                this.localBytesToOutput -= n3;
                if (!this.checkForCtrlC() && !SerialComm.nanoTicTimeout(l, this.timeout)) continue;
                return this.returnWriteErrorCode(-4);
            }
            this.localBytesToOutput = 0;
            this.updateWriteTransferStatus(false);
            return byArray.length / DATASIZE[n2];
        }
        catch (Exception exception) {
            return this.returnWriteErrorCode(-1);
        }
    }

    private byte[] getBinaryDataToWrite(Object object, int n) throws Exception {
        this.datatype = n;
        switch (this.byteOrder) {
            case 1: {
                return BinarySwapBytes.breakdownToBytesAndSwap(object, n);
            }
            case 0: {
                return BinarySwapBytes.breakdownToBytes(object, n);
            }
        }
        return null;
    }

    private int returnWriteErrorCode(int n) {
        this.bytesToOutput = 0;
        this.updateWriteTransferStatus(false);
        return n;
    }

    @Override
    protected Object convertBinaryData(byte[] byArray, int n, int n2) throws Exception {
        if (n2 == 0) {
            return null;
        }
        switch (this.byteOrder) {
            case 0: {
                return BinarySwapBytes.convertToLittlePrecision(byArray, n, n2);
            }
            case 1: {
                return BinarySwapBytes.convertToBigPrecision(byArray, n, n2);
            }
        }
        throw new TMException("Unsupported byte order specified.");
    }

    @Override
    protected byte[] breakDownToBytes(Object object, int n) throws Exception {
        byte[] byArray = null;
        switch (this.byteOrder) {
            case 0: {
                byArray = BinarySwapBytes.breakdownToBytes(object, n);
                break;
            }
            case 1: {
                byArray = BinarySwapBytes.breakdownToBytesAndSwap(object, n);
            }
        }
        return byArray;
    }

    @Override
    protected int writeAsyncDataToHardware(int n, int n2) {
        this.updateWriteTransferStatus(true);
        try {
            this.dataOutputStream.write(this.dataToWriteAsync, n, n2);
        }
        catch (Exception exception) {
            return -6;
        }
        return 0;
    }

    @Override
    protected void cleanupWriteAsync() {
        this.updateWriteTransferStatus(false);
        if (this.asyncWriteFlag && !this.outputEmptyFcn.equals(ACTION)) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(4, "OutputEmpty", this.eventTime, new ICEvent("OutputEmpty", SerialComm.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected int getBytesAvailableFromHardware() {
        return this.lineInputStream.getBytesAvailable();
    }

    @Override
    protected byte[] readBytes(int n) {
        try {
            return this.lineInputStream.readByte(n);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected void stopHardwareDueToWriteTimeout() {
        try {
            this.hardwareFlushOutput();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void serialbreak(int n) throws TMException {
        if (!this.isvalid()) {
            SerialComm.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            SerialComm.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        if (this.transferStatus == 2 || this.transferStatus == 3) {
            SerialComm.displayError("SERIALBREAK cannot be called while data is being written asynchronously." + LINESEP + "STOPASYNC can be used to stop an asynchronous write operation.");
        }
        this.serialPort.sendBreak(n);
    }

    public Object[] hardwareInfo() throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            SerialComm.displayError("The Instrument Control Toolbox license check failed when trying to execute: 'instrhwinfo'.");
        }
        allPorts = SerialComm.findAllPorts();
        String[] stringArray = new String[allPorts.length];
        int n = 0;
        String[] stringArray2 = new String[allPorts.length];
        for (int i = 0; i < allPorts.length; ++i) {
            if (!this.isInUse(allPorts[i])) {
                stringArray[n++] = allPorts[i];
            }
            stringArray2[i] = "serial('" + allPorts[i] + "');";
        }
        String[] stringArray3 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray3[i] = stringArray[i];
        }
        Object[] objectArray = new Object[]{stringArray3, SerialComm.jarVersion(), stringArray2, allPorts};
        return objectArray;
    }

    public String[] ObjectHardwareInfo() throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("The Instrument Control Toolbox license check failed when trying to execute: 'instrhwinfo'.");
        }
        this.info[0] = SerialComm.jarVersion();
        return this.info;
    }

    @Override
    protected Object[] getHwInfoStruct() {
        try {
            this.ObjectHardwareInfo();
        }
        catch (TMException tMException) {
            // empty catch block
        }
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return HWINFO_FIELDS;
    }

    public static String[] findAllPorts() {
        Vector<String> vector = new Vector<String>();
        try {
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
            while (enumeration.hasMoreElements()) {
                CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
                if (commPortIdentifier.getPortType() != 1) continue;
                vector.addElement(commPortIdentifier.getName());
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return TMStringUtil.vector2StringArray(vector);
    }

    @Override
    protected void updateObjectSpecificProperties(ICProp[] iCPropArray) {
        for (int i = 0; i < iCPropArray.length; ++i) {
            String string = iCPropArray[i].name;
            if (string.equals("Name")) {
                iCPropArray[i].setDefaultValue("Serial-" + this.port);
                continue;
            }
            if (!string.equals("Port")) continue;
            iCPropArray[i].setDefaultValue(this.port);
        }
    }

    public static ICProp[] getProperties() {
        return DefaultICProp.addObjectProps(objectICProps);
    }

    @Override
    public void display() {
        if (!this.isvalid()) {
            System.out.println(Displays.invalidDisplay());
            return;
        }
        String string = LINESEP + "   Serial Port Object : " + this.name + LINESEP + LINESEP + "   Communication Settings " + LINESEP + "      Port:               " + this.port + LINESEP + "      BaudRate:           " + this.baudRate + LINESEP + "      Terminator:         " + this.displayTerminator + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
        System.out.println(string);
    }

    @Override
    public String setDisplay() {
        return Displays.getSetDisplay("terminator") + "    SERIAL specific properties:" + LINESEP + "    BaudRate" + LINESEP + "    BreakInterruptFcn: string -or- function handle -or- cell array" + LINESEP + "    DataBits" + LINESEP + "    DataTerminalReady: [ {on} | off ]" + LINESEP + "    FlowControl: [ {none} | hardware | software ]" + LINESEP + "    Parity: [ {none} | odd | even | mark | space ]" + LINESEP + "    PinStatusFcn: string -or- function handle -or- cell array" + LINESEP + "    Port" + LINESEP + "    ReadAsyncMode: [ {continuous} | manual ]" + LINESEP + "    RequestToSend: [ {on} | off ]" + LINESEP + "    StopBits" + LINESEP + "    Terminator" + LINESEP + " " + LINESEP;
    }

    public int[] serialPacketPeek(byte[] byArray, long l, byte[] byArray2) {
        int[] nArray = this.inputBuffer.packetPeek(byArray, (int)l, byArray2);
        return nArray;
    }
}

