/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.InstrumentAsyncContinuous;
import com.mathworks.toolbox.instrument.PinStatusStruct;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.util.Vector;

public abstract class Serial
extends InstrumentAsyncContinuous {
    protected static final int NOFLOW = 0;
    protected static final int HARDWARE = 1;
    protected static final int SOFTWARE = 2;
    protected static final String[] FLOWCONTROL = new String[]{"none", "hardware", "software"};
    protected static final int NONE = 0;
    protected static final String[] PARITY = new String[]{"none", "odd", "even", "mark", "space"};
    protected int baudRate = 9600;
    protected int dataBits = 8;
    protected boolean dataTerminalReady = true;
    protected int flowControl = 0;
    protected int parity = 0;
    protected PinStatusStruct pinStatus = new PinStatusStruct();
    protected String port = "";
    protected boolean requestToSend = true;
    protected double stopBits = 1.0;
    protected static final String[] AsyncVals = new String[]{"continuous", "manual"};
    protected static final Object[] dBitVals = new Object[]{new Double(5.0), new Double(8.0)};
    protected static final String[] dModeVals = new String[]{"terminator", "byte"};
    protected static final String[] flowVals = new String[]{"none", "hardware", "software"};
    protected static final String[] ParVals = new String[]{"none", "odd", "even", "mark", "space"};
    protected static final Object[] TermVals = new Object[]{new Double(0.0), new Double(127.0)};
    protected static final String[] TranSVals = new String[]{"idle", "read", "write", "read&write"};
    protected static final PinStatusStruct pss = new PinStatusStruct();

    public Serial() {
        try {
            Object[] objectArray = new Object[]{new Integer(45), "LF"};
            this.terminatorObject = (MLArrayRef)MatlabMCR.mtFeval((String)"system_dependent", (Object[])objectArray, (int)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector<Comparable<?>> vector = this.getPVPairs();
        this.addPVPair(vector, "BaudRate", this.baudRate);
        this.addPVPair(vector, "DataBits", this.dataBits);
        this.addPVPair(vector, "DataTerminalReady", this.bool2OnOff(this.dataTerminalReady));
        this.addPVPair(vector, "FlowControl", FLOWCONTROL[this.flowControl]);
        this.addPVPair(vector, "Parity", PARITY[this.parity]);
        this.addPVPair(vector, "RequestToSend", this.bool2OnOff(this.requestToSend));
        this.addPVPair(vector, "ReadAsyncMode", RA_MODES[this.readAsyncMode]);
        if (this.stopBits != 1.0) {
            vector.addElement((Comparable<?>)((Object)"StopBits"));
            vector.addElement(new Double(this.stopBits));
        }
        if (this.bytesAvailableFcnMode == 1) {
            vector.addElement((Comparable<?>)((Object)"BytesAvailableFcnMode"));
            vector.addElement((Comparable<?>)((Object)"byte"));
        }
        if (this.terminator != 10) {
            vector.addElement((Comparable<?>)((Object)"Terminator"));
            vector.addElement(new Integer(this.terminator));
        }
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    public final void setBaudRate(int n) throws TMException {
        if (this.status == 0) {
            this.baudRate = n;
            this.postPropertyChangedEvent("BaudRate", new Integer(this.baudRate));
            return;
        }
        if (this.getTransferStatus() != 0) {
            Serial.displayError("BaudRate " + NOASYNCOP);
        }
        try {
            this.setHardwareBaudRate(n);
            this.baudRate = n;
            this.postPropertyChangedEvent("BaudRate", new Integer(this.baudRate));
        }
        catch (Exception exception) {
            Serial.displayError(exception.getMessage());
        }
    }

    public final int getBaudRate() {
        return this.baudRate;
    }

    public final void setDataBits(int n) throws TMException {
        if (!this.verifySetRange(n, 5, 8)) {
            Serial.displayError("DataBits must range between 5 and 8.");
        }
        if (this.status == 0) {
            this.dataBits = n;
            this.postPropertyChangedEvent("DataBits", new Integer(this.dataBits));
            return;
        }
        if (this.getTransferStatus() != 0) {
            Serial.displayError("DataBits " + NOASYNCOP);
        }
        try {
            this.setHardwareDataBits(n);
            this.dataBits = n;
            this.postPropertyChangedEvent("DataBits", new Integer(this.dataBits));
        }
        catch (Exception exception) {
            Serial.displayError(exception.getMessage());
        }
    }

    public final int getDataBits() {
        return this.dataBits;
    }

    public void setDataTerminalReady(boolean bl) throws TMException {
        if (this.status == 0) {
            this.dataTerminalReady = bl;
            this.postPropertyChangedEvent("DataTerminalReady", this.bool2OnOff(this.dataTerminalReady));
            return;
        }
        if (this.getTransferStatus() != 0) {
            Serial.displayError("DataTerminalReady " + NOASYNCOP);
        }
        try {
            this.setHardwareDataTerminalReady(bl);
            this.dataTerminalReady = bl;
            this.postPropertyChangedEvent("DataTerminalReady", this.bool2OnOff(this.dataTerminalReady));
        }
        catch (Exception exception) {
            Serial.displayError(exception.getMessage());
        }
    }

    public boolean getDataTerminalReady() {
        if (this.status == 1) {
            this.dataTerminalReady = this.getHardwareDataTerminalReady();
        }
        return this.dataTerminalReady;
    }

    public final void setFlowControl(int n) throws TMException {
        if (this.status == 0) {
            this.flowControl = n;
            this.postPropertyChangedEvent("FlowControl", FLOWCONTROL[this.flowControl]);
            return;
        }
        if (this.getTransferStatus() != 0) {
            Serial.displayError("FlowControlHardware " + NOASYNCOP);
        }
        try {
            this.setHardwareFlowControl(n);
            this.flowControl = n;
            this.postPropertyChangedEvent("FlowControl", FLOWCONTROL[this.flowControl]);
        }
        catch (Exception exception) {
            Serial.displayError(exception.getMessage());
        }
    }

    public final int getFlowControl() {
        return this.flowControl;
    }

    public void setParity(int n) throws TMException {
        if (this.status == 0) {
            this.parity = n;
            this.postPropertyChangedEvent("Parity", PARITY[this.parity]);
            return;
        }
        if (this.getTransferStatus() != 0) {
            Serial.displayError("Parity " + NOASYNCOP);
        }
        try {
            this.setHardwareParity(n);
            this.parity = n;
            this.postPropertyChangedEvent("Parity", PARITY[this.parity]);
        }
        catch (Exception exception) {
            Serial.displayError(exception.getMessage());
        }
    }

    public int getParity() {
        return this.parity;
    }

    public final void setPinStatus(PinStatusStruct pinStatusStruct) throws TMException {
        Serial.displayError(this.createReadOnlyPropertyError("PinStatus"));
    }

    public final PinStatusStruct getPinStatus() {
        if (this.status == 1) {
            this.pinStatus.setCarrierDetect(this.getHardwareCarrierDetect());
            this.pinStatus.setClearToSend(this.getHardwareClearToSend());
            this.pinStatus.setDataSetReady(this.getHardwareDataSetReady());
            this.pinStatus.setRingIndicator(this.getHardwareRingIndicator());
        }
        return this.pinStatus;
    }

    public void setPort(String string) throws TMException {
        if (this.status == 1) {
            Serial.displayError("Port cannot be set while OBJ is open.");
        }
        switch (platform) {
            case 0: {
                this.port = string.toUpperCase();
                break;
            }
            default: {
                this.port = string;
            }
        }
        this.setHardwarePort();
        this.postPropertyChangedEvent("Port", this.port);
    }

    public final String getPort() {
        return this.port;
    }

    public final void setRequestToSend(boolean bl) throws TMException {
        if (this.status == 0) {
            this.requestToSend = bl;
            this.postPropertyChangedEvent("RequestToSend", this.bool2OnOff(this.requestToSend));
            return;
        }
        if (this.getTransferStatus() != 0) {
            Serial.displayError("RequestToSend " + NOASYNCOP);
        }
        try {
            this.setHardwareRequestToSend(bl);
            this.requestToSend = bl;
            this.postPropertyChangedEvent("RequestToSend", this.bool2OnOff(this.requestToSend));
        }
        catch (Exception exception) {
            Serial.displayError(exception.getMessage());
        }
    }

    public final boolean getRequestToSend() {
        if (this.status == 1) {
            this.requestToSend = this.getHardwareRequestToSend();
        }
        return this.requestToSend;
    }

    public final void setStopBits(double d) throws TMException {
        double[] dArray;
        if (new Double(d).toString().equals("NaN")) {
            Serial.displayError("StopBits cannot be set to NaN.");
        }
        if (!this.verifySetValues(dArray = this.getValidStopBits(), d)) {
            Serial.displayError("StopBits could not be set to specified value.");
        }
        if (this.status == 0) {
            this.stopBits = d;
            this.postPropertyChangedEvent("StopBits", new Double(this.stopBits));
            return;
        }
        if (this.getTransferStatus() != 0) {
            Serial.displayError("StopBits " + NOASYNCOP);
        }
        try {
            this.setHardwareStopBits(d);
            this.stopBits = d;
            this.postPropertyChangedEvent("StopBits", new Double(this.stopBits));
        }
        catch (Exception exception) {
            Serial.displayError(exception.getMessage());
        }
    }

    public final double getStopBits() {
        return this.stopBits;
    }

    @Override
    public String[] getBrowserInfo() {
        String[] stringArray = new String[]{"Port:", this.port};
        return stringArray;
    }

    @Override
    public String getBrowserString() {
        return this.port;
    }

    @Override
    protected void updatePropsOnOpen() throws TMException {
        this.setHardwareBaudRate(this.baudRate);
        this.setHardwareDataBits(this.dataBits);
        this.setHardwareStopBits(this.stopBits);
        this.setHardwareParity(this.parity);
        this.setHardwareTerminator(this.terminator);
        this.setHardwareTimeout(this.timeout);
        this.timeout = this.getHardwareTimeout();
        this.setHardwareFlowControl(this.flowControl);
        this.setHardwareDataTerminalReady(this.dataTerminalReady);
        this.setHardwareRequestToSend(this.requestToSend);
    }

    @Override
    protected int getBlockSizeForWrite() {
        int n = 128;
        if (this.baudRate > 750000) {
            n = 1000;
        } else if (this.baudRate > 500000) {
            n = 40960;
        } else if (this.baudRate > 250000) {
            n = 20480;
        } else if (this.baudRate > 120000) {
            n = 10240;
        } else if (this.baudRate > 100000) {
            n = 5120;
        } else if (this.baudRate > 60000) {
            n = 2460;
        } else if (this.baudRate > 30000) {
            n = 1280;
        } else if (this.baudRate > 10000) {
            n = 640;
        } else if (this.baudRate > 2500) {
            n = 320;
        }
        return n;
    }

    protected abstract boolean getHardwareDataTerminalReady();

    protected abstract boolean getHardwareRequestToSend();

    protected abstract String getHardwareCarrierDetect();

    protected abstract String getHardwareClearToSend();

    protected abstract String getHardwareDataSetReady();

    protected abstract String getHardwareRingIndicator();

    protected abstract void setHardwareBaudRate(int var1) throws TMException;

    protected abstract void setHardwareDataBits(int var1) throws TMException;

    protected abstract void setHardwareDataTerminalReady(boolean var1) throws TMException;

    protected abstract void setHardwareFlowControl(int var1) throws TMException;

    protected abstract void setHardwareParity(int var1) throws TMException;

    protected abstract void setHardwarePort();

    protected abstract void setHardwareRequestToSend(boolean var1) throws TMException;

    protected abstract void setHardwareStopBits(double var1) throws TMException;

    protected abstract double[] getValidStopBits();
}

