/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

public abstract class InstrumentPrimitiveReader
extends Instrument
implements ActionListener {
    private static final int JAR_FILE_VERSION = 0;
    private static final String[] HWINFO_FIELDS = new String[]{"JarFileVersion"};
    private String[] info = new String[1];
    protected int writeTransferMode = 0;

    @Override
    protected void createTimer() {
        this.timer = new Timer((int)(this.timerPeriod * 1000.0), (ActionListener)this, 1, 5, "TCPIPTimer");
        this.timer.start();
        this.wasTimerStarted = true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.eventTime = Calendar.getInstance();
        if (this.timerFcn != ACTION) {
            this.executeEvent(6, "Timer", this.eventTime, new ICEvent("Timer", InstrumentPrimitiveReader.constructClockVector(this.eventTime)));
        }
    }

    @Override
    protected void nameStandardFormat() {
    }

    public final void setBytesAvailable(int n) throws TMException {
        InstrumentPrimitiveReader.displayError(this.createReadOnlyPropertyError("BytesAvailable"));
    }

    @Override
    protected int getSuccessValue() {
        return 0;
    }

    public String[] ObjectHardwareInfo() throws TMException {
        if (!IS_TOOLBOX_INSTALLED) {
            throw new TMException("The Instrument Control Toolbox license check failed when trying to execute: 'instrhwinfo'.");
        }
        this.info[0] = InstrumentPrimitiveReader.jarVersion();
        return this.info;
    }

    @Override
    protected Object[] getHwInfoStruct() {
        try {
            this.ObjectHardwareInfo();
        }
        catch (TMException tMException) {
            // empty catch block
        }
        return this.info;
    }

    @Override
    protected String[] getHwInfoFields() {
        return HWINFO_FIELDS;
    }

    @Override
    public abstract String getConstructor();

    @Override
    public String getConstructorDescription() {
        return null;
    }

    @Override
    public String getInstrfindArgs() {
        return null;
    }

    @Override
    public String[] getBrowserInfo() {
        return null;
    }

    @Override
    public String getBrowserString() {
        return null;
    }

    public final void setValuesReceived(int n) throws TMException {
        InstrumentPrimitiveReader.displayError(this.createReadOnlyPropertyError("ValuesReceived"));
    }

    public final long getValuesReceived() {
        return this.getWrappedValues(this.valuesReceived);
    }

    public final void setBytesToOutput(int n) throws TMException {
        InstrumentPrimitiveReader.displayError(this.createReadOnlyPropertyError("BytesToOutput"));
    }

    public final int getBytesToOutput() {
        return this.bytesToOutput;
    }

    @Override
    public final int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public final void fgetl() throws TMException {
        InstrumentPrimitiveReader.displayError(sInstrumentResources.getString("Instrument.general.unsupported"));
    }

    public final void fgets() throws TMException {
        InstrumentPrimitiveReader.displayError(sInstrumentResources.getString("Instrument.general.unsupported"));
    }

    @Override
    public final void flushoutput() {
    }

    @Override
    protected void disposeInputBuffer() {
    }

    @Override
    public final void flushinput() {
    }

    @Override
    public final void setOutputBufferSize(int n) throws TMException {
        if (this.status == 1) {
            throw new TMException("OutputBufferSize cannot be set while OBJ is open.");
        }
        if (n < 1) {
            throw new TMException("OutputBufferSize must be greater than or equal to 1.");
        }
        this.outputBufferSize = n;
        this.bytesToOutput = 0;
    }

    public final int getBytesAvailable() {
        return this.bytesAvailable;
    }

    public final void updateBytesAvailable(int n) {
        this.bytesAvailable = n;
    }

    @Override
    public final void setInputBufferSize(int n) throws TMException {
        if (this.status == 1) {
            throw new TMException("InputBufferSize cannot be set while OBJ is open.");
        }
        if (n < 1) {
            InstrumentPrimitiveReader.displayError(sInstrumentResources.getString("Instrument.InputBuffer.InvalidSize"));
        }
        try {
            byte[] byArray = new byte[n];
            this.bytesAvailable = 0;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstrumentPrimitiveReader.displayError(sInstrumentResources.getString("Instrument.InputBuffer.OutOfMemory"));
            this.bytesAvailable = 0;
            return;
        }
        this.inputBufferSize = n;
    }

    @Override
    public final int getInputBufferSize() {
        return this.inputBufferSize;
    }

    @Override
    public void stopAsyncRead() {
    }

    @Override
    protected boolean poll() {
        return false;
    }

    @Override
    public void stopasync() throws TMException {
        InstrumentPrimitiveReader.displayError(sInstrumentResources.getString("Instrument.general.unsupported"));
    }

    public void readasync() throws TMException {
        InstrumentPrimitiveReader.displayError(sInstrumentResources.getString("Instrument.general.unsupported"));
    }
}

