/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.ASCIITableConverter;
import com.mathworks.toolbox.instrument.BinarySwapBytes;
import com.mathworks.toolbox.instrument.InstrumentAsync;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.util.Vector;

public abstract class Gpib
extends InstrumentAsync {
    protected static final String[] BYTES_AVAILABLE_FCN_MODE = new String[]{"byte", "eoscharCode"};
    protected static final int NONE = 0;
    protected static final int READ = 1;
    protected static final int WRITE = 2;
    protected static final int READWRITE = 3;
    protected static final String[] EOSMODES = new String[]{"none", "read", "write", "read&write"};
    protected static final int ADAPTOR_DLL_NAME = 0;
    protected static final int ADAPTOR_DLL_VERSION = 1;
    protected static final int ADAPTOR_NAME = 2;
    protected static final int VENDOR_DRIVER_NAME = 3;
    protected static final int VENDOR_DRIVER_DESCRIPTION = 4;
    protected static final int VENDOR_DRIVER_VERSION = 5;
    protected int boardIndex = 0;
    protected int compareBits = 8;
    protected boolean eoiMode = true;
    protected int eosCharCode = 10;
    protected int eosMode = 0;
    protected int primaryAddress = 0;
    protected int secondaryAddress = 0;
    protected byte[] eosCharByteArray = new byte[1];
    protected Object eosCharCodeObject = "LF";
    protected static final String[] dModeVals = new String[]{"eosCharCode", "byte"};
    protected static final Object[] eosCVals = new Object[]{new Double(0.0), new Double(255.0)};
    protected static final Object[] PadVals = new Object[]{new Double(0.0), new Double(30.0)};
    protected static final String[] TranSVals = new String[]{"idle", "read", "write"};
    protected static final String[] EOSMVals = new String[]{"none", "read", "write", "read&write"};
    protected static final Object[] AsciiVals = new Object[]{eosCVals};

    @Override
    public Object[] getNonDefaultPVPairs() {
        Vector<Comparable<?>> vector = this.getPVPairs();
        this.addPVPair(vector, "CompareBits", this.compareBits);
        this.addPVPair(vector, "EOIMode", this.bool2OnOff(this.eoiMode));
        this.addPVPair(vector, "EOSMode", EOSMODES[this.eosMode]);
        if (this.bytesAvailableFcnMode == 1) {
            vector.addElement((Comparable<?>)((Object)"BytesAvailableFcnMode"));
            vector.addElement((Comparable<?>)((Object)"byte"));
        }
        if (this.eosCharCode != 10) {
            vector.addElement((Comparable<?>)((Object)"EOSCharCode"));
            vector.addElement(new Integer(this.eosCharCode));
        }
        Object[] objectArray = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i);
        }
        return objectArray;
    }

    public void setBoardIndex(int n) throws TMException {
        if (this.status == 1) {
            Gpib.displayError("BoardIndex cannot be set while OBJ is open.");
        }
        this.boardIndex = n;
        this.updateNameProperties();
        this.postPropertyChangedEvent("BoardIndex", new Integer(this.boardIndex));
    }

    public final int getBoardIndex() {
        return this.boardIndex;
    }

    public final void setCompareBits(int n) throws TMException {
        int[] nArray = this.getValidCompareBits();
        if (!this.verifySetRange(n, nArray[0], nArray[1])) {
            Gpib.displayError("CompareBits could not be set to the specified value.");
        }
        if (this.status == 0) {
            this.compareBits = n;
            this.postPropertyChangedEvent("CompareBits", new Integer(this.compareBits));
            return;
        }
        try {
            this.setHardwareCompareBits(n);
            this.compareBits = n;
            this.postPropertyChangedEvent("CompareBits", new Integer(this.compareBits));
        }
        catch (Exception exception) {
            Gpib.displayError(exception.getMessage());
        }
    }

    public final int getCompareBits() {
        return this.compareBits;
    }

    public final void setEOIMode(boolean bl) throws TMException {
        if (this.status == 0) {
            this.eoiMode = bl;
            this.postPropertyChangedEvent("EOIMode", this.bool2OnOff(this.eoiMode));
            return;
        }
        try {
            this.setHardwareEOIMode(bl);
            this.eoiMode = bl;
            this.postPropertyChangedEvent("EOIMode", this.bool2OnOff(this.eoiMode));
        }
        catch (Exception exception) {
            Gpib.displayError(exception.getMessage());
        }
    }

    public final boolean getEOIMode() {
        return this.eoiMode;
    }

    public final void setEOSCharCode(Object object) throws TMException {
        int n = ASCIITableConverter.convertEOSObjectToInt(object);
        if (this.status == 0) {
            this.eosCharCode = n;
            this.eosCharByteArray[0] = (byte)n;
            this.eosCharCodeObject = object;
            this.postPropertyChangedEvent("EOSCharCode", this.eosCharCodeObject);
            return;
        }
        try {
            this.setHardwareEOSChar(n);
            this.eosCharCode = n;
            this.eosCharByteArray[0] = (byte)this.eosCharCode;
            this.eosCharCodeObject = object;
            this.postPropertyChangedEvent("EOSCharCode", this.eosCharCodeObject);
        }
        catch (Exception exception) {
            Gpib.displayError(exception.getMessage());
        }
    }

    public final Object getEOSCharCode() {
        return this.eosCharCodeObject;
    }

    public final void setEOSMode(int n) throws TMException {
        if (this.status == 0) {
            this.eosMode = n;
            this.postPropertyChangedEvent("EOSMode", EOSMODES[this.eosMode]);
            return;
        }
        try {
            this.setHardwareEOSMode(n);
            this.eosMode = n;
            this.postPropertyChangedEvent("EOSMode", EOSMODES[this.eosMode]);
        }
        catch (Exception exception) {
            Gpib.displayError(exception.getMessage());
        }
    }

    public final int getEOSMode() {
        return this.eosMode;
    }

    public void setPrimaryAddress(int n) throws TMException {
        if (!this.verifySetRange(n, 0, 30)) {
            Gpib.displayError("PrimaryAddress must range between 0 and 30.");
        }
        if (this.status == 1) {
            Gpib.displayError("PrimaryAddress cannot be set while OBJ is open.");
        }
        this.primaryAddress = n;
        this.updateNameProperties();
        this.postPropertyChangedEvent("PrimaryAddress", new Integer(this.primaryAddress));
    }

    public final int getPrimaryAddress() {
        return this.primaryAddress;
    }

    public void setSecondaryAddress(int n) throws TMException {
        int[] nArray = this.getValidSecondaryAddress();
        if (n != 0 && !this.verifySetRange(n, nArray[0], nArray[1])) {
            Gpib.displayError("SecondaryAddress could not be set to specified value.");
        }
        if (this.status == 1) {
            Gpib.displayError("SecondaryAddress cannot be set while OBJ is open.");
        }
        this.secondaryAddress = n;
        this.updateNameProperties();
        this.postPropertyChangedEvent("SecondaryAddress", new Integer(this.secondaryAddress));
    }

    public final int getSecondaryAddress() {
        return this.secondaryAddress;
    }

    @Override
    protected void updatePropsOnOpen() throws TMException {
        this.eosCharByteArray[0] = (byte)this.eosCharCode;
        this.setHardwareEOIMode(this.eoiMode);
        this.setHardwareEOSMode(this.eosMode);
        this.setHardwareEOSChar(this.eosCharCode);
        this.setHardwareCompareBits(this.compareBits);
        this.setHardwareTimeout(this.timeout);
        this.timeout = this.getHardwareTimeout();
    }

    protected boolean isInUse() {
        return false;
    }

    @Override
    protected void hardwareFlushInput() {
    }

    @Override
    protected String getAsciiMessage(Object[] objectArray) {
        return this.getAsciiMessage(objectArray, this.eosMode, this.eosCharCode);
    }

    @Override
    protected String getAsciiMessage(String string) {
        return this.getAsciiMessage(string, this.eosMode, this.eosCharCode);
    }

    @Override
    protected void updateWriteTransferStatus(boolean bl) {
        this.transferStatus = bl ? 2 : 0;
    }

    @Override
    protected int writeBinaryToHardware(Object object, int n, int n2) {
        if (platformByteOrder != this.byteOrder) {
            Object object2 = null;
            try {
                object2 = BinarySwapBytes.swap(object, n2, n);
            }
            catch (Exception exception) {
                return -1;
            }
            object = object2;
        }
        return this.writeBytes(object, n, n2);
    }

    @Override
    protected String removeTerminator(String string) {
        return this.removeTerminator(string, this.eosMode, this.eosCharCode);
    }

    @Override
    protected int okToGenerateTerminatorBytesAvailableEvent(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return 0;
        }
        if (byArray[byArray.length - 1] == this.eosCharCode) {
            return 1;
        }
        return 0;
    }

    @Override
    protected String wasAsciiReadSuccessful(String string, int n, int n2) {
        String string2 = "";
        switch (n) {
            case 0: {
                if (n2 != 0 || string.length() != this.inputBufferSize) break;
                if (this.eosMode == 1 || this.eosMode == 3) {
                    string2 = "The input buffer was filled before the EOI line was asserted or the EOSCharCode was detected.";
                    break;
                }
                string2 = "The input buffer was filled before the EOI line was asserted.";
                break;
            }
            default: {
                if (string.length() == n) break;
                String string3 = new Character((char)this.eosCharCode).toString();
                if (string.endsWith(string3)) {
                    if (this.eosMode == 1 || this.eosMode == 3) {
                        string2 = "The EOSCharCode was detected before SIZE values were available.";
                        break;
                    }
                    string2 = "The EOI line was asserted before SIZE values were available.";
                    break;
                }
                string2 = "The EOI line was asserted before SIZE values were available.";
            }
        }
        return string2;
    }

    @Override
    protected String wasBinaryReadSuccessful(int n, int n2, String string, int n3) {
        if (n < n2) {
            if (this.eosMode == 1 || this.eosMode == 3) {
                return "The EOI line was asserted or the EOSCharCode was detected before SIZE values were available.";
            }
            return "The EOI line was asserted before SIZE values were available.";
        }
        return "";
    }

    @Override
    protected String getTimeoutMessage(int n, int n2) {
        if (n == 0) {
            return "A timeout occurred before the EOI line was asserted.";
        }
        if (this.eosMode == 1 || this.eosMode == 3) {
            return "A timeout occurred before the EOI line was asserted, EOSCharCode was read" + LINESEP + " or SIZE values " + "were available.";
        }
        return "A timeout occurred before the EOI line was asserted or SIZE values were available.";
    }

    public void trigger() throws TMException {
        if (!this.isvalid()) {
            Gpib.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            Gpib.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        try {
            this.hardwareGPIBTrigger();
        }
        catch (Exception exception) {
            Gpib.displayError(exception.getMessage());
        }
    }

    public void clrdevice() throws TMException {
        if (!this.isvalid()) {
            Gpib.displayError("Instrument object OBJ is an invalid object.");
        }
        if (this.status == 0) {
            Gpib.displayError("OBJ must be connected to the hardware with FOPEN.");
        }
        try {
            this.hardwareGPIBClear();
        }
        catch (TMException tMException) {
            Gpib.displayError(tMException.getMessage());
        }
    }

    protected String gpibDisplay() {
        return "   Communication Address " + LINESEP + "      BoardIndex:         " + this.boardIndex + LINESEP + "      PrimaryAddress:     " + this.primaryAddress + LINESEP + "      SecondaryAddress:   " + this.secondaryAddress + LINESEP + LINESEP + "   Communication State " + LINESEP + "      Status:             " + STATUS_ENUM[this.status] + LINESEP + "      RecordStatus:       " + RECORD_STATUS_ENUM[this.bool2int(this.recordStatus)] + LINESEP + LINESEP + "   Read/Write State  " + LINESEP + "      TransferStatus:     " + TRANSFER_STATUS_ENUM[this.transferStatus] + LINESEP + "      BytesAvailable:     " + this.bytesAvailable + LINESEP + "      ValuesReceived:     " + this.getValuesReceived() + LINESEP + "      ValuesSent:         " + this.getValuesSent() + LINESEP + " " + LINESEP;
    }

    abstract void setHardwareEOIMode(boolean var1) throws TMException;

    abstract void setHardwareEOSMode(int var1) throws TMException;

    abstract void setHardwareCompareBits(int var1) throws TMException;

    abstract void setHardwareEOSChar(int var1) throws TMException;

    abstract void updateNameProperties();

    abstract int[] getValidSecondaryAddress();

    abstract int[] getValidCompareBits();

    abstract void hardwareGPIBTrigger() throws TMException;

    abstract void hardwareGPIBClear() throws TMException;

    abstract int writeBytes(Object var1, int var2, int var3);
}

