/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.services.settings.Setting;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class SettingTestEnvironment
implements AutoCloseable {
    private Environment fEnv = SettingTestEnvironment.nativeGetTempEnv();

    public synchronized Path getFactoryDir() {
        return Paths.get(this.fEnv.fFactoryDir, new String[0]);
    }

    public synchronized Path getWorkgroupDir() {
        return Paths.get(this.fEnv.fWorkgroupDir, new String[0]);
    }

    public synchronized Path getUserDir() {
        return Paths.get(this.fEnv.fUserDir, new String[0]);
    }

    public SettingTestEnvironment(String string, Path ... pathArray) throws IOException {
        try {
            Path path = Files.createDirectory(this.getFactoryDir().resolve(string), new FileAttribute[0]);
            for (Path path2 : pathArray) {
                Path path3 = path.resolve(path2.getFileName());
                Files.copy(path2, path3, new CopyOption[0]);
            }
        }
        catch (IOException iOException) {
            this.fEnv.close();
            throw iOException;
        }
    }

    @Override
    public synchronized void close() {
        if (this.fEnv != null) {
            this.fEnv.close();
            this.fEnv = null;
        }
    }

    private static native Environment nativeGetTempEnv();

    private static native void nativeRestoreEnv(long var0);

    static {
        Setting.loadLibrary();
    }

    private static class Environment
    implements AutoCloseable {
        public final String fFactoryDir;
        public final String fWorkgroupDir;
        public final String fUserDir;
        public final long fOldEnv;

        private Environment(long l, String string, String string2, String string3) {
            this.fOldEnv = l;
            this.fFactoryDir = string;
            this.fWorkgroupDir = string2;
            this.fUserDir = string3;
        }

        @Override
        public void close() {
            SettingTestEnvironment.nativeRestoreEnv(this.fOldEnv);
        }
    }
}

