/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.util.types.UnsignedByte;
import com.mathworks.util.types.UnsignedInteger;
import com.mathworks.util.types.UnsignedLong;
import com.mathworks.util.types.UnsignedShort;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

class SettingInfo<T> {
    private static final Map<Class<?>, Type> TYPE_MAP = new HashMap();
    private Type fType;
    private T fValue;

    SettingInfo(T t) {
        this.fType = TYPE_MAP.get(t.getClass());
        this.fValue = t;
    }

    SettingInfo(Class<T> clazz) {
        this.fType = clazz == null ? null : TYPE_MAP.get(clazz);
        this.fValue = null;
    }

    T getValue() {
        return this.fValue;
    }

    Class<T> getType() {
        if (this.fType == null) {
            if (this.fValue == null) {
                return null;
            }
            return this.fValue.getClass();
        }
        return this.fType.getClazz();
    }

    void setValue(T t) {
        this.fValue = t;
    }

    static {
        for (Type type : EnumSet.allOf(Type.class)) {
            TYPE_MAP.put(type.getClazz(), type);
        }
    }

    public static enum Type {
        BOOLEAN(Boolean.class),
        BYTE(Byte.class),
        UBYTE(UnsignedByte.class),
        SHORT(Short.class),
        USHORT(UnsignedShort.class),
        INT(Integer.class),
        UINT(UnsignedInteger.class),
        LONG(Long.class),
        ULONG(UnsignedLong.class),
        FLOAT(Float.class),
        DOUBLE(Double.class),
        STRING(String.class),
        BOOLEAN_ARRAY(Boolean[].class),
        BYTE_ARRAY(Byte[].class),
        UBYTE_ARRAY(UnsignedByte[].class),
        SHORT_ARRAY(Short[].class),
        USHORT_ARRAY(UnsignedShort[].class),
        INT_ARRAY(Integer[].class),
        UINT_ARRAY(UnsignedInteger[].class),
        LONG_ARRAY(Long[].class),
        ULONG_ARRAY(UnsignedLong[].class),
        FLOAT_ARRAY(Float[].class),
        DOUBLE_ARRAY(Double[].class),
        STRING_ARRAY(String[].class);

        private Class<?> fClass;

        private Type(Class<?> clazz) {
            this.fClass = clazz;
        }

        public Class<?> getClazz() {
            return this.fClass;
        }
    }
}

