/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.settings;

import com.mathworks.services.settings.Setting;
import com.mathworks.services.settings.SettingConverter;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.services.settings.SettingTypeException;
import java.awt.Font;
import java.lang.reflect.Method;

public class SettingFontConverter
extends SettingConverter<Font> {
    @Override
    protected Font get(SettingPath settingPath, String string, SettingLevel settingLevel) throws SettingNotFoundException, SettingTypeException {
        FontKeys fontKeys = new FontKeys(settingPath, string);
        String string2 = fontKeys.name.get(settingLevel);
        Double d = fontKeys.style.get(settingLevel);
        Double d2 = fontKeys.size.get(settingLevel);
        if (string2 == null && d == null && d2 == null) {
            return null;
        }
        if (string2 == null || d == null || d2 == null) {
            throw new ClassCastException("Converting " + settingPath + '.' + string + " to " + this.getType().getName());
        }
        try {
            return new Font(string2, d.intValue(), d2.intValue());
        }
        catch (RuntimeException runtimeException) {
            throw new SettingTypeException(runtimeException.getMessage());
        }
    }

    @Override
    protected void set(long l, SettingPath settingPath, String string, Font font, SettingLevel settingLevel) throws SettingException {
        FontKeys fontKeys = new FontKeys(settingPath, string);
        fontKeys.name.set(l, font.getName(), settingLevel);
        fontKeys.style.set(l, Double.valueOf(font.getStyle()), settingLevel);
        fontKeys.size.set(l, Double.valueOf(font.getSize()), settingLevel);
    }

    @Override
    protected void create(SettingPath settingPath, String string, Font font, SettingLevel settingLevel, Method method) throws SettingException {
        SettingPath settingPath2 = SettingFontConverter.addNode(settingPath, string, method);
        settingPath2.addSetting("name", font == null ? null : font.getName(), settingLevel);
        settingPath2.addSetting("style", font == null ? null : Double.valueOf(font.getStyle()), settingLevel);
        settingPath2.addSetting("size", font == null ? null : Double.valueOf(font.getSize()), settingLevel);
    }

    @Override
    protected Class<Font> getType() {
        return Font.class;
    }

    @Override
    protected boolean isNode() {
        return true;
    }

    @Override
    protected boolean isSet(Setting<Font> setting, SettingLevel settingLevel) throws SettingException {
        try {
            SettingPath settingPath = setting.getPath();
            FontKeys fontKeys = new FontKeys(settingPath, setting.getName());
            return fontKeys.name.isSet(settingLevel) || fontKeys.style.isSet(settingLevel) || fontKeys.size.isSet(settingLevel);
        }
        catch (SettingNotFoundException settingNotFoundException) {
            return false;
        }
    }

    @Override
    protected void unset(Setting<Font> setting, SettingLevel settingLevel) throws SettingException {
        SettingException settingException;
        block8: {
            FontKeys fontKeys;
            block7: {
                SettingPath settingPath = setting.getPath();
                fontKeys = new FontKeys(settingPath, setting.getName());
                settingException = null;
                try {
                    fontKeys.name.unset(settingLevel);
                }
                catch (SettingException settingException2) {
                    settingException = settingException2;
                }
                try {
                    fontKeys.style.unset(settingLevel);
                }
                catch (SettingException settingException3) {
                    if (settingException != null) break block7;
                    settingException = settingException3;
                }
            }
            try {
                fontKeys.size.unset(settingLevel);
            }
            catch (SettingException settingException4) {
                if (settingException != null) break block8;
                settingException = settingException4;
            }
        }
        if (settingException != null) {
            throw settingException;
        }
    }

    private class FontKeys {
        public final Setting<String> name;
        public final Setting<Double> style;
        public final Setting<Double> size;

        FontKeys(SettingPath settingPath, String string) throws SettingNotFoundException, SettingTypeException {
            SettingPath settingPath2 = new SettingPath(settingPath, string);
            try {
                this.name = new Setting<String>(settingPath2, String.class, "name");
                this.style = new Setting<Double>(settingPath2, Double.class, "style");
                this.size = new Setting<Double>(settingPath2, Double.class, "size");
            }
            catch (SettingNotFoundException settingNotFoundException) {
                throw new ClassCastException("Converting " + settingPath + '.' + string + " to " + SettingFontConverter.this.getType().getName());
            }
        }
    }
}

