/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.lmgr;

import com.mathworks.instutil.DecodeInputStream;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.services.lmgr.ExitMatlabRunnable;
import com.mathworks.services.lmgr.ProcessStarter;
import com.mathworks.services.lmgr.ProcessStarterAdapter;
import com.mathworks.services.lmgr.SessionHelperManager;
import com.mathworks.webproxy.PropertiesProxyConfiguration;
import com.mathworks.webproxy.ProxyConfigurationVisitor;
import com.mathworks.webproxy.SystemProxyConfiguration;
import com.mathworks.webproxy.SystemProxySettings;
import com.mathworks.webproxy.WebproxyFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public final class SessionHelperManagerImpl
implements SessionHelperManager {
    private static final long SLEEP_TIME_IN_MS = 1000L;
    private static final long TIME_TO_WATCH_PROCESS_IN_MS = 180000L;
    private static int threadCount = 0;
    private static SessionHelperManagerImpl sInstance = null;
    private final ProcessStarter processStarter;
    private Runnable sessionStopperRunnable = null;
    private final Runnable exitMatlabRunnable;
    private final long timeToWatchProcessInMS;
    private final ExecutorService executorService;

    private SessionHelperManagerImpl(ProcessStarter processStarter, Runnable runnable, ExecutorService executorService, long l) {
        this.processStarter = processStarter;
        this.exitMatlabRunnable = runnable;
        this.executorService = executorService;
        this.timeToWatchProcessInMS = l;
    }

    public static synchronized SessionHelperManagerImpl getInstance() {
        if (sInstance == null) {
            sInstance = new SessionHelperManagerImpl(new ProcessStarterAdapter(), new ExitMatlabRunnable(), Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                    thread.setDaemon(true);
                    thread.setName("sessionHelperThread-" + ++threadCount);
                    return thread;
                }
            }), 180000L);
        }
        return sInstance;
    }

    public static SessionHelperManagerImpl createTestInstance(ProcessStarter processStarter, Runnable runnable, ExecutorService executorService, long l) {
        return new SessionHelperManagerImpl(processStarter, runnable, executorService, l);
    }

    @Override
    public void startSessionHelperMonitorThread(String string, String string2, String string3, String string4, Runnable runnable) throws IOException {
        Object object;
        if (this.sessionStopperRunnable != null) {
            throw new IllegalStateException("scheduleSessionHelperThread can only be called once.");
        }
        this.sessionStopperRunnable = runnable;
        MyProxyConfigurationVisitor myProxyConfigurationVisitor = new MyProxyConfigurationVisitor();
        String string5 = myProxyConfigurationVisitor.getProxyHost();
        String string6 = myProxyConfigurationVisitor.getProxyPort();
        String string7 = myProxyConfigurationVisitor.getProxyUser();
        char[] cArray = myProxyConfigurationVisitor.getProxyPassword();
        ArrayList<String> arrayList = new ArrayList<String>(17);
        arrayList.add(SessionHelperManagerImpl.getSessionHelperProgram(string));
        arrayList.add("-r");
        arrayList.add(string);
        arrayList.add("-m");
        arrayList.add(SessionHelperManagerImpl.encodeArgument(string2));
        arrayList.add("-s");
        arrayList.add(SessionHelperManagerImpl.encodeArgument(string3));
        arrayList.add("-t");
        arrayList.add(SessionHelperManagerImpl.encodeArgument(string4));
        if (!string5.isEmpty()) {
            arrayList.add("-p");
            arrayList.add(SessionHelperManagerImpl.encodeArgument("tmw.proxyHost.override=" + string5));
        }
        if (!string6.isEmpty()) {
            arrayList.add("-p");
            arrayList.add(SessionHelperManagerImpl.encodeArgument("tmw.proxyPort.override=" + string6));
        }
        if (!string7.isEmpty()) {
            arrayList.add("-p");
            arrayList.add(SessionHelperManagerImpl.encodeArgument("tmw.proxyUser.override=" + string7));
        }
        if (cArray.length != 0) {
            object = new String(cArray);
            arrayList.add("-p");
            arrayList.add(SessionHelperManagerImpl.encodeArgument("tmw.proxyPassword.override=" + (String)object));
        }
        object = this.processStarter.startProcess(arrayList);
        this.executorService.submit(new SessionHelperMonitorThread((Process)object));
        this.executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encodeArgument(String string) throws IOException {
        String string2;
        DecodeInputStream decodeInputStream = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            decodeInputStream = new DecodeInputStream((InputStream)byteArrayInputStream);
            string2 = new String(Base64.encodeBase64((byte[])IOUtils.toByteArray((InputStream)decodeInputStream)));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(decodeInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)decodeInputStream);
        return string2;
    }

    private static String getSessionHelperProgram(String string) {
        return new File(new PlatformImpl().getNativeLibraryPath(string), "session_helper").getAbsolutePath();
    }

    private static final class MyProxyConfigurationVisitor
    implements ProxyConfigurationVisitor {
        private Proxy fProxy = Proxy.NO_PROXY;
        private PasswordAuthentication fPasswordAuthentication = null;

        private MyProxyConfigurationVisitor() {
            WebproxyFactory.createDefaultProxyConfiguration((SystemProxySettings)WebproxyFactory.createSystemProxySettings()).accept((ProxyConfigurationVisitor)this);
        }

        public void visit(PropertiesProxyConfiguration propertiesProxyConfiguration) {
            String string = WSEndPoints.getMWLicServerEndPoint();
            try {
                this.fProxy = propertiesProxyConfiguration.findProxyForURL(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                this.fProxy = Proxy.NO_PROXY;
            }
            this.fPasswordAuthentication = propertiesProxyConfiguration.getPasswordAuthentication();
        }

        public void visit(SystemProxyConfiguration systemProxyConfiguration) {
            String string = WSEndPoints.getMWLicServerEndPoint();
            try {
                this.fProxy = systemProxyConfiguration.findProxyForURL(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                this.fProxy = Proxy.NO_PROXY;
            }
        }

        public String getProxyHost() {
            String string = "";
            if (!this.fProxy.equals(Proxy.NO_PROXY)) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)this.fProxy.address();
                string = inetSocketAddress.getHostString();
            }
            return string;
        }

        public String getProxyPort() {
            String string = "";
            if (!this.fProxy.equals(Proxy.NO_PROXY)) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)this.fProxy.address();
                int n = inetSocketAddress.getPort();
                string = Integer.toString(n);
            }
            return string;
        }

        public String getProxyUser() {
            String string = "";
            if (!this.fProxy.equals(Proxy.NO_PROXY)) {
                string = this.fPasswordAuthentication == null ? "" : this.fPasswordAuthentication.getUserName();
            }
            return string;
        }

        public char[] getProxyPassword() {
            char[] cArray = "".toCharArray();
            if (!this.fProxy.equals(Proxy.NO_PROXY)) {
                cArray = this.fPasswordAuthentication == null ? "".toCharArray() : this.fPasswordAuthentication.getPassword();
            }
            return cArray;
        }
    }

    private class SessionHelperMonitorThread
    implements Runnable {
        private final Process fProcess;

        SessionHelperMonitorThread(Process process) {
            this.fProcess = process;
        }

        @Override
        public void run() {
            Date date = new Date(System.currentTimeMillis() + SessionHelperManagerImpl.this.timeToWatchProcessInMS);
            boolean bl = true;
            while (new Date().before(date) && bl) {
                try {
                    this.fProcess.exitValue();
                    bl = false;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            if (!bl) {
                SessionHelperManagerImpl.this.sessionStopperRunnable.run();
                SessionHelperManagerImpl.this.exitMatlabRunnable.run();
            }
        }
    }
}

