/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services.binding;

import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.services.PrefUtils;
import com.mathworks.services.Prefs;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.ResourceBundle;

public class MatlabKeyBindingPreferenceUtils {
    private static final String CUSTOM_SETS_PREF_KEY = "CustomKeyBindingSets";
    private static final String CURRENT_KEYBINDING_SET = "CurrentKeyBindingSet";
    private static final String DEFAULT_MODIFIED_SET_POSTFIX = "ModifiedDefaultSet.xml";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.mathworks.services.binding.resources.RES_MatlabKeyBindings");
    private static Long sTestId;

    private MatlabKeyBindingPreferenceUtils() {
    }

    public static List<File> readCustomSetFilesFromPrefs() {
        return PrefUtils.readFileListUsingPrefDir(CUSTOM_SETS_PREF_KEY, true);
    }

    static void setCustomSetFilesInPrefs(List<File> list) {
        if (!list.isEmpty()) {
            PrefUtils.writeFileListUsingPrefDir(CUSTOM_SETS_PREF_KEY, list);
        }
    }

    public static String readCurrentSetFromPrefs() {
        return Prefs.getStringPref(MatlabKeyBindingPreferenceUtils.getTestPrefix() + CURRENT_KEYBINDING_SET, MatlabKeyBindingPreferenceUtils.getDefaultSetForPlatform().getID());
    }

    static void setCurrentSetInPrefs(String string) {
        Prefs.setStringPref(MatlabKeyBindingPreferenceUtils.getTestPrefix() + CURRENT_KEYBINDING_SET, string);
    }

    public static DefaultKeyBindingSet getDefaultSetForPlatform() {
        return KeyBindingManager.getDefaultSetForPlatform();
    }

    public static String makeModifiedDefaultSetFilename(DefaultKeyBindingSet defaultKeyBindingSet) {
        return MatlabKeyBindingPreferenceUtils.getTestPrefix() + defaultKeyBindingSet.getID() + DEFAULT_MODIFIED_SET_POSTFIX;
    }

    public static void setIsTesting(boolean bl) {
        sTestId = bl ? Long.valueOf(new Random().nextLong()) : null;
    }

    public static String getTestPrefix() {
        return sTestId == null ? "" : "Test" + sTestId;
    }

    public static File resolveToPrefDir(String string) {
        String string2 = Prefs.getPropertyDirectory();
        assert (string2 != null && string2.length() > 0) : "No preferences directory set!";
        return new File(string2, string);
    }

    static void deletePrefEntries() {
        Prefs.remove(CUSTOM_SETS_PREF_KEY);
        Prefs.remove(MatlabKeyBindingPreferenceUtils.getTestPrefix() + CURRENT_KEYBINDING_SET);
    }

    static String lookup(String string) {
        return RESOURCE_BUNDLE.getString(string);
    }
}

