/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.hadoop;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.toolbox.parallel.hadoop.MatlabConfiguration;
import com.mathworks.toolbox.parallel.hadoop.MatlabFailureException;
import com.mathworks.toolbox.parallel.hadoop.MatlabOutputFormat;
import com.mathworks.toolbox.parallel.hadoop.MvmSingleton;
import com.mathworks.toolbox.parallel.hadoop.SerializationUtils;
import com.mathworks.toolbox.parallel.hadoop.TaskUtils;
import com.mathworks.toolbox.parallel.mapreduce.Endpoint;
import com.mathworks.toolbox.parallel.mapreduce.HadoopTaskAttemptID;
import com.mathworks.toolbox.parallel.mapreduce.InputFileSplit;
import com.mathworks.toolbox.parallel.mapreduce.KeyValueMessage;
import com.mathworks.toolbox.parallel.mapreduce.KeyValueSocket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

class MatlabMapper
extends Mapper<Void, InputSplit, BytesWritable, BytesWritable> {
    private MatlabConfiguration fConfig;
    private HadoopTaskAttemptID fTaskAttemptID;
    private MVM fMVM;
    private KeyValueSocket fKeyValueSocket;
    private String fFinalOutputFolder;

    MatlabMapper() {
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        TaskUtils.throwIfOutputFolderDoesNotExist((TaskAttemptContext)context);
        Configuration conf = context.getConfiguration();
        this.fConfig = new MatlabConfiguration(conf);
        this.fTaskAttemptID = TaskUtils.convertTaskAttemptID(context.getTaskAttemptID());
        this.fFinalOutputFolder = MatlabOutputFormat.getOutputPath((JobContext)context).toString();
        if (MvmSingleton.getMVM() == null) {
            try {
                MvmSingleton.initialize(conf, context.getJobID());
            }
            catch (Exception e) {
                TaskUtils.handleMatlabStartupException(e, this.fTaskAttemptID, this.fFinalOutputFolder, conf);
            }
        }
        this.fMVM = MvmSingleton.getMVM();
        this.fKeyValueSocket = new KeyValueSocket();
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        this.fKeyValueSocket.close();
    }

    private Endpoint bindEndpoint() throws IOException {
        Endpoint endpoint = new Endpoint("ipc://ml_" + this.fTaskAttemptID.toString());
        this.fKeyValueSocket.bind(endpoint);
        return endpoint;
    }

    private FutureFevalResult launchMatlab(Endpoint endpoint, InputSplit inputSplit) throws IOException {
        return this.fMVM.feval(this.fConfig.getMapperFunction(), new Object[]{endpoint.toString(), this.fTaskAttemptID.toString(), this.fConfig.getInputSplitType().toString(), this.serializeSplit(inputSplit), this.fFinalOutputFolder, SerializationUtils.serializeConfiguration(this.fConfig.toConfiguration())});
    }

    protected void map(Void voidKey, InputSplit inputSplit, Mapper.Context context) throws IOException, InterruptedException {
        Endpoint endpoint = this.bindEndpoint();
        FutureFevalResult future = this.launchMatlab(endpoint, inputSplit);
        BytesWritable currentKey = null;
        while (!future.isDone()) {
            KeyValueMessage message = this.fKeyValueSocket.recv(1000L, TimeUnit.MILLISECONDS);
            if (message == null) continue;
            if (message.isCloseMessage()) break;
            switch (message.getType()) {
                case KEY: {
                    currentKey = MatlabMapper.convertToBytesWritable(message.getContent());
                    break;
                }
                case VALUE: {
                    BytesWritable value = MatlabMapper.convertToBytesWritable(message.getContent());
                    context.write((Object)currentKey, (Object)value);
                }
            }
        }
        while (!future.isDone() && !this.fKeyValueSocket.sendClose(1000L, TimeUnit.MILLISECONDS)) {
        }
        try {
            future.get();
        }
        catch (MvmExecutionException e) {
            throw MatlabFailureException.wrapException(e);
        }
    }

    private static BytesWritable convertToBytesWritable(ByteBuffer buffer) {
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        return new BytesWritable(data);
    }

    private String serializeSplit(InputSplit inputSplit) throws IOException {
        switch (this.fConfig.getInputSplitType()) {
            case FILE: {
                FileSplit fileSplit = (FileSplit)inputSplit;
                return new InputFileSplit(fileSplit.getPath().toString(), fileSplit.getStart(), fileSplit.getLength()).toString();
            }
        }
        throw new IllegalStateException();
    }
}

