/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.hadoop;

import org.apache.hadoop.conf.Configuration;

class MatlabConfiguration {
    private Configuration fConfiguration;
    private static String INPUTSPLITTYPE_PROPERTY_NAME = "mathworks.toolbox.parallel.hadoop.InputSplitType";
    private static String INPUTSPLITTYPE_DEFAULT_VALUE = "FILE";
    private static String CONFIGUREFUNCTION_PROPERTY_NAME = "mathworks.toolbox.parallel.hadoop.ConfigureFunctionOverride";
    private static String CONFIGUREFUNCTION_DEFAULT_VALUE = "parallel.internal.hadoop.evaluateConfigure";
    private static String MAPPERFUNCTION_PROPERTY_NAME = "mathworks.toolbox.parallel.hadoop.MapperFunctionOverride";
    private static String MAPPERFUNCTION_DEFAULT_VALUE = "parallel.internal.hadoop.evaluateMapTask";
    private static String REDUCERFUNCTION_PROPERTY_NAME = "mathworks.toolbox.parallel.hadoop.ReducerFunctionOverride";
    private static String REDUCERFUNCTION_DEFAULT_VALUE = "parallel.internal.hadoop.evaluateReduceTask";
    private static String HADOOPVERSION_PROPERTY_NAME = "mathworks.toolbox.parallel.hadoop.HadoopVersion";
    private static String HADOOPVERSION_DEFAULT_VALUE = "2";
    private static String PARENT_MATLAB_PID_PROPERTY_NAME = "mathworks.toolbox.parallel.hadoop.ParentMatlabPid";
    private static int PARENT_MATLAB_PID_DEFAULT_VALUE = 0;
    private static String PARENT_MATLAB_BIN_FOLDER_PROPERTY_NAME = "mathworks.toolbox.parallel.hadoop.ParentMatlabBinFolder";

    public MatlabConfiguration(Configuration configuration) {
        assert (configuration != null);
        this.fConfiguration = configuration;
    }

    public Configuration toConfiguration() {
        return this.fConfiguration;
    }

    public InputSplitType getInputSplitType() {
        String type = this.fConfiguration.get(INPUTSPLITTYPE_PROPERTY_NAME, INPUTSPLITTYPE_DEFAULT_VALUE);
        return InputSplitType.valueOf(type);
    }

    String getConfigureFunction() {
        return this.fConfiguration.get(CONFIGUREFUNCTION_PROPERTY_NAME, CONFIGUREFUNCTION_DEFAULT_VALUE);
    }

    String getMapperFunction() {
        return this.fConfiguration.get(MAPPERFUNCTION_PROPERTY_NAME, MAPPERFUNCTION_DEFAULT_VALUE);
    }

    String getReducerFunction() {
        return this.fConfiguration.get(REDUCERFUNCTION_PROPERTY_NAME, REDUCERFUNCTION_DEFAULT_VALUE);
    }

    String getHadoopVersion() {
        return this.fConfiguration.get(HADOOPVERSION_PROPERTY_NAME, HADOOPVERSION_DEFAULT_VALUE);
    }

    int getParentMatlabPid() {
        return this.fConfiguration.getInt(PARENT_MATLAB_PID_PROPERTY_NAME, PARENT_MATLAB_PID_DEFAULT_VALUE);
    }

    String getParentMatlabBinFolder() {
        return this.fConfiguration.get(PARENT_MATLAB_BIN_FOLDER_PROPERTY_NAME, null);
    }

    public static enum InputSplitType {
        FILE;

    }
}

