/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.desktop.client;

import com.google.common.base.Preconditions;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.attr.AttributeChangeListener;
import com.mathworks.desktop.attr.Attributes;
import com.mathworks.desktop.attr.DefaultAttributes;
import com.mathworks.desktop.client.Client;
import com.mathworks.util.Disposable;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class BasicClient
implements Client,
AttributeChangeListener {
    private final String fName;
    private JComponent fComponent;
    private final DefaultAttributes fAttributes = new DefaultAttributes(this);

    public BasicClient(@NotNull String string) {
        Preconditions.checkNotNull((Object)string, (Object)"Client must have a name");
        this.fName = string;
        this.addAttributeChangeListener(this);
    }

    @Override
    @NotNull
    public String getName() {
        return this.fName;
    }

    protected void setComponent(@NotNull JComponent jComponent) {
        Preconditions.checkNotNull((Object)jComponent, (Object)"Component should not be null");
        this.cleanUp();
        this.fComponent = jComponent;
        this.fComponent.setName(this.getName());
        this.fComponent.putClientProperty("mwjavaguitest.instance", this);
    }

    private void cleanUp() {
        if (this.isComponentCreated()) {
            this.fComponent.putClientProperty("mwjavaguitest.instance", null);
            this.fComponent = null;
        }
    }

    protected boolean isComponentCreated() {
        return this.fComponent != null;
    }

    @NotNull
    protected abstract JComponent createComponent();

    @Override
    @NotNull
    public JComponent getComponent() {
        if (!this.isComponentCreated()) {
            this.setComponent(this.createComponent());
        }
        return this.fComponent;
    }

    @Override
    @NotNull
    public Attribute[] getAttributes() {
        return this.fAttributes.getAttributes();
    }

    @Override
    public <T> T setAttribute(Attribute<T> attribute, T t) {
        return this.fAttributes.setAttribute(attribute, t);
    }

    @Override
    public <T> T getAttribute(Attribute<T> attribute) {
        return this.fAttributes.getAttribute(attribute);
    }

    @Override
    public void addAttributeChangeListener(AttributeChangeListener attributeChangeListener) {
        this.fAttributes.addAttributeChangeListener(attributeChangeListener);
    }

    @Override
    public void addAttributeChangeListener(AttributeChangeListener attributeChangeListener, Disposable disposable) {
        this.fAttributes.addAttributeChangeListener(attributeChangeListener, disposable);
    }

    @Override
    public void addAttributeChangeListenerWeakly(AttributeChangeListener attributeChangeListener, Disposable disposable) {
        this.fAttributes.addAttributeChangeListenerWeakly(attributeChangeListener, disposable);
    }

    @Override
    public void addAttributeChangeListenerWeakly(AttributeChangeListener attributeChangeListener) {
        this.fAttributes.addAttributeChangeListenerWeakly(attributeChangeListener);
    }

    @Override
    public void removeAttributeChangeListener(AttributeChangeListener attributeChangeListener) {
        this.fAttributes.removeAttributeChangeListener(attributeChangeListener);
    }

    public void dressUp(Attributes attributes) {
        this.dressUp(attributes, false);
    }

    public void dressUp(Attributes attributes, boolean bl) {
        for (Attribute attribute : attributes.getAttributes()) {
            Object t = this.getAttribute(attribute);
            if (!bl && t != null && t.equals(attribute.getDefault())) continue;
            this.setAttribute(attribute, attributes.getAttribute(attribute));
        }
    }

    @Override
    public final void attributeChange(AttributeChangeEvent attributeChangeEvent) {
        this.processAttributeChange(attributeChangeEvent);
    }

    protected void processAttributeChange(AttributeChangeEvent attributeChangeEvent) {
    }

    public void refresh() {
        Preconditions.checkState((boolean)this.isComponentCreated(), (Object)"Attempt to refresh a client with uninitialized component");
        this.getComponent().revalidate();
        this.getComponent().repaint();
    }

    public void dispose() {
        this.cleanUp();
    }
}

