/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.ssl.HandshakeState;
import java.security.Key;

final class SessionState {
    static final int CIPHER_NULL = 0;
    static final int CIPHER_IC4 = 1;
    static final int CIPHER_IC2 = 2;
    static final int CIPHER_DES = 3;
    static final int CIPHER_3DES = 4;
    static final int CIPHER_DES40 = 5;
    static final int MAC_NULL = 0;
    static final int MAC_MD5 = 1;
    static final int MAC_SHA = 2;
    byte[] sessionID = new byte[0];
    Object serverCertificate = null;
    Key serverPublicKey = null;
    int compressionMethod = 0;
    byte[] masterSecret = new byte[48];
    boolean isResumable = false;
    int cipherSuite = 0;
    int bulkCipherAlgorithm = 0;
    String bulkCipherAlgorithmName = "NULL";
    int MACAlgorithm = 0;
    boolean blockCipher = false;
    boolean isExportable = true;
    int hashSize = 0;
    int keyMaterial = 0;
    int keySize = 0;
    int IVSize = 0;
    byte[] clientWriteIV;
    byte[] serverWriteIV;
    int nowProto;

    SessionState() {
    }

    SessionState(SessionState sessionState) {
        this.sessionID = (byte[])sessionState.sessionID.clone();
        if (sessionState.serverPublicKey != null) {
            this.serverPublicKey = sessionState.serverPublicKey;
        }
        this.compressionMethod = sessionState.compressionMethod;
        this.masterSecret = (byte[])sessionState.masterSecret.clone();
        this.isResumable = sessionState.isResumable;
        this.cipherSuite = sessionState.cipherSuite;
        this.bulkCipherAlgorithm = sessionState.bulkCipherAlgorithm;
        this.bulkCipherAlgorithmName = sessionState.bulkCipherAlgorithmName;
        this.MACAlgorithm = sessionState.MACAlgorithm;
        this.blockCipher = sessionState.blockCipher;
        this.isExportable = sessionState.isExportable;
        this.hashSize = sessionState.hashSize;
        this.keyMaterial = sessionState.keyMaterial;
        this.keySize = sessionState.keySize;
        this.IVSize = sessionState.IVSize;
        if (sessionState.clientWriteIV != null) {
            this.clientWriteIV = new byte[sessionState.clientWriteIV.length];
            System.arraycopy(sessionState.clientWriteIV, 0, this.clientWriteIV, 0, sessionState.clientWriteIV.length);
        }
        if (sessionState.serverWriteIV != null) {
            this.serverWriteIV = new byte[sessionState.serverWriteIV.length];
            System.arraycopy(sessionState.serverWriteIV, 0, this.serverWriteIV, 0, sessionState.serverWriteIV.length);
        }
        this.nowProto = sessionState.nowProto;
    }

    void setupCipherSpec(int n, HandshakeState handshakeState) {
        this.cipherSuite = n;
        switch (this.cipherSuite) {
            case 0: {
                handshakeState.keyExchange = 0;
                this.MACAlgorithm = 0;
                this.hashSize = 0;
                this.IVSize(0, true);
                break;
            }
            case 1: {
                handshakeState.keyExchange = 1;
                this.MACAlgorithm = 1;
                this.hashSize = 16;
                this.IVSize(0, true);
                break;
            }
            case 2: {
                handshakeState.keyExchange = 1;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(0, true);
                break;
            }
            case 3: {
                handshakeState.keyExchange = 1;
                this.MACAlgorithm = 1;
                this.hashSize = 16;
                this.IVSize(1, true);
                break;
            }
            case 4: {
                handshakeState.keyExchange = 1;
                this.MACAlgorithm = 1;
                this.hashSize = 16;
                this.IVSize(1, false);
                break;
            }
            case 5: {
                handshakeState.keyExchange = 1;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(1, false);
                break;
            }
            case 6: {
                handshakeState.keyExchange = 1;
                this.MACAlgorithm = 1;
                this.hashSize = 16;
                this.IVSize(2, true);
                break;
            }
            case 8: {
                handshakeState.keyExchange = 1;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(3, true);
                break;
            }
            case 9: {
                handshakeState.keyExchange = 1;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(3, false);
                break;
            }
            case 10: {
                handshakeState.keyExchange = 1;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(4, false);
                break;
            }
            case 11: {
                handshakeState.keyExchange = 2;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(3, true);
                break;
            }
            case 12: {
                handshakeState.keyExchange = 3;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(3, false);
                break;
            }
            case 13: {
                handshakeState.keyExchange = 3;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(4, false);
                break;
            }
            case 14: {
                handshakeState.keyExchange = 4;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(4, true);
                break;
            }
            case 15: {
                handshakeState.keyExchange = 5;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(3, false);
                break;
            }
            case 16: {
                handshakeState.keyExchange = 5;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(4, false);
                break;
            }
            case 17: {
                handshakeState.keyExchange = 6;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(3, true);
                break;
            }
            case 18: {
                handshakeState.keyExchange = 7;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(3, false);
                break;
            }
            case 20: {
                handshakeState.keyExchange = 7;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(4, false);
                break;
            }
            case 21: {
                handshakeState.keyExchange = 8;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(3, true);
                break;
            }
            case 22: {
                handshakeState.keyExchange = 9;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(3, false);
                break;
            }
            case 23: {
                handshakeState.keyExchange = 9;
                this.MACAlgorithm = 2;
                this.hashSize = 20;
                this.IVSize(4, false);
                break;
            }
            case 131200: {
                handshakeState.keyExchange = 1;
                this.bulkCipherAlgorithm = 1;
                this.bulkCipherAlgorithmName = "IC4";
                this.MACAlgorithm = 1;
                this.hashSize = 16;
                this.blockCipher = false;
                this.isExportable = true;
                this.IVSize = 0;
                this.keyMaterial = 5;
                this.keySize = 16;
                break;
            }
            case 65664: {
                handshakeState.keyExchange = 1;
                this.bulkCipherAlgorithm = 1;
                this.bulkCipherAlgorithmName = "IC4";
                this.MACAlgorithm = 1;
                this.hashSize = 16;
                this.blockCipher = false;
                this.isExportable = false;
                this.IVSize = 0;
                this.keyMaterial = 16;
                this.keySize = 16;
                break;
            }
            case 262272: {
                handshakeState.keyExchange = 1;
                this.bulkCipherAlgorithm = 2;
                this.bulkCipherAlgorithmName = "IC2";
                this.MACAlgorithm = 1;
                this.hashSize = 16;
                this.blockCipher = true;
                this.isExportable = true;
                this.IVSize = 8;
                this.keyMaterial = 5;
                this.keySize = 16;
                break;
            }
            case 196736: {
                handshakeState.keyExchange = 1;
                this.bulkCipherAlgorithm = 2;
                this.bulkCipherAlgorithmName = "IC2";
                this.MACAlgorithm = 1;
                this.hashSize = 16;
                this.blockCipher = true;
                this.isExportable = false;
                this.IVSize = 8;
                this.keyMaterial = 16;
                this.keySize = 16;
                break;
            }
            case 393280: {
                handshakeState.keyExchange = 1;
                this.bulkCipherAlgorithm = 3;
                this.bulkCipherAlgorithmName = "DES";
                this.MACAlgorithm = 1;
                this.hashSize = 16;
                this.blockCipher = true;
                this.isExportable = false;
                this.IVSize = 8;
                this.keyMaterial = 8;
                this.keySize = 8;
                break;
            }
            case 458944: {
                handshakeState.keyExchange = 1;
                this.bulkCipherAlgorithm = 4;
                this.bulkCipherAlgorithmName = "DES-EDE3";
                this.MACAlgorithm = 1;
                this.hashSize = 16;
                this.blockCipher = true;
                this.isExportable = false;
                this.IVSize = 8;
                this.keyMaterial = 24;
                this.keySize = 24;
            }
        }
    }

    private void IVSize(int n, boolean bl) {
        this.isExportable = bl;
        switch (n) {
            case 0: {
                this.bulkCipherAlgorithm = 0;
                this.bulkCipherAlgorithmName = "NULL";
                this.blockCipher = false;
                this.IVSize = 0;
                this.keySize = 0;
                break;
            }
            case 1: {
                this.bulkCipherAlgorithm = 1;
                this.bulkCipherAlgorithmName = "IC4";
                this.blockCipher = false;
                this.IVSize = 0;
                this.keySize = 16;
                break;
            }
            case 2: {
                this.bulkCipherAlgorithm = 2;
                this.bulkCipherAlgorithmName = "IC2";
                this.blockCipher = true;
                this.IVSize = 8;
                this.keySize = 16;
                break;
            }
            case 3: {
                this.bulkCipherAlgorithm = 3;
                this.bulkCipherAlgorithmName = "DES";
                this.blockCipher = true;
                this.IVSize = 8;
                this.keySize = 8;
                break;
            }
            case 4: {
                this.bulkCipherAlgorithm = 4;
                this.bulkCipherAlgorithmName = "DES-EDE3";
                this.blockCipher = true;
                this.IVSize = 8;
                this.keySize = 24;
            }
        }
        if (!this.isExportable) {
            this.keyMaterial = this.keySize;
        } else if (this.bulkCipherAlgorithm == 1 || this.bulkCipherAlgorithm == 2 || this.bulkCipherAlgorithm == 3) {
            this.keyMaterial = 5;
        }
    }
}

