/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.cert.CertificateException;
import ice.cert.X509Certificate;
import ice.cert.X509CertificateFactory;
import ice.crypto.KeyStore;
import ice.crypto.KeyStoreException;
import ice.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;

public class ServerCertificateList
implements Cloneable {
    private KeyStore OEAB;
    private static final char[] Z = new char[]{'\u4a0c', '\u87a6', '\ude50', '\u30a6', '\ub1b5', '\u2f4b', '\u63ee', '\u2f5b', '\uc56d', '\u8e0c', '\u74b6', '\u6ea5', '\uafbb', '\u2725', '\u7fe1', '\u9f3a', '\u80ac', '\u175e', '\u32e5', '\ud5a6', '\u3b2d', '\ub51c', '\udae9', '\u629a', '\udf16', '\uc8be', '\ua961', '\ue772', '\u2cb4', '\ud4a2', '\u1114', '\u21e1', '\ub3a7', '\ua84d', '\u73a0', '\ub8e7', '\ub66b', '\uec68', '\u1f18', '\ud792', '\u892a', '\u2321', '\u718f', '\ub274', '\u2e3e', '\ue792', '\u9621', '\u6cca', '\ua783', '\uc5c1', '\u4380', '\u05cf', '\u6348', '\u1a1a', '\u88e3', '\u2f6f', '\u037b', '\ub025', '\ud48c', '\ud5fa', '\uc694', '\u5fe3', '\uc937', '\ufa8b', '\ufac0', '\u86d0', '\u719d', '\u58fb', '\uf0ad', '\ufd16', '\u5fae', '\uc966', '\u9200', '\u3487', '\u590f', '\ua663', '\u52df', '\u2102', '\ub07a', '\u4fbe', '\u883d', '\u6eb7', '\uca9b', '\ubfe6', '\u0a20', '\u14d9', '\ub8ec', '\uf13b', '\u82d7', '\u1003', '\u5182', '\ufdb7', '\u35ec', '\ua170', '\u7460', '\uadbe', '\u10da', '\u1525', '\u824f', '\uf91e', '\u36a1', '\uddb4', '\uba67', '\u557b', '\u6c8c', '\udc6e', '\uaa96', '\ub43a', '\uca20', '\u3ba2', '\u0a92', '\u26cb', '\u175d', '\u8e68', '\ub453', '\u375a', '\ue1b7', '\u3dcd', '\u2064', '\u35a1', '\ubc9b', '\u4a20', '\ud3da', '\ub40e', '\u95a8', '\u6458', '\uc1fa', '\ue5c8'};

    private ServerCertificateList(KeyStore keyStore) {
        this.OEAB = keyStore;
    }

    public ServerCertificateList() {
        block2: {
            this.OEAB = new KeyStore();
            try {
                this.OEAB.load(null, null);
            }
            catch (Exception exception) {
                if (!Debug.ex) break block2;
                Debug.ex((Throwable)exception);
            }
        }
    }

    public void addCertificate(X509Certificate x509Certificate) {
        try {
            this.OEAB.setCertificateEntry(Integer.toString(x509Certificate.hashCode()), x509Certificate);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    public void removeCertificate(X509Certificate x509Certificate) {
        try {
            this.OEAB.deleteEntry(Integer.toString(x509Certificate.hashCode()));
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    public Enumeration getList() {
        return new ServerCertEnum(this, this.OEAB);
    }

    public static ServerCertificateList restoreList(InputStream inputStream) throws IOException {
        KeyStore keyStore = new KeyStore();
        try {
            keyStore.load(inputStream, Z);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (Debug.ex) {
                Debug.ex((Throwable)noSuchAlgorithmException);
            }
            throw new IOException("Wrapped exception: " + noSuchAlgorithmException.getMessage());
        }
        ServerCertificateList serverCertificateList = new ServerCertificateList(keyStore);
        return serverCertificateList;
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            this.OEAB.store(outputStream, Z);
        }
        catch (Exception exception) {
            throw new IOException("Cannot store the list : " + exception.getMessage());
        }
    }

    public Object clone() {
        try {
            ServerCertificateList serverCertificateList = (ServerCertificateList)super.clone();
            serverCertificateList.OEAB = (KeyStore)this.OEAB.clone();
            return serverCertificateList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private String OEAB(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = 0;
        int n2 = -1;
        while ((n2 = inputStream.read()) != -1) {
            if (n2 != 13 && n2 != 10) {
                byArray[n] = (byte)n2;
                ++n;
            }
            if (n2 != 10 && n < 1024) continue;
        }
        if (n2 == -1) {
            return null;
        }
        return new String(byArray, 0, n);
    }

    public static ServerCertificateList restoreListFromPEM(InputStream inputStream) throws IOException {
        ServerCertificateList serverCertificateList = new ServerCertificateList();
        String string = serverCertificateList.OEAB(inputStream);
        String string2 = "";
        X509CertificateFactory x509CertificateFactory = new X509CertificateFactory();
        while (string != null) {
            if ("-----BEGIN CERTIFICATE-----".equals(string) || "-----BEGIN X509 CERTIFICATE-----".equals(string) || "-----BEGIN TRUSTED CERTIFICATE-----".equals(string)) {
                block6: {
                    string = string + "\n";
                    while (!(string == null || "-----END CERTIFICATE-----".equals(string) || "-----END X509 CERTIFICATE-----".equals(string) || "-----END TRUSTED CERTIFICATE-----".equals(string))) {
                        string2 = string2 + string + "\n";
                        string = serverCertificateList.OEAB(inputStream);
                    }
                    string2 = string2 + string + "\n";
                    try {
                        byte[] byArray = string2.getBytes();
                        X509Certificate x509Certificate = x509CertificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                        serverCertificateList.addCertificate(x509Certificate);
                    }
                    catch (CertificateException certificateException) {
                        if (Debug.ex) {
                            Debug.ex((Throwable)certificateException);
                        }
                        if (!Debug.trace) break block6;
                        Debug.trace((String)"WARNING: error building certificate");
                    }
                }
                string2 = "";
            }
            string = serverCertificateList.OEAB(inputStream);
        }
        return serverCertificateList;
    }

    public void saveAsPEM(OutputStream outputStream) throws IOException {
        Enumeration enumeration = this.getList();
        do {
            X509Certificate x509Certificate = (X509Certificate)enumeration.nextElement();
            x509Certificate.saveAsText(outputStream);
        } while (enumeration.hasMoreElements());
    }

    class ServerCertEnum
    implements Enumeration {
        private KeyStore OEAB;
        private Enumeration aliases;
        private final ServerCertificateList this$0;

        ServerCertEnum(ServerCertificateList serverCertificateList, KeyStore keyStore) {
            this.this$0 = serverCertificateList;
            this.OEAB = keyStore;
            try {
                this.aliases = keyStore.aliases();
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }

        public boolean hasMoreElements() {
            return this.aliases.hasMoreElements();
        }

        public Object nextElement() {
            try {
                return this.OEAB.getCertificate((String)this.aliases.nextElement());
            }
            catch (KeyStoreException keyStoreException) {
                return null;
            }
        }
    }
}

