/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import cryptix.provider.rsa.CryptixRSAPrivateKeyPatch;
import ice.cert.CertificateException;
import ice.cert.PKCS8PrivateKeyFactory;
import ice.cert.X509Certificate;
import ice.cert.X509CertificateFactory;
import ice.crypto.KeyStore;
import ice.crypto.KeyStoreException;
import ice.crypto.RSAPublicKey;
import ice.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Enumeration;
import java.util.Hashtable;

public class ClientCertificateList
implements Cloneable {
    private KeyStore OEAB;
    private Hashtable Z;
    private static final char[] addCertificate = new char[]{'\uc05d', '\ua05c', '\u5f6b', '\u3389', '\u9bd7', '\ucf5f', '\u4e72', '\ue9bb', '\ufd90', '\u8c95', '\uac82', '\u3ecb', '\u408a', '\u0364', '\u8abf', '\ude6b', '\ud74b', '\uf450', '\u0cb1', '\u42ca', '\u2b57', '\u5cae', '\u297c', '\u8304', '\ufb5b', '\u3f7c', '\udb34', '\u010a', '\ud502', '\u48db', '\u23ec', '\u3e1b', '\u5c77', '\u16f3', '\ud70e', '\u4efb', '\u3110', '\u7dfa', '\uf109', '\u191c', '\u5889', '\ud906', '\u8791', '\u0c0b', '\u7c06', '\u88db', '\u4b6c', '\u4c3b', '\u8231', '\u8385', '\u5772', '\u9c97', '\u5f79', '\u2a68', '\ud486', '\u75d1', '\u0d5e', '\u91cd', '\ub226', '\uc2f3', '\u3bd0', '\uc7eb', '\ub0e0', '\uf68a', '\uf827', '\u6827', '\ueeaf', '\u9783', '\ua6aa', '\u142e', '\u3f96', '\uae11', '\u5b4c', '\u1ff1', '\u0294', '\u0b31', '\u573e', '\u924a', '\u41fd', '\u8d34', '\u910b', '\u63fd', '\u61be', '\uaee0', '\u1032', '\u7162', '\ua2da', '\u0eeb', '\u0f2d', '\u917c', '\uf166', '\ua428', '\u4fc2', '\u78d7', '\u15ea', '\u473b', '\u2672', '\u3822', '\u7215', '\ud87d', '\ucc27', '\u1c83', '\u04f1', '\u9a6e', '\u07cc', '\u9c23', '\u50cb', '\ufbf4', '\u0b9c', '\u9d84', '\uaf64', '\u9092', '\ubaff', '\ua59a', '\u4e7e', '\u76f3', '\u8a7d', '\u6e13', '\u982e', '\ue17f', '\uf4a9', '\u3730', '\ud6bb', '\ua040', '\u554b', '\udda9', '\u5904', '\u981e'};

    private ClientCertificateList(KeyStore keyStore) {
        this.Z = new Hashtable();
        this.OEAB = keyStore;
    }

    public ClientCertificateList() {
        block2: {
            this.Z = new Hashtable();
            this.OEAB = new KeyStore();
            try {
                this.OEAB.load(null, null);
            }
            catch (Exception exception) {
                if (!Debug.ex) break block2;
                Debug.ex((Throwable)exception);
            }
        }
    }

    public void addCertificate(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            throw new IllegalArgumentException("The certificate chain must contain at least one certificate.");
        }
        try {
            String string = Integer.toString(x509CertificateArray[0].hashCode());
            KeyEntry keyEntry = new KeyEntry(this);
            keyEntry.theKey = privateKey;
            keyEntry.certChain = x509CertificateArray;
            this.Z.put(string, keyEntry);
            this.OEAB.setKeyEntry(string, privateKey, addCertificate, x509CertificateArray);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    public void addCertificate(InputStream inputStream) {
        throw new IllegalArgumentException("This method is not implemented !");
    }

    public void removeCertificate(X509Certificate x509Certificate) {
        try {
            this.OEAB.deleteEntry(Integer.toString(x509Certificate.hashCode()));
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    public Enumeration getList() {
        return new ClientCertEnum(this, this.OEAB, this.Z);
    }

    public X509Certificate[] getCertificateChain(X509Certificate x509Certificate) {
        try {
            String string = Integer.toString(x509Certificate.hashCode());
            X509Certificate[] x509CertificateArray = this.OEAB.getCertificateChain(string);
            return x509CertificateArray;
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
    }

    public PrivateKey getPrivateKey(X509Certificate x509Certificate) {
        PrivateKey privateKey = null;
        try {
            privateKey = (PrivateKey)this.OEAB.getKey(this.OEAB.getCertificateAlias(x509Certificate), addCertificate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return privateKey;
    }

    public static ClientCertificateList restoreList(InputStream inputStream, char[] cArray) throws IOException {
        KeyStore keyStore = new KeyStore();
        try {
            keyStore.load(inputStream, cArray);
        }
        catch (Exception exception) {
            throw new IOException("Cannot restore the list : " + exception.getMessage());
        }
        ClientCertificateList clientCertificateList = new ClientCertificateList(keyStore);
        return clientCertificateList;
    }

    public void save(OutputStream outputStream, char[] cArray) throws IOException {
        try {
            this.OEAB.store(outputStream, cArray);
        }
        catch (Exception exception) {
            throw new IOException("Cannot store the list : " + exception.getMessage());
        }
    }

    public Object clone() {
        try {
            ClientCertificateList clientCertificateList = (ClientCertificateList)super.clone();
            clientCertificateList.OEAB = (KeyStore)this.OEAB.clone();
            return clientCertificateList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private String OEAB(LineNumberReader lineNumberReader) {
        try {
            String string = lineNumberReader.readLine();
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String Z(LineNumberReader lineNumberReader) {
        String string = null;
        String string2 = null;
        while (!((string = this.OEAB(lineNumberReader)) == null || "-----BEGIN CERTIFICATE-----".equals(string) || "-----BEGIN X509 CERTIFICATE-----".equals(string) || "-----BEGIN TRUSTED CERTIFICATE-----".equals(string))) {
        }
        if (string == null) {
            return null;
        }
        string2 = string + "\n";
        do {
            string = this.OEAB(lineNumberReader);
            string2 = string2 + string + "\n";
        } while (string != null && !"-----END CERTIFICATE-----".equals(string) && !"-----END X509 CERTIFICATE-----".equals(string) && !"-----END TRUSTED CERTIFICATE-----".equals(string));
        return string2;
    }

    private String addCertificate(LineNumberReader lineNumberReader) {
        String string = null;
        String string2 = null;
        while (!((string = this.OEAB(lineNumberReader)) == null || "-----BEGIN PRIVATE KEY-----".equals(string) || "-----BEGIN ENCRYPTED PRIVATE KEY-----".equals(string) || "-----BEGIN RSA PRIVATE KEY-----".equals(string))) {
        }
        if (string == null) {
            return null;
        }
        string2 = string + "\n";
        do {
            string = this.OEAB(lineNumberReader);
            string2 = string2 + string + "\n";
        } while (string != null && !"-----END PRIVATE KEY-----".equals(string) && !"-----END ENCRYPTED PRIVATE KEY-----".equals(string) && !"-----END RSA PRIVATE KEY-----".equals(string));
        return string2;
    }

    public static ClientCertificateList restoreListFromPEM(InputStream inputStream, PKCS8PrivateKeyFactory pKCS8PrivateKeyFactory) throws IOException {
        ClientCertificateList clientCertificateList = new ClientCertificateList();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        String string = null;
        String string2 = null;
        X509CertificateFactory x509CertificateFactory = new X509CertificateFactory();
        PKCS8PrivateKeyFactory pKCS8PrivateKeyFactory2 = pKCS8PrivateKeyFactory == null ? new PKCS8PrivateKeyFactory() : pKCS8PrivateKeyFactory;
        while ((string = clientCertificateList.Z(lineNumberReader)) != null && string != null) {
            X509Certificate[] x509CertificateArray;
            Object object;
            Object object2;
            X509Certificate x509Certificate;
            block10: {
                block9: {
                    x509Certificate = null;
                    try {
                        object2 = string.getBytes();
                        x509Certificate = x509CertificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object2));
                    }
                    catch (CertificateException certificateException) {
                        if (Debug.ex) {
                            Debug.ex((Throwable)certificateException);
                        }
                        if (!Debug.trace) break block9;
                        Debug.trace((String)("WARNING: error building certificate" + certificateException));
                    }
                }
                string = "";
                string2 = clientCertificateList.addCertificate(lineNumberReader);
                if (string2 == null) break;
                object2 = null;
                try {
                    object = string2.getBytes();
                    object2 = (CryptixRSAPrivateKeyPatch)pKCS8PrivateKeyFactory2.parsePrivateKey(new ByteArrayInputStream((byte[])object));
                }
                catch (CertificateException certificateException) {
                    if (Debug.ex) {
                        Debug.ex((Throwable)certificateException);
                    }
                    if (!Debug.trace) break block10;
                    Debug.trace((String)("WARNING: error parsing private key" + certificateException));
                }
            }
            string2 = "";
            object = x509Certificate.getPublicKey();
            if (object instanceof RSAPublicKey) {
                BigInteger bigInteger;
                x509CertificateArray = (X509Certificate[])object;
                BigInteger bigInteger2 = ((CryptixRSAPrivateKeyPatch)object2).getModulus();
                if (!bigInteger2.equals(bigInteger = x509CertificateArray.getModulus()) && Debug.trace) {
                    Debug.trace((String)"WARNING: Certificate and private key do not match in certificate list");
                }
            }
            x509CertificateArray = new X509Certificate[]{x509Certificate};
            clientCertificateList.addCertificate(x509CertificateArray, (PrivateKey)object2);
            if (string != null && string2 != null) continue;
        }
        return clientCertificateList;
    }

    class ClientCertEnum
    implements Enumeration {
        private KeyStore OEAB;
        private Hashtable aliases;
        private Enumeration certChain;
        private final ClientCertificateList this$0;

        ClientCertEnum(ClientCertificateList clientCertificateList, KeyStore keyStore, Hashtable hashtable) {
            this.this$0 = clientCertificateList;
            this.OEAB = keyStore;
            this.aliases = hashtable;
            try {
                this.certChain = keyStore.aliases();
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }

        public boolean hasMoreElements() {
            return this.certChain.hasMoreElements();
        }

        public Object nextElement() {
            try {
                String string = (String)this.certChain.nextElement();
                X509Certificate x509Certificate = this.OEAB.getCertificate(string);
                KeyEntry keyEntry = (KeyEntry)this.aliases.get(string);
                return keyEntry.certChain[0];
            }
            catch (KeyStoreException keyStoreException) {
                return null;
            }
        }
    }

    final class KeyEntry {
        public Key theKey;
        public X509Certificate[] certChain;
        private final ClientCertificateList this$0;

        KeyEntry(ClientCertificateList clientCertificateList) {
            this.this$0 = clientCertificateList;
        }
    }
}

