/*
 * Decompiled with CFR 0.152.
 */
package ice.ssl;

import ice.ssl.SSLPlaintext;

final class Alert {
    public static final int L_WARNING = 1;
    public static final int L_FATAL = 2;
    public static final int D_CLOSE_NOTIFY = 0;
    public static final int D_UNEXPECTED_MESSAGE = 10;
    public static final int D_BAD_RECORD_MAC = 20;
    public static final int D_DECOMPRESSION_FAILURE = 30;
    public static final int D_HANDSHAKE_FAILURE = 40;
    public static final int D_NO_CERTIFICATE = 41;
    public static final int D_BAD_CERTIFICATE = 42;
    public static final int D_UNSUPPORTED_CERTIFICATE = 43;
    public static final int D_CERTIFICATE_REVOKED = 44;
    public static final int D_CERTIFICATE_EXPIRED = 45;
    public static final int D_CERTIFICATE_UNKNOWN = 46;
    public static final int D_ILLEGAL_PARAMETER = 47;
    public static final int D_DECRYPTION_FAILED = 21;
    public static final int D_RECORD_OVERFLOW = 22;
    public static final int D_UNKNOWN_CA = 48;
    public static final int D_ACCESS_DENIED = 49;
    public static final int D_DECODE_ERROR = 50;
    public static final int D_DECRYPT_ERROR = 51;
    public static final int D_EXPORT_RESTRICTION = 60;
    public static final int D_PROTOCOL_VERSION = 70;
    public static final int D_INSUFFICIENT_SECURITY = 71;
    public static final int D_INTERNAL_ERROR = 80;
    public static final int D_USER_CANCELED = 90;
    public static final int D_NO_RENEGOTIATION = 100;
    private int OEAB;
    private int append;

    public Alert(SSLPlaintext sSLPlaintext) {
        this.OEAB = sSLPlaintext.data[0];
        this.append = sSLPlaintext.data[1];
    }

    public Alert(int n, int n2) {
        this.OEAB = n;
        this.append = n2;
    }

    public int getLevel() {
        return this.OEAB;
    }

    public int getDescription() {
        return this.append;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[]{(byte)this.OEAB, (byte)this.append};
        return byArray;
    }

    public String getDescriptionString() {
        switch (this.append) {
            case 0: {
                return "close notify";
            }
            case 10: {
                return "unexpected message";
            }
            case 20: {
                return "bad record mac";
            }
            case 30: {
                return "decompression failure";
            }
            case 40: {
                return "handshake failure";
            }
            case 41: {
                return "no certificate";
            }
            case 42: {
                return "bad certificate";
            }
            case 43: {
                return "unsupported certificate";
            }
            case 44: {
                return "certificate revoked";
            }
            case 45: {
                return "certificate expired";
            }
            case 46: {
                return "certificate unknown";
            }
            case 47: {
                return "illegal parameter";
            }
            case 21: {
                return "decryption failed";
            }
            case 22: {
                return "record overflow";
            }
            case 48: {
                return "unknown ca";
            }
            case 49: {
                return "access denied";
            }
            case 50: {
                return "decode error";
            }
            case 51: {
                return "decrypt error";
            }
            case 60: {
                return "export restriction";
            }
            case 70: {
                return "protocol version";
            }
            case 71: {
                return "insufficient security";
            }
            case 80: {
                return "internal error";
            }
            case 90: {
                return "user canceled";
            }
            case 100: {
                return "no renegotiation";
            }
        }
        return "" + this.append;
    }

    public String getLevelString() {
        switch (this.OEAB) {
            case 1: {
                return "warning";
            }
            case 2: {
                return "fatal error";
            }
        }
        return "" + this.OEAB;
    }

    public String toString() {
        return this.getLevelString() + ": " + this.getDescriptionString();
    }
}

