/*
 * Decompiled with CFR 0.152.
 */
package cryptix;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;

public class CryptixProperties {
    public static final boolean NATIVE_ALLOWED = true;
    static final String HTML_INFO = "<h1>" + CryptixProperties.getVersionString() + "</h1>\n" + "<p>\n" + "<b>Copyright</b> &copy; 1995-1999\n" + "<a href=\"http://www.systemics.com/\">Systemics Ltd</a> on behalf of the\n" + "<a href=\"http://www.cryptix.org/\">Cryptix Development Team</a>.\n" + "<br>All rights reserved.\n" + "<p>\n" + "This library includes, or is derived from software developed by\n" + "(and owned by):\n" + "<blockquote>\n" + "  Jill&nbsp;Baker, Paulo&nbsp;Barreto, George&nbsp;Barwood,\n" + "  Antoon&nbsp;Bosselaers, Ian&nbsp;Brown, Lawrence&nbsp;Brown,\n" + "  Joan&nbsp;Daemen, Richard&nbsp;De&nbsp;Moliner,\n" + "  John&nbsp;F.&nbspDumas, Jeroen&nbsp;Van&nbsp;Gelderen,\n" + "  Peter&nbsp;Gutmann, Ian&nbsp;Grigg,\n" + "  Mark&nbsp;A.&nbsp;Herschberg, Uwe&nbsp;Hollerbach,\n" + "  David&nbsp;Hopwood, Gary&nbsp;Howland, Geoffrey&nbsp;Keating,\n" + "  Sascha&nbsp;Kettler, Jonathon&nbsp;Knudsen, A.M.&nbsp;Kuchling,\n" + "  Matthew&nbsp;Kwan, Jerry&nbsp;McBride, Andrew&nsbp;E.&nsbp;Mileski,\n" + "  Raif&nbsp;Naffah, NIST, Bryan&nbsp;Olson, Zoran&nbsp;Rajic,\n" + "  Vincent&nbsp;Rijmen, RSA&nbsp;Data&nbsp;Security&nbsp;Inc.,\n" + "  Bruce&nbsp;Schneier, Systemics&nbsp;Ltd., Mike&nbsp;Wynn,\n" + "  Edwin&nbsp;Woudt, Thomas&nbsp;Wu, Eric&nbsp;Young, Yuliang&nbsp;Zheng.\n" + "</blockquote>\n" + "<p>\n" + "See the <a href=\"http://www.cryptix.org/\">site</a>\n" + "for further details.\n";
    static final String PRODUCT_NAME = "Cryptix";
    static final String LIB_DIRNAME = "cryptix-lib";
    static final String[] PROPERTIES_FILES = new String[]{"Cryptix.properties", "Local.properties"};
    private static final Properties OEAB = new Properties();
    private static String append;
    static Class class$cryptix$CryptixProperties;

    private CryptixProperties() {
    }

    public static int getMajorVersion() {
        return 3;
    }

    public static int getMinorVersion() {
        return 1;
    }

    public static int getIntermediateVersion() {
        return 2;
    }

    public static boolean isVersionAtLeast(int n, int n2, int n3) {
        if (3 > n) {
            return true;
        }
        if (3 < n) {
            return false;
        }
        if (1 > n2) {
            return true;
        }
        if (1 < n2) {
            return false;
        }
        return 2 >= n3;
    }

    public static String getReleaseDate() {
        try {
            return "$Date: 2002/05/22 09:14:10 $".substring(7, 17);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return "unknown";
        }
    }

    public static String getVersionString() {
        StringBuffer stringBuffer = new StringBuffer("Cryptix-Java ").append(3).append(".").append(1);
        stringBuffer.append(".").append(2);
        return stringBuffer.toString();
    }

    public static String getHtmlInfo() {
        return HTML_INFO;
    }

    public static void main(String[] stringArray) {
        System.out.println(CryptixProperties.getVersionString());
        System.out.println();
        if (Security.getProvider(PRODUCT_NAME) == null) {
            System.out.println("Cryptix is not installed as a provider in the java.security file.");
            System.out.println("Enter \"java cryptix.provider.Install\" to correct this.");
        } else {
            System.out.println("Cryptix is correctly installed in the java.security file.");
        }
        try {
            String string = CryptixProperties.getLibraryPath();
            System.out.println("The library directory is");
            System.out.println("  " + string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getLibraryPath() throws IOException {
        if (append == null) {
            throw new IOException("Cryptix library directory (cryptix-lib) could not be found");
        }
        return append;
    }

    private static void HTML_INFO() {
        String string = System.getProperty("file.separator");
        boolean bl = false;
        int n = 0;
        while (n < PROPERTIES_FILES.length) {
            InputStream inputStream = (class$cryptix$CryptixProperties == null ? CryptixProperties.class$("cryptix.CryptixProperties") : class$cryptix$CryptixProperties).getResourceAsStream(string + LIB_DIRNAME + string + PROPERTIES_FILES[n]);
            if (inputStream != null) {
                try {
                    OEAB.load(inputStream);
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if ((inputStream = (class$cryptix$CryptixProperties == null ? CryptixProperties.class$("cryptix.CryptixProperties") : class$cryptix$CryptixProperties).getResourceAsStream(string + PROPERTIES_FILES[n])) != null) {
                try {
                    OEAB.load(inputStream);
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if ((inputStream = (class$cryptix$CryptixProperties == null ? CryptixProperties.class$("cryptix.CryptixProperties") : class$cryptix$CryptixProperties).getResourceAsStream(string + "META-INF" + string + PROPERTIES_FILES[n])) != null) {
                try {
                    OEAB.load(inputStream);
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if ((inputStream = (class$cryptix$CryptixProperties == null ? CryptixProperties.class$("cryptix.CryptixProperties") : class$cryptix$CryptixProperties).getResourceAsStream(PROPERTIES_FILES[n])) != null) {
                try {
                    OEAB.load(inputStream);
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            ++n;
        }
        if (!bl) {
            System.err.println("Warning: failed to load the Cryptix properties file.\nMake sure that the CLASSPATH entry for Cryptix is an absolute path.");
        }
    }

    public static void save(OutputStream outputStream, String string) {
        OEAB.save(outputStream, string);
    }

    public static String getProperty(String string) {
        return OEAB.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        return OEAB.getProperty(string, string2);
    }

    public static Enumeration propertyNames() {
        return OEAB.propertyNames();
    }

    public static void list(PrintStream printStream) {
        OEAB.list(printStream);
    }

    public static void list(PrintWriter printWriter) {
        OEAB.list(printWriter);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        CryptixProperties.HTML_INFO();
    }
}

