/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop;

import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class MWWritableOutput {
    private classType type = classType.NOTSUPPORTED;
    private Writable instance = null;
    private boolean isWritable = false;
    private Text key = new Text();

    public MWWritableOutput(Class<?> theClass) {
        this.setType(theClass);
    }

    public void setWritable(boolean isWritable) {
        this.isWritable = isWritable;
    }

    private void setType(Class<?> theClass) {
        if (theClass.equals(Text.class)) {
            this.type = classType.TEXT;
            this.instance = new Text();
        } else if (theClass.equals(LongWritable.class)) {
            this.type = classType.LONG;
            this.instance = new LongWritable();
        } else if (theClass.equals(IntWritable.class)) {
            this.type = classType.INT;
            this.instance = new IntWritable();
        } else if (theClass.equals(DoubleWritable.class)) {
            this.type = classType.DOUBLE;
            this.instance = new DoubleWritable();
        } else if (theClass.equals(BytesWritable.class)) {
            this.type = classType.BYTES;
            this.instance = new BytesWritable();
        } else if (theClass.equals(ByteWritable.class)) {
            this.type = classType.BYTE;
            this.instance = new ByteWritable();
        } else if (theClass.equals(BooleanWritable.class)) {
            this.type = classType.BOOLEAN;
            this.instance = new BooleanWritable();
        } else if (theClass.equals(FloatWritable.class)) {
            this.type = classType.FLOAT;
            this.instance = new FloatWritable();
        }
    }

    public Writable getInstance() {
        return this.instance;
    }

    public void setInstance(Object value) {
        if (this.isWritable) {
            this.instance = (Writable)value;
        } else {
            if (this.type == classType.NOTSUPPORTED) {
                throw new RuntimeException("The type of instance is: " + value.getClass() + ", which is NOT supported by MWWritableAdapter.");
            }
            switch (this.type) {
                case LONG: {
                    ((LongWritable)this.instance).set(((Number)value).longValue());
                    break;
                }
                case INT: {
                    ((IntWritable)this.instance).set(((Number)value).intValue());
                    break;
                }
                case DOUBLE: {
                    ((DoubleWritable)this.instance).set(((Number)value).doubleValue());
                    break;
                }
                case BYTES: {
                    ((BytesWritable)this.instance).set((byte[])value, 0, ((byte[])value).length);
                    break;
                }
                case BYTE: {
                    ((ByteWritable)this.instance).set(((Byte)value).byteValue());
                    break;
                }
                case BOOLEAN: {
                    ((BooleanWritable)this.instance).set(((Boolean)value).booleanValue());
                    break;
                }
                case TEXT: {
                    ((Text)this.instance).set(value.toString());
                    break;
                }
                case FLOAT: {
                    ((FloatWritable)this.instance).set(((Number)value).floatValue());
                }
            }
        }
    }

    static enum classType {
        NOTSUPPORTED,
        TEXT,
        LONG,
        INT,
        DOUBLE,
        BYTES,
        BYTE,
        BOOLEAN,
        FLOAT;

    }
}

