/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hadoop;

import com.mathworks.hadoop.MWArrayWritable;
import com.mathworks.hadoop.MWWritableOutput;
import com.mathworks.hadoop.MxArrayWritable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Reducer;

public class MWReduceObject
implements Serializable {
    ReduceIterator riterator = null;
    Object rcontext = null;

    public MWReduceObject(Reducer.Context context, String[] cachedFiles) {
        boolean isMLArrayOutputKey = context.getOutputValueClass().equals(MxArrayWritable.class);
        boolean isMLArrayOutputValue = context.getOutputKeyClass().equals(MxArrayWritable.class);
        this.riterator = new ReduceIterator(context);
        if (isMLArrayOutputKey) {
            if (isMLArrayOutputValue) {
                this.rcontext = new ReduceContext2(context, cachedFiles);
            } else {
                System.err.println("Error: Can not mix MxArrayWritable with other Writable for reduce output key/value classes.");
            }
        } else {
            this.rcontext = new ReduceContext(context, cachedFiles);
        }
    }

    public ReduceIterator getInterator() {
        return this.riterator;
    }

    public Object getContext() {
        return this.rcontext;
    }

    class ReduceContext2 {
        Reducer.Context context = null;
        private boolean firstTime = true;
        private String[] cachedFiles = null;

        ReduceContext2(Reducer.Context context, String[] cachedFiles) {
            this.context = context;
        }

        public Reducer.Context getContext() {
            return this.context;
        }

        public String get(String prop) {
            return this.context.getConfiguration().get(prop);
        }

        public String[] getCachedFiles() {
            return this.cachedFiles;
        }

        public boolean isMatlabKey() {
            return true;
        }

        public boolean isMatlabValue() {
            return true;
        }

        public void add(byte[] keys, byte[] values) throws IOException, InterruptedException {
            if (keys == null) {
                return;
            }
            this.context.write((Object)new MxArrayWritable(keys), (Object)new MxArrayWritable(values));
        }

        public void addMultiple(Object[] keys, Object[] values) throws IOException, InterruptedException {
            if (keys == null) {
                return;
            }
            if (keys.length != values.length) {
                throw new IOException("The number of keys and values must match when they are both arrays.");
            }
            for (int index = 0; index < keys.length; ++index) {
                this.context.write((Object)new MxArrayWritable((byte[])keys[index]), (Object)new MxArrayWritable((byte[])values[index]));
            }
        }
    }

    class ReduceContext {
        private Reducer.Context context = null;
        private MWWritableOutput kadapter = null;
        private MWWritableOutput vadapter = null;
        private MWArrayWritable mwArray = null;
        private boolean firstTime = true;
        private String[] cachedFiles = null;
        private boolean isTextValue = false;

        ReduceContext(Reducer.Context context, String[] cachedFiles) {
            this.context = context;
            this.cachedFiles = cachedFiles;
            this.kadapter = new MWWritableOutput(context.getOutputKeyClass());
            if (!context.getOutputValueClass().equals(MWArrayWritable.class)) {
                if (context.getOutputValueClass().equals(Text.class)) {
                    this.isTextValue = true;
                }
                this.vadapter = new MWWritableOutput(context.getOutputValueClass());
            } else {
                this.mwArray = new MWArrayWritable();
            }
        }

        public Reducer.Context getContext() {
            return this.context;
        }

        public String get(String prop) {
            return this.context.getConfiguration().get(prop);
        }

        public String[] getCachedFiles() {
            return this.cachedFiles;
        }

        public boolean isMatlabKey() {
            return false;
        }

        public boolean isMatlabValue() {
            return false;
        }

        public void add(Object keys, Object values) throws IOException, InterruptedException {
            if (keys == null) {
                return;
            }
            if (!keys.getClass().isArray()) {
                if (values == null && this.isTextValue) {
                    this.write(keys, new Text(""));
                } else {
                    this.write(keys, values);
                }
            } else if (values.getClass().isArray()) {
                this.addMultiple((Object[])keys, (Object[])values);
            } else {
                throw new IOException("Values must be an array when the reducer outputs multiple keys");
            }
        }

        public void addMultiple(Object[] keys, Object[] values) throws IOException, InterruptedException {
            if (keys == null) {
                return;
            }
            int numKeys = keys.length;
            int numValues = values.length;
            if (numKeys != numValues) {
                throw new IOException("The number of keys and values must match when they are both cell arrays.");
            }
            for (int cellIndex = 0; cellIndex < numKeys; ++cellIndex) {
                if (values[cellIndex] == null && this.isTextValue) {
                    this.write(keys[cellIndex], new Text(""));
                    continue;
                }
                this.write(keys[cellIndex], values[cellIndex]);
            }
        }

        public void write(Object key, Object value) throws IOException, InterruptedException {
            if (this.firstTime) {
                this.kadapter.setWritable(key instanceof Writable);
                if (this.vadapter != null) {
                    this.vadapter.setWritable(value instanceof Writable);
                }
                this.firstTime = false;
            }
            this.kadapter.setInstance(key);
            Writable theKey = this.kadapter.getInstance();
            if (this.vadapter != null) {
                this.vadapter.setInstance(value);
                this.context.write((Object)theKey, (Object)this.vadapter.getInstance());
            } else {
                if (!value.getClass().isArray()) {
                    if (value.getClass().equals(MWArrayWritable.class)) {
                        this.context.write((Object)theKey, (Object)((MWArrayWritable)value));
                    } else {
                        throw new IOException("The values is not an array as expected");
                    }
                }
                this.mwArray.set(value);
                this.context.write((Object)theKey, (Object)this.mwArray);
            }
        }
    }

    class ReduceIterator {
        private Iterator<Object> iterator = null;
        private String reducefunc = null;
        private Reducer.Context context = null;

        ReduceIterator(Reducer.Context context) {
            this.context = context;
        }

        public boolean nextkey() throws IOException, InterruptedException {
            return this.context.nextKey();
        }

        public Object getcurrentkey() throws IOException, InterruptedException {
            return this.context.getCurrentKey();
        }

        public Iterator<Object> getvalues() throws IOException, InterruptedException {
            this.iterator = this.context.getValues().iterator();
            return this.iterator;
        }

        public boolean hasnext() {
            return this.iterator.hasNext();
        }

        public Object getnext() {
            return this.iterator.next();
        }

        public String get(String prop) {
            return this.context.getConfiguration().get(prop);
        }
    }
}

