/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.webfigures.service.request;

import com.mathworks.toolbox.javabuilder.logging.MWLogger;
import com.mathworks.toolbox.javabuilder.services.ServiceException;
import com.mathworks.toolbox.javabuilder.services.StatefulServicePeerAction;
import com.mathworks.toolbox.javabuilder.services.StatefulServicePeerActionDispatcher;
import com.mathworks.toolbox.javabuilder.statemanager.StateManagerContext;
import com.mathworks.toolbox.javabuilder.webfigures.WebFigure;
import com.mathworks.toolbox.javabuilder.webfigures.service.WebFigurePeer;
import com.mathworks.toolbox.javabuilder.webfigures.service.request.NamedWebFigureServiceRequest;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureBinaryResourceResult;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class WebFigureRenderRequest
extends NamedWebFigureServiceRequest<WebFigureBinaryResourceResult> {
    public static final long MAX_PIXELS = 0x4000000L;
    private static final Logger LOGGER = MWLogger.getLogger(WebFigure.class.getPackage().getName());
    private String width = null;
    private String height = null;
    private String imageFormat = "png";
    private String rotation = null;
    private String elevation = null;
    private String cropLeft = null;
    private String cropRight = null;
    private String cropTop = null;
    private String cropBottom = null;

    public WebFigureRenderRequest() {
    }

    private static boolean stringsEqual(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && string.equals(string2);
    }

    private static int hashStrings(String ... stringArray) {
        int n = 0;
        for (String string : stringArray) {
            n = 31 * n + (string == null ? 0 : string.hashCode());
        }
        return n;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + WebFigureRenderRequest.hashStrings(this.width, this.height, this.imageFormat, this.rotation, this.elevation, this.cropLeft, this.cropRight, this.cropTop, this.cropBottom);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof WebFigureRenderRequest) {
            WebFigureRenderRequest webFigureRenderRequest = (WebFigureRenderRequest)object;
            return WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.width, this.width) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.height, this.height) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.imageFormat, this.imageFormat) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.rotation, this.rotation) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.elevation, this.elevation) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.cropLeft, this.cropLeft) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.cropRight, this.cropRight) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.cropTop, this.cropTop) && WebFigureRenderRequest.stringsEqual(webFigureRenderRequest.cropBottom, this.cropBottom);
        }
        return false;
    }

    public WebFigureRenderRequest(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        super(string, string2);
        this.width = string3;
        this.height = string4;
        this.imageFormat = string5;
        this.cropLeft = string8;
        this.cropRight = string9;
        this.cropTop = string10;
        this.cropBottom = string11;
        this.rotation = string6;
        this.elevation = string7;
    }

    private Map<String, Object> getParamsMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        WebFigureRenderRequest.addDoubleParameter(hashMap, "rotation", this.getRotation());
        WebFigureRenderRequest.addDoubleParameter(hashMap, "elevation", this.getElevation());
        WebFigureRenderRequest.addIntegerParameter(hashMap, "width", this.getWidth());
        WebFigureRenderRequest.addIntegerParameter(hashMap, "height", this.getHeight());
        WebFigureRenderRequest.addStringParameter(hashMap, "imageFormat", this.getImageFormat());
        WebFigureRenderRequest.addIntegerParameter(hashMap, "cropLeft", this.getCropLeft());
        WebFigureRenderRequest.addIntegerParameter(hashMap, "cropRight", this.getCropRight());
        WebFigureRenderRequest.addIntegerParameter(hashMap, "cropTop", this.getCropTop());
        WebFigureRenderRequest.addIntegerParameter(hashMap, "cropBottom", this.getCropBottom());
        return hashMap;
    }

    @Override
    public String toString() {
        return super.toString() + " render: " + this.getParamsMap().toString();
    }

    @Override
    public WebFigureBinaryResourceResult process(StateManagerContext stateManagerContext, StatefulServicePeerActionDispatcher<WebFigurePeer> statefulServicePeerActionDispatcher) throws ServiceException {
        final Map<String, Object> map = this.getParamsMap();
        if (map.get("width") != null && (Integer)map.get("width") == 0) {
            throw new ServiceException("width must not be 0");
        }
        if (map.get("height") != null && (Integer)map.get("height") == 0) {
            throw new ServiceException("height must not be 0");
        }
        if (null != map.get("width") && null != map.get("height")) {
            long l;
            long l2;
            long l3;
            long l4;
            long l5 = ((Integer)map.get("width")).intValue();
            long l6 = ((Integer)map.get("height")).intValue();
            long l7 = l5;
            long l8 = l6;
            if (null != map.get("cropLeft")) {
                l4 = ((Integer)map.get("cropLeft")).intValue();
                l7 -= l4;
            } else {
                l4 = 0L;
            }
            if (null != map.get("cropRight")) {
                l3 = ((Integer)map.get("cropRight")).intValue();
                l7 -= l3;
            } else {
                l3 = 0L;
            }
            if (null != map.get("cropTop")) {
                l2 = ((Integer)map.get("cropTop")).intValue();
                l8 -= l2;
            } else {
                l2 = 0L;
            }
            if (null != map.get("cropBottom")) {
                l = ((Integer)map.get("cropBottom")).intValue();
                l8 -= l;
            } else {
                l = 0L;
            }
            if (l7 * l8 > 0x4000000L) {
                long l9;
                long l10;
                LOGGER.warning("Clipping to maximum resolution (requested image " + l7 + "," + l8 + ")");
                if (l7 > l8) {
                    l10 = (long)Math.sqrt(0x4000000L * l7 / l8);
                    l9 = 0x4000000L / l10;
                } else {
                    l9 = (long)Math.sqrt(0x4000000L * l8 / l7);
                    l10 = 0x4000000L / l9;
                }
                long l11 = l5 * l10 / l7;
                long l12 = l4 * l10 / l7;
                long l13 = l3 * l10 / l7;
                long l14 = l6 * l9 / l8;
                long l15 = l * l9 / l8;
                long l16 = l2 * l9 / l8;
                map.put("width", (int)l11);
                map.put("cropLeft", (int)l12);
                map.put("cropRight", (int)l13);
                map.put("height", (int)l14);
                map.put("cropTop", (int)l16);
                map.put("cropBottom", (int)l15);
            }
        }
        try {
            byte[] byArray = statefulServicePeerActionDispatcher.dispatch(new StatefulServicePeerAction<WebFigurePeer, byte[]>(){

                @Override
                public byte[] execute(WebFigurePeer webFigurePeer) throws Throwable {
                    return webFigurePeer.renderEncoded(map);
                }
            }, stateManagerContext, this.getScope(), this.getName());
            String string = "image/" + this.getImageFormat();
            return new WebFigureBinaryResourceResult(byArray, string);
        }
        catch (Throwable throwable) {
            throw new ServiceException(throwable);
        }
    }

    private static void addStringParameter(Map<String, Object> map, String string, String string2) {
        if (string2 != null) {
            map.put(string, string2);
        }
    }

    private static void addDoubleParameter(Map<String, Object> map, String string, String string2) {
        if (string2 != null) {
            map.put(string, Double.parseDouble(string2));
        }
    }

    private static void addIntegerParameter(Map<String, Object> map, String string, String string2) {
        if (string2 != null) {
            map.put(string, Integer.parseInt(string2));
        }
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String string) {
        this.width = string;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String string) {
        this.height = string;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String string) {
        this.imageFormat = string;
    }

    public String getCropLeft() {
        return this.cropLeft;
    }

    public void setCropLeft(String string) {
        this.cropLeft = string;
    }

    public String getCropRight() {
        return this.cropRight;
    }

    public void setCropRight(String string) {
        this.cropRight = string;
    }

    public String getCropTop() {
        return this.cropTop;
    }

    public void setCropTop(String string) {
        this.cropTop = string;
    }

    public String getCropBottom() {
        return this.cropBottom;
    }

    public void setCropBottom(String string) {
        this.cropBottom = string;
    }

    public String getRotation() {
        return this.rotation;
    }

    public void setRotation(String string) {
        this.rotation = string;
    }

    public String getElevation() {
        return this.elevation;
    }

    public void setElevation(String string) {
        this.elevation = string;
    }
}

