/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.webfigures;

import com.mathworks.toolbox.javabuilder.MWException;
import com.mathworks.toolbox.javabuilder.caching.Cache;
import com.mathworks.toolbox.javabuilder.caching.SoftReferenceCache;
import com.mathworks.toolbox.javabuilder.services.ServiceException;
import com.mathworks.toolbox.javabuilder.statemanager.http.HttpServletRequestStateManagerContext;
import com.mathworks.toolbox.javabuilder.webfigures.DefaultWebFigure;
import com.mathworks.toolbox.javabuilder.webfigures.WebFigure;
import com.mathworks.toolbox.javabuilder.webfigures.WebFigureHtmlGenerator;
import com.mathworks.toolbox.javabuilder.webfigures.internal.WebFigureResources;
import com.mathworks.toolbox.javabuilder.webfigures.service.WebFigureService;
import com.mathworks.toolbox.javabuilder.webfigures.service.WebFigureServiceFactory;
import com.mathworks.toolbox.javabuilder.webfigures.service.http.WebFigureServiceRequestFormQueryHttpRequestFactory;
import com.mathworks.toolbox.javabuilder.webfigures.service.http.WebFigureServiceRequestHttpRequestFactory;
import com.mathworks.toolbox.javabuilder.webfigures.service.http.WebFigureServiceResultHttpResponseWriter;
import com.mathworks.toolbox.javabuilder.webfigures.service.http.WebFigureServiceResultJSONHttpResponseWriter;
import com.mathworks.toolbox.javabuilder.webfigures.service.request.WebFigureJavaScriptRequest;
import com.mathworks.toolbox.javabuilder.webfigures.service.request.WebFigureResourceRequest;
import com.mathworks.toolbox.javabuilder.webfigures.service.request.WebFigureServiceRequest;
import com.mathworks.toolbox.javabuilder.webfigures.service.result.WebFigureServiceResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebFiguresServlet
extends HttpServlet {
    private WebFigureService fFigureService;
    private WebFigureServiceRequestHttpRequestFactory fRequestFactory;
    private WebFigureServiceResultHttpResponseWriter fResponseWriter;
    private Cache<WebFigureServiceRequest<?>, WebFigureServiceResult> fResponseCache;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.fFigureService = WebFigureServiceFactory.newWebFigureService();
            this.fRequestFactory = new WebFigureServiceRequestFormQueryHttpRequestFactory();
            this.fResponseWriter = new WebFigureServiceResultJSONHttpResponseWriter();
            this.fResponseCache = new SoftReferenceCache();
        }
        catch (MWException mWException) {
            this.log(mWException.toString());
        }
    }

    public void destroy() {
        this.fFigureService.dispose();
    }

    private static boolean isCachableRequest(Object object) {
        return !WebFigureResources.USING_LOCAL_RESOURCE_DIR && (object instanceof WebFigureResourceRequest || object instanceof WebFigureJavaScriptRequest);
    }

    private static String getDefaultPage(HttpServletRequest httpServletRequest) throws ServiceException {
        try {
            WebFigure webFigure = (WebFigure)httpServletRequest.getSession().getServletContext().getAttribute("com.mathworks.toolbox.javabuilder.webfigure.DefaultWebFigure");
            if (webFigure == null) {
                webFigure = DefaultWebFigure.getInstance();
                httpServletRequest.getSession().getServletContext().setAttribute("com.mathworks.toolbox.javabuilder.webfigure.DefaultWebFigure", (Object)webFigure);
            }
            WebFigureHtmlGenerator webFigureHtmlGenerator = new WebFigureHtmlGenerator(httpServletRequest);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("This is the Default WebFigure built into WebFigureService.  <BR> Please see the Builder JA documentation for more information on how to use WebFigures.<BR><BR>");
            stringBuffer.append("If you see a fully interactive frame containing the MathWorks Logo then WebFiguers has been correctly configured and started.<BR><BR>");
            stringBuffer.append(webFigureHtmlGenerator.getFigureEmbedString("com.mathworks.toolbox.javabuilder.webfigure.DefaultWebFigure", "application", null));
            return stringBuffer.toString();
        }
        catch (MWException mWException) {
            throw new ServiceException(mWException);
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            if (httpServletRequest.getPathInfo() == null) {
                httpServletResponse.setContentType("text/html;charset=UTF-8");
                httpServletResponse.getWriter().print(WebFiguresServlet.getDefaultPage(httpServletRequest));
                return;
            }
            final HttpServletRequestStateManagerContext httpServletRequestStateManagerContext = new HttpServletRequestStateManagerContext(httpServletRequest);
            final WebFigureServiceRequest<?> webFigureServiceRequest = this.fRequestFactory.newServiceRequest(httpServletRequest);
            try {
                WebFigureServiceResult webFigureServiceResult;
                Callable<WebFigureServiceResult> callable = new Callable<WebFigureServiceResult>(){

                    @Override
                    public WebFigureServiceResult call() throws Exception {
                        return (WebFigureServiceResult)WebFiguresServlet.this.fFigureService.processRequest(webFigureServiceRequest, httpServletRequestStateManagerContext);
                    }
                };
                if (WebFiguresServlet.isCachableRequest(webFigureServiceRequest)) {
                    webFigureServiceResult = this.fResponseCache.get(webFigureServiceRequest, callable).get();
                } else {
                    try {
                        webFigureServiceResult = (WebFigureServiceResult)callable.call();
                    }
                    catch (Exception exception) {
                        throw new ServiceException(exception);
                    }
                }
                this.fResponseWriter.write(httpServletResponse, webFigureServiceResult);
            }
            catch (InterruptedException interruptedException) {
                throw new ServiceException(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new ServiceException(executionException);
            }
        }
        catch (ServiceException serviceException) {
            StringWriter stringWriter = new StringWriter();
            serviceException.printStackTrace(new PrintWriter(stringWriter));
            this.log(stringWriter.toString());
            httpServletResponse.sendError(500, stringWriter.toString());
        }
    }
}

