/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.proxy;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

public final class BasicProxyTrustVerifier
implements TrustVerifier,
Serializable {
    private static final long serialVersionUID = 2L;
    private final RemoteMethodControl proxy;

    public BasicProxyTrustVerifier(Object object) {
        if (!(object instanceof RemoteMethodControl)) {
            throw new IllegalArgumentException("proxy not a RemoteMethodControl instance");
        }
        if (!(object instanceof TrustEquivalence)) {
            throw new IllegalArgumentException("proxy not a TrustEquivalence instance");
        }
        this.proxy = (RemoteMethodControl)object;
    }

    public boolean isTrustedObject(Object object, TrustVerifier.Context context) {
        if (object == null || context == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof RemoteMethodControl)) {
            return false;
        }
        RemoteMethodControl remoteMethodControl = (RemoteMethodControl)object;
        MethodConstraints methodConstraints = remoteMethodControl.getConstraints();
        TrustEquivalence trustEquivalence = (TrustEquivalence)((Object)this.proxy.setConstraints(methodConstraints));
        return trustEquivalence.checkTrustEquivalence(remoteMethodControl);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!(this.proxy instanceof RemoteMethodControl)) {
            throw new InvalidObjectException("proxy not a RemoteMethodControl instance");
        }
        if (!(this.proxy instanceof TrustEquivalence)) {
            throw new InvalidObjectException("proxy not a TrustEquivalence instance");
        }
    }
}

