/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.collections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

public class IdentityHashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private transient IdentityHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<? extends E> collection) {
        this.map = new IdentityHashMap(collection.size());
        this.addAll(collection);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            IdentityHashSet identityHashSet = (IdentityHashSet)super.clone();
            identityHashSet.map = (IdentityHashMap)this.map.clone();
            return identityHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

