/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CollectionMap<K, V> {
    private final Map<K, Collection<V>> fMap;
    private final Class<? extends Map> fMapClass;
    private final Class<? extends Collection> fCollectionClass;

    public CollectionMap() {
        this(HashMap.class, ArrayList.class);
    }

    public CollectionMap(Class<? extends Map> clazz, Class<? extends Collection> clazz2) {
        this.fCollectionClass = clazz2;
        this.fMapClass = clazz;
        this.fMap = this.createMap();
    }

    public CollectionMap(CollectionMap<K, V> collectionMap) {
        this.fMapClass = collectionMap.fMapClass;
        this.fCollectionClass = collectionMap.fCollectionClass;
        this.fMap = this.createMap();
        for (Map.Entry<K, Collection<V>> entry : collectionMap.entrySet()) {
            Collection<V> collection = this.createCollection();
            collection.addAll(entry.getValue());
            this.fMap.put(entry.getKey(), collection);
        }
    }

    public synchronized Collection<V> get(K k) {
        Collection<V> collection = this.fMap.get(k);
        Collection<V> collection2 = this.createCollection();
        if (collection != null) {
            collection2.addAll(collection);
        }
        return collection2;
    }

    public synchronized boolean add(K k, V v) {
        Collection<V> collection = this.fMap.get(k);
        if (collection == null) {
            collection = this.createCollection();
            this.fMap.put(k, collection);
        }
        boolean bl = collection.add(v);
        if (collection.isEmpty()) {
            this.fMap.remove(k);
        }
        return bl;
    }

    public synchronized Collection<V> remove(K k) {
        Collection<V> collection = this.fMap.remove(k);
        return collection == null ? this.createCollection() : collection;
    }

    public synchronized boolean remove(K k, V v) {
        Collection<V> collection = this.fMap.get(k);
        if (collection == null) {
            return false;
        }
        boolean bl = collection.remove(v);
        if (collection.isEmpty()) {
            this.fMap.remove(k);
        }
        return bl;
    }

    public synchronized int size() {
        return this.fMap.size();
    }

    public synchronized Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.fMap.entrySet();
    }

    public synchronized Set<K> keySet() {
        return this.fMap.keySet();
    }

    private Collection<V> createCollection() {
        try {
            return this.fCollectionClass.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private Map<K, Collection<V>> createMap() {
        try {
            return this.fMapClass.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static <K, V> CollectionMap<K, V> invert(Map<V, K> map2) {
        CollectionMap<K, V> collectionMap = new CollectionMap<K, V>(HashMap.class, HashSet.class);
        for (Map.Entry<V, K> entry : map2.entrySet()) {
            collectionMap.add(entry.getValue(), entry.getKey());
        }
        return collectionMap;
    }
}

