/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.Log;

public class CharBuffer {
    public static final int INCREMENT_MODE = 0;
    public static final int MODULO_INCREMENT_MODE = 1;
    public static final int DOUBLE_MODE = 2;
    public static final int DOUBLING_MODE = 3;
    public static final int QUAD_MODE = 4;
    private char[] fBuf;
    private int fLength;
    private int fIncrement;
    private int fGrowthFactor;
    private int fGrowthMode;
    private static final char NULL_VALUE = '\u0000';
    private static final char[] EMPTY_ARRAY = new char[0];
    private final char[] fSingletonArray = new char[1];

    public CharBuffer() {
        this(32, 256);
    }

    public CharBuffer(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("InitialCapacity (" + n + ") must be > 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Increment (" + n2 + ") must be > 0");
        }
        this.fLength = 0;
        this.fIncrement = n2;
        this.fBuf = new char[n];
    }

    public CharBuffer(String string) {
        this.fIncrement = 256;
        if (string == null) {
            this.fBuf = new char[32];
        } else {
            this.fLength = string.length();
            this.fBuf = new char[this.fLength];
            string.getChars(0, this.fLength, this.fBuf, 0);
        }
    }

    public int length() {
        return this.fLength;
    }

    public void setSize(int n) {
        this.setSize(n, true);
    }

    public void setSize(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("newSize (" + n + ") must be >= 0");
        }
        if (n > this.fLength) {
            this.ensureCapacity(n);
        } else if (bl) {
            for (int i = n; i < this.fBuf.length; ++i) {
                this.fBuf[i] = '\u0000';
            }
        }
        this.fLength = n;
    }

    public void ensureCapacity(int n) {
        if (n > this.fBuf.length) {
            int n2;
            if (this.fGrowthFactor > n) {
                n2 = this.fGrowthFactor;
            } else {
                switch (this.fGrowthMode) {
                    case 0: {
                        n2 = this.fBuf.length + this.fIncrement;
                        break;
                    }
                    case 1: {
                        n2 = (n + this.fIncrement - 1) / this.fIncrement * this.fIncrement;
                        break;
                    }
                    case 2: {
                        n2 = this.fBuf.length << 1;
                        if (n2 <= this.fIncrement) break;
                        n2 = (n + this.fIncrement - 1) / this.fIncrement * this.fIncrement;
                        break;
                    }
                    case 3: {
                        for (n2 = this.fBuf.length << 1; n > n2; n2 <<= 1) {
                        }
                        break;
                    }
                    case 4: {
                        n2 = this.fBuf.length << 2;
                        if (n2 <= this.fIncrement) break;
                        n2 = (n + this.fIncrement - 1) / this.fIncrement * this.fIncrement;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
            }
            if (n > n2) {
                n2 = n + this.fIncrement;
            }
            char[] cArray = this.fBuf;
            this.fBuf = new char[n2];
            System.arraycopy(cArray, 0, this.fBuf, 0, cArray.length);
        }
    }

    public void setCapacityIncrement(int n) {
        if (n > 0) {
            this.fIncrement = n;
        }
    }

    public void setGrowthFactor(int n) {
        if (n >= 0) {
            this.fGrowthFactor = n;
        }
    }

    public void setGrowthMode(int n) {
        if (n >= 0 && n <= 4) {
            this.fGrowthMode = n;
        }
    }

    public void append(char c) {
        this.insert(this.fLength, c);
    }

    public void append(char[] cArray) {
        this.insert(this.fLength, cArray);
    }

    public synchronized void insert(int n, char c) {
        this.fSingletonArray[0] = c;
        this.replace(n, n, this.fSingletonArray);
        this.fSingletonArray[0] = '\u0000';
    }

    public void insert(int n, char[] cArray) {
        this.replace(n, n, cArray, cArray.length);
    }

    public void insert(int n, char[] cArray, int n2) {
        this.replace(n, n, cArray, n2);
    }

    public void delete(int n, int n2) {
        this.replace(n, n2, EMPTY_ARRAY);
    }

    public void replace(int n, int n2, char c) {
        this.fSingletonArray[0] = c;
        this.replace(n, n2, this.fSingletonArray);
        this.fSingletonArray[0] = '\u0000';
    }

    public void replace(int n, int n2, char[] cArray) {
        this.replace(n, n2, cArray, cArray.length);
    }

    public void replace(int n, int n2, char[] cArray, int n3) {
        this.replace(n, n2, cArray, 0, n3);
    }

    public void replace(int n, int n2, char[] cArray, int n3, int n4) {
        this.checkRange(n, n2);
        if (cArray == null) {
            throw new IllegalArgumentException();
        }
        int n5 = n4 - (n2 - n);
        this.ensureCapacity(this.fLength + n5);
        System.arraycopy(this.fBuf, n2, this.fBuf, n2 + n5, this.fLength - n2);
        System.arraycopy(cArray, n3, this.fBuf, n, n4);
        if (n5 < 0) {
            for (int i = this.fLength + n5; i < this.fLength; ++i) {
                this.fBuf[i] = '\u0000';
            }
        }
        this.fLength += n5;
    }

    public char getAt(int n) {
        this.checkIndex(n);
        return this.fBuf[n];
    }

    public void setAt(int n, char c) {
        this.checkIndex(n);
        this.fBuf[n] = c;
    }

    public char[] getRawBuf() {
        return this.fBuf;
    }

    public String toString() {
        return this.toString(0, this.length());
    }

    public String toString(int n, int n2) {
        this.checkRange(n, n2);
        return new String(this.fBuf, n, n2 - n);
    }

    private void checkRange(int n, int n2) {
        if (Log.LOGGING) {
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            if (n != this.fLength) {
                this.checkHelper(n);
            }
            if (n2 != this.fLength) {
                this.checkHelper(n2);
            }
        }
    }

    private void checkIndex(int n) {
        if (Log.LOGGING) {
            this.checkHelper(n);
        }
    }

    private void checkHelper(int n) {
        if (n < 0 || n >= this.fLength) {
            throw new IllegalArgumentException("Invalid index (" + n + ") should be in the range [0," + this.fLength + "]");
        }
    }
}

