/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.UnicastSocketTimeout;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;

public final class ConstrainableLookupLocator
extends LookupLocator
implements RemoteMethodControl {
    private static final long serialVersionUID = 7061417093114347317L;
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final Method getRegistrarMethod;
    private static final Method getRegistrarTimeoutMethod;
    private final MethodConstraints constraints;

    public ConstrainableLookupLocator(String string, MethodConstraints methodConstraints) throws MalformedURLException {
        super(string);
        this.constraints = methodConstraints;
    }

    public ConstrainableLookupLocator(String string, int n, MethodConstraints methodConstraints) {
        super(string, n);
        this.constraints = methodConstraints;
    }

    public ServiceRegistrar getRegistrar() throws IOException, ClassNotFoundException {
        return this.getRegistrar(this.constraints != null ? this.constraints.getConstraints(getRegistrarMethod) : InvocationConstraints.EMPTY);
    }

    public ServiceRegistrar getRegistrar(int n) throws IOException, ClassNotFoundException {
        InvocationConstraints invocationConstraints = this.constraints != null ? this.constraints.getConstraints(getRegistrarTimeoutMethod) : InvocationConstraints.EMPTY;
        ArrayList<UnicastSocketTimeout> arrayList = new ArrayList<UnicastSocketTimeout>(invocationConstraints.requirements());
        arrayList.add(new UnicastSocketTimeout(n));
        return this.getRegistrar(new InvocationConstraints(arrayList, (Collection)invocationConstraints.preferences()));
    }

    public RemoteMethodControl setConstraints(MethodConstraints methodConstraints) {
        return new ConstrainableLookupLocator(this.host, this.port, methodConstraints);
    }

    public MethodConstraints getConstraints() {
        return this.constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistrar getRegistrar(InvocationConstraints invocationConstraints) throws IOException, ClassNotFoundException {
        ServiceRegistrar serviceRegistrar;
        Discovery discovery;
        DiscoveryConstraints discoveryConstraints = DiscoveryConstraints.process((InvocationConstraints)invocationConstraints);
        int n = discoveryConstraints.chooseProtocolVersion();
        switch (n) {
            case 1: {
                discovery = Discovery.getProtocol1();
                break;
            }
            case 2: {
                discovery = Discovery.getProtocol2(null);
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
        Socket socket = new Socket(this.host, this.port);
        socket.setSoTimeout(discoveryConstraints.getUnicastSocketTimeout(60000));
        try {
            UnicastResponse unicastResponse = discovery.doUnicastDiscovery(socket, discoveryConstraints.getUnfulfilledConstraints(), null, null, null);
            serviceRegistrar = unicastResponse.getRegistrar();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return serviceRegistrar;
    }

    static {
        try {
            getRegistrarMethod = LookupLocator.class.getMethod("getRegistrar", new Class[0]);
            getRegistrarTimeoutMethod = LookupLocator.class.getMethod("getRegistrar", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }
}

