/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.RegistrarProxy;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import net.jini.loader.ClassLoading;

class EntryClass
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected String name;
    protected EntryClass superclass;
    protected int numFields;
    protected long hash;
    protected transient int numInstances;
    protected transient int numTemplates;
    protected transient EntryClass replacement;
    private transient boolean integrity = false;

    public EntryClass(Class clazz, EntryClass entryClass) {
        this.name = clazz.getName();
        this.superclass = entryClass;
        ClassMapper.EntryField[] entryFieldArray = ClassMapper.getFields(clazz);
        this.numFields = entryFieldArray.length;
        if (entryClass != null && this.numFields == entryClass.numFields) {
            this.hash = entryClass.hash;
        } else if (this.numFields != 0) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(new ByteArrayOutputStream(127), messageDigest));
                if (entryClass != null) {
                    dataOutputStream.writeLong(entryClass.hash);
                }
                for (int i = entryClass.numFields; i < entryFieldArray.length; ++i) {
                    dataOutputStream.writeUTF(entryFieldArray[i].field.getName());
                    dataOutputStream.writeUTF(entryFieldArray[i].field.getType().getName());
                }
                dataOutputStream.flush();
                byte[] byArray = messageDigest.digest();
                int n = Math.min(8, byArray.length);
                while (--n >= 0) {
                    this.hash += (long)(byArray[n] & 0xFF) << n * 8;
                }
            }
            catch (Exception exception) {
                RegistrarProxy.handleException(exception);
                this.hash = 0L;
            }
        }
    }

    private EntryClass(EntryClass entryClass) {
        this.name = entryClass.name;
    }

    public String getName() {
        return this.name;
    }

    public EntryClass getSuperclass() {
        return this.superclass;
    }

    public int getNumFields() {
        return this.numFields;
    }

    public long getFieldsHash() {
        return this.hash;
    }

    public void setFieldsHash(long l) {
        this.hash = l;
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public void setNumInstances(int n) {
        this.numInstances = n;
    }

    public int getNumTemplates() {
        return this.numTemplates;
    }

    public void setNumTemplates(int n) {
        this.numTemplates = n;
    }

    public EntryClass getReplacement() {
        return this.replacement;
    }

    public boolean isAssignableFrom(EntryClass entryClass) {
        EntryClass entryClass2 = entryClass;
        while (entryClass2 != null) {
            if (this == entryClass2) {
                return true;
            }
            entryClass2 = entryClass2.superclass;
        }
        return false;
    }

    public Class toClass(String string) throws IOException, ClassNotFoundException {
        return ClassLoading.loadClass((String)string, (String)this.name, null, (boolean)this.integrity, null);
    }

    public void canonical(EntryClass entryClass) {
        this.superclass = entryClass;
        this.replacement = new EntryClass(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.integrity = MarshalledWrapper.integrityEnforced(objectInputStream);
    }
}

