/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.Item;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.Template;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class ClassResolver {
    private boolean inRecovery = false;
    private final Map serviceMap = new HashMap();
    private final ReferenceQueue serviceRefQueue = new ReferenceQueue();
    private final Map entryMap = new HashMap();
    private final ReferenceQueue entryRefQueue = new ReferenceQueue();

    public void setInRecovery(boolean bl) {
        this.inRecovery = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceType resolve(ServiceType serviceType) {
        if (serviceType == null) {
            return null;
        }
        Map map = this.serviceMap;
        synchronized (map) {
            ServiceType serviceType2;
            WeakRep weakRep;
            while ((weakRep = (WeakRep)this.serviceRefQueue.poll()) != null) {
                this.serviceMap.remove(weakRep.name);
            }
            weakRep = (WeakRep)this.serviceMap.get(serviceType.getName());
            if (weakRep != null && (serviceType2 = (ServiceType)weakRep.get()) != null) {
                return serviceType2;
            }
            this.resolve(serviceType.getInterfaces());
            serviceType.canonical(this.resolve(serviceType.getSuperclass()));
            this.serviceMap.put(serviceType.getName(), new WeakRep(serviceType.getName(), serviceType, this.serviceRefQueue));
            return serviceType;
        }
    }

    public void resolve(ServiceType[] serviceTypeArray) {
        if (serviceTypeArray != null) {
            int n = serviceTypeArray.length;
            while (--n >= 0) {
                serviceTypeArray[n] = this.resolve(serviceTypeArray[n]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryClass resolve(EntryClass entryClass) {
        if (entryClass == null) {
            return null;
        }
        Map map = this.entryMap;
        synchronized (map) {
            EntryClass entryClass2;
            WeakRep weakRep;
            while ((weakRep = (WeakRep)this.entryRefQueue.poll()) != null) {
                this.entryMap.remove(weakRep.name);
            }
            weakRep = (WeakRep)this.entryMap.get(entryClass.getName());
            if (weakRep != null && (entryClass2 = (EntryClass)weakRep.get()) != null) {
                if (entryClass2.getNumFields() == entryClass.getNumFields() && (entryClass2.getFieldsHash() == entryClass.getFieldsHash() || entryClass2.getFieldsHash() == 0L || entryClass.getFieldsHash() == 0L)) {
                    if (entryClass2.getFieldsHash() == 0L) {
                        entryClass2.setFieldsHash(entryClass.getFieldsHash());
                    }
                    return entryClass2;
                }
                if (this.anyInUse(entryClass2)) {
                    throw new IncompatibleClassChangeError(entryClass.getName() + ": different public fields");
                }
            }
            entryClass.canonical(this.resolve(entryClass.getSuperclass()));
            this.entryMap.put(entryClass.getName(), new WeakRep(entryClass.getName(), entryClass, this.entryRefQueue));
            return entryClass;
        }
    }

    private boolean anyInUse(EntryClass entryClass) {
        if (!(this.inRecovery || entryClass.getNumInstances() <= 0 && entryClass.getNumTemplates() <= 0)) {
            return true;
        }
        ArrayList<String> arrayList = null;
        Iterator iterator = this.entryMap.values().iterator();
        while (iterator.hasNext()) {
            EntryClass entryClass2;
            WeakRep weakRep = (WeakRep)iterator.next();
            if (weakRep == null || (entryClass2 = (EntryClass)weakRep.get()) == null || !entryClass.isAssignableFrom(entryClass2)) continue;
            if (!(this.inRecovery || entryClass2.getNumInstances() <= 0 && entryClass2.getNumTemplates() <= 0)) {
                return true;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>(1);
            }
            arrayList.add(entryClass2.getName());
        }
        if (arrayList != null) {
            this.entryMap.keySet().removeAll(arrayList);
        }
        return false;
    }

    public void resolve(Item item) {
        item.serviceType = this.resolve(item.serviceType);
        this.resolve(item.attributeSets);
    }

    public void resolve(Template template) {
        this.resolve(template.serviceTypes);
        this.resolve(template.attributeSetTemplates);
    }

    public void resolve(EntryRep[] entryRepArray) {
        if (entryRepArray != null) {
            int n = entryRepArray.length;
            while (--n >= 0) {
                entryRepArray[n].eclass = this.resolve(entryRepArray[n].eclass);
            }
        }
    }

    public void resolveWithNulls(EntryRep[] entryRepArray) {
        if (entryRepArray != null) {
            int n = entryRepArray.length;
            while (--n >= 0) {
                if (entryRepArray[n] == null) continue;
                entryRepArray[n].eclass = this.resolve(entryRepArray[n].eclass);
            }
        }
    }

    private static class WeakRep
    extends WeakReference {
        public String name;

        public WeakRep(String string, Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.name = string;
        }
    }
}

