/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.pumps;

import foxtrot.EventPump;
import foxtrot.Task;
import foxtrot.pumps.EventFilter;
import foxtrot.pumps.EventFilterable;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public class ConditionalEventPump
implements EventPump,
EventFilterable {
    private static Class conditionalClass;
    private static Method pumpEventsMethod;
    static final boolean debug = false;
    private EventFilter filter;
    static /* synthetic */ Class class$foxtrot$pumps$ConditionalEventPump$ThrowableHandler;
    static /* synthetic */ Class class$java$lang$Object;

    public void setEventFilter(EventFilter filter) {
        this.filter = filter;
    }

    public EventFilter getEventFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pumpEvents(Task task) {
        if (task == null) {
            return;
        }
        try {
            Object conditional = Proxy.newProxyInstance(conditionalClass.getClassLoader(), new Class[]{conditionalClass}, (InvocationHandler)new Conditional(task));
            pumpEventsMethod.invoke((Object)Thread.currentThread(), conditional);
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            System.err.println("[ConditionalEventPump] Exception occurred during event dispatching:");
            t.printStackTrace();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw (Error)t;
        }
        catch (Throwable x) {
            System.err.println("[ConditionalEventPump] PANIC: uncaught exception in Foxtrot code");
            x.printStackTrace();
        }
        finally {
            this.waitForTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTask(Task task) {
        try {
            Task task2 = task;
            synchronized (task2) {
                while (!task.isCompleted()) {
                    task.wait();
                }
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    private Boolean pumpEvent(Task task) {
        AWTEvent nextEvent;
        Boolean completed;
        Boolean bl = completed = task.isCompleted() ? Boolean.TRUE : Boolean.FALSE;
        if (completed.booleanValue()) {
            return Boolean.FALSE;
        }
        do {
            if ((nextEvent = this.waitForEvent()) == null) {
                return Boolean.FALSE;
            }
            if (!this.canPumpEvent(nextEvent)) {
                return Boolean.FALSE;
            }
            if (this.filter != null && !this.filter.accept(nextEvent)) continue;
            return Boolean.TRUE;
        } while ((nextEvent = this.getNextEvent()) != null);
        return Boolean.FALSE;
    }

    protected boolean canPumpEvent(AWTEvent event) {
        return true;
    }

    protected EventQueue getEventQueue() {
        return (EventQueue)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Toolkit.getDefaultToolkit().getSystemEventQueue();
            }
        });
    }

    private AWTEvent getNextEvent() {
        try {
            return this.getEventQueue().getNextEvent();
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AWTEvent waitForEvent() {
        EventQueue queue = this.getEventQueue();
        AWTEvent nextEvent = null;
        EventQueue eventQueue = queue;
        synchronized (eventQueue) {
            while ((nextEvent = this.peekEvent(queue)) == null) {
                try {
                    queue.wait();
                }
                catch (InterruptedException x) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        }
        return nextEvent;
    }

    protected AWTEvent peekEvent(EventQueue queue) {
        return queue.peekEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException, NoSuchMethodException {
                    ClassLoader loader = ClassLoader.getSystemClassLoader();
                    conditionalClass = loader.loadClass("java.awt.Conditional");
                    Class<?> dispatchThreadClass = loader.loadClass("java.awt.EventDispatchThread");
                    pumpEventsMethod = dispatchThreadClass.getDeclaredMethod("pumpEvents", conditionalClass);
                    pumpEventsMethod.setAccessible(true);
                    String property = "sun.awt.exception.handler";
                    String handler = System.getProperty(property);
                    if (handler == null) {
                        handler = (class$foxtrot$pumps$ConditionalEventPump$ThrowableHandler == null ? (class$foxtrot$pumps$ConditionalEventPump$ThrowableHandler = ConditionalEventPump.class$("foxtrot.pumps.ConditionalEventPump$ThrowableHandler")) : class$foxtrot$pumps$ConditionalEventPump$ThrowableHandler).getName();
                        System.setProperty(property, handler);
                    }
                    return null;
                }
            });
        }
        catch (Throwable x) {
            throw new Error(x.toString());
        }
    }

    public static class ThrowableHandler {
        public void handle(Throwable t) {
            System.err.println("[ConditionalEventPump] Exception occurred during event dispatching:");
            t.printStackTrace();
        }
    }

    private class Conditional
    implements InvocationHandler {
        private final Task task;

        private Conditional(Task task) {
            this.task = task;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() != (class$java$lang$Object == null ? (class$java$lang$Object = ConditionalEventPump.class$("java.lang.Object")) : class$java$lang$Object)) {
                return ConditionalEventPump.this.pumpEvent(this.task);
            }
            return method.invoke((Object)this, args);
        }
    }
}

