/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.color.NamedProfileCache;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SVGColorProfileElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    public NamedProfileCache cache = new NamedProfileCache();

    @Override
    public String getLocalName() {
        return "color-profile";
    }

    public ICCColorSpaceExt createICCColorSpaceExt(BridgeContext bridgeContext, Element element, String string) {
        Object object;
        String string2;
        Object object2;
        ICCColorSpaceExt iCCColorSpaceExt = this.cache.request(string.toLowerCase());
        if (iCCColorSpaceExt != null) {
            return iCCColorSpaceExt;
        }
        Document document = element.getOwnerDocument();
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "color-profile");
        int n = nodeList.getLength();
        Object object3 = null;
        for (int i = 0; i < n; ++i) {
            object2 = nodeList.item(i);
            if (object2.getNodeType() != 1 || !string.equalsIgnoreCase(string2 = (object = (Element)object2).getAttributeNS(null, "name"))) continue;
            object3 = object;
        }
        if (object3 == null) {
            return null;
        }
        String string3 = XLinkSupport.getXLinkHref(object3);
        object2 = null;
        if (string3 != null) {
            ParsedURL parsedURL;
            object = ((AbstractNode)object3).getBaseURI();
            string2 = null;
            if (object != null) {
                string2 = new ParsedURL((String)object);
            }
            if (!(parsedURL = new ParsedURL((ParsedURL)string2, string3)).complete()) {
                throw new BridgeException(bridgeContext, element, "uri.malformed", new Object[]{string3});
            }
            try {
                bridgeContext.getUserAgent().checkLoadExternalResource(parsedURL, (ParsedURL)string2);
                object2 = ICC_Profile.getInstance(parsedURL.openStream());
            }
            catch (IOException iOException) {
                throw new BridgeException(bridgeContext, element, iOException, "uri.io", new Object[]{string3});
            }
            catch (SecurityException securityException) {
                throw new BridgeException(bridgeContext, element, securityException, "uri.unsecure", new Object[]{string3});
            }
        }
        if (object2 == null) {
            return null;
        }
        int n2 = SVGColorProfileElementBridge.convertIntent(object3, bridgeContext);
        iCCColorSpaceExt = new ICCColorSpaceExt((ICC_Profile)object2, n2);
        this.cache.put(string.toLowerCase(), iCCColorSpaceExt);
        return iCCColorSpaceExt;
    }

    private static int convertIntent(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "rendering-intent");
        if (string.length() == 0) {
            return 4;
        }
        if ("perceptual".equals(string)) {
            return 0;
        }
        if ("auto".equals(string)) {
            return 4;
        }
        if ("relative-colorimetric".equals(string)) {
            return 1;
        }
        if ("absolute-colorimetric".equals(string)) {
            return 2;
        }
        if ("saturation".equals(string)) {
            return 3;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"rendering-intent", string});
    }
}

