/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.osgi;

import com.mathworks.util.Log;
import com.mathworks.util.osgi.BundleProvider;
import com.mathworks.util.osgi.BundleStarter;
import com.mathworks.util.osgi.FinalBundleActivator;
import com.mathworks.util.osgi.HostActivator;
import com.mathworks.util.osgi.OSGiUtils;
import java.io.File;
import java.io.IOException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.StringMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public final class OSGiManager {
    private static final int BUNDLE_INITIAL_START_LEVEL = Integer.MAX_VALUE;
    public static final String FINAL_BUNDLE_NAME = "com.mathworks.util.final-bundle";
    private final Felix fFelix;
    private final List<BundleProvider> fBundleProviders;
    private final BundleStarter fBundleStarter;
    private HostActivator fHostActivator;
    private Collection<Bundle> fBundles;
    private boolean fStartedBundles;
    private File fCacheDir;
    private Exception fStopException;

    public OSGiManager(String string, BundleStarter bundleStarter, BundleProvider ... bundleProviderArray) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("'cacheDirName' cannot be null or empty");
        }
        if (bundleProviderArray == null || bundleProviderArray.length == 0) {
            throw new IllegalArgumentException("'bundleProvider' cannot be null or empty");
        }
        if (bundleStarter == null) {
            throw new IllegalArgumentException("'bundleStarter' cannot be null");
        }
        this.fHostActivator = new HostActivator();
        StringMap stringMap = OSGiManager.createDefaultConfiguration(this.fHostActivator);
        this.setupCache(string, stringMap);
        this.fBundleProviders = Arrays.asList(bundleProviderArray);
        this.fBundleStarter = bundleStarter;
        this.fFelix = new Felix((Map)stringMap);
    }

    public Collection<Bundle> getInstalledBundles() {
        return Collections.unmodifiableCollection(this.getBundles());
    }

    public synchronized void start() {
        if (!this.fStartedBundles) {
            this.fBundleStarter.startBundles((Bundle)this.fFelix, this.getBundles());
            this.fStartedBundles = true;
        }
    }

    public synchronized void stop() {
        try {
            if (this.fFelix.getState() != 1) {
                OSGiUtils.log("Stopping OSGi.");
                this.fFelix.stop();
                this.fFelix.waitForStop(0L);
                this.removeCacheDirectory();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.fStopException = exception;
        }
    }

    private Exception getStopException() {
        return this.fStopException;
    }

    public BundleContext getBundleContext() {
        return this.fFelix.getBundleContext();
    }

    public <T> Collection<T> getImplementors(Class<T> clazz) {
        OSGiUtils.log("getImplementors(" + clazz + ")");
        this.start();
        this.waitForFinalBundle();
        ServiceTracker serviceTracker = new ServiceTracker(this.fHostActivator.getContext(), clazz.getName(), null);
        serviceTracker.open();
        Object[] objectArray = serviceTracker.getServices();
        serviceTracker.close();
        return objectArray == null ? Collections.emptyList() : Arrays.asList(objectArray);
    }

    public Bundle findBundle(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("'symbolicName' cannot be null or empty");
        }
        if (this.fFelix.getBundleContext() == null) {
            throw new IllegalStateException("Felix has not been started");
        }
        for (Bundle bundle : this.fFelix.getBundleContext().getBundles()) {
            if (!bundle.getSymbolicName().equals(string)) continue;
            return bundle;
        }
        return null;
    }

    public File getCacheDirectory() {
        return this.fCacheDir;
    }

    private synchronized Collection<Bundle> getBundles() {
        if (this.fBundles == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        OSGiUtils.log("Starting OSGi on daemon thread...");
                        OSGiManager.this.fFelix.start();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            Thread thread = new Thread(runnable, "OSGi Starter");
            thread.setDaemon(true);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                Log.logException(interruptedException);
            }
            HashSet<File> hashSet = new HashSet<File>();
            for (BundleProvider bundleProvider : this.fBundleProviders) {
                hashSet.addAll(bundleProvider.getBundleJarFiles((Bundle)this.fFelix));
            }
            OSGiUtils.log("About to install: " + hashSet);
            this.fBundles = this.installBundles(hashSet);
        }
        return this.fBundles;
    }

    private List<Bundle> installBundles(Collection<File> collection) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        for (File file : collection) {
            try {
                Bundle bundle = this.fFelix.getBundleContext().installBundle(OSGiUtils.toReferenceUrl(file));
                OSGiUtils.log("Installed " + bundle);
                arrayList.add(bundle);
            }
            catch (Exception exception) {
                Log.logException(exception);
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    private void waitForFinalBundle() {
        OSGiUtils.log("waitForFinalBundle");
        if (this.findBundle(FINAL_BUNDLE_NAME) == null) {
            assert (false) : "OSGi error: The util.jar bundle was not installed";
            return;
        }
        ServiceTracker serviceTracker = new ServiceTracker(this.fHostActivator.getContext(), FinalBundleActivator.FinalInterface.class.getName(), null);
        serviceTracker.open();
        try {
            serviceTracker.waitForService(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        serviceTracker.close();
        OSGiUtils.log("Done with waitForFinalBundle");
    }

    private static StringMap createDefaultConfiguration(BundleActivator bundleActivator) {
        StringMap stringMap = new StringMap(false);
        stringMap.put((Object)"org.osgi.framework.system.packages", (Object)"org.osgi.framework; version=1.3.0,org.osgi.service.packageadmin; version=1.2.0,org.osgi.service.startlevel; version=1.0.0,org.osgi.service.url; version=1.0.0,org.osgi.util.tracker; version=1.3.2");
        stringMap.put((Object)"org.osgi.framework.bootdelegation", (Object)"*");
        stringMap.put((Object)"felix.service.urlhandlers", (Object)"false");
        stringMap.put((Object)"felix.log.level", (Object)"1");
        stringMap.put((Object)"felix.startlevel.bundle", (Object)String.valueOf(Integer.MAX_VALUE));
        stringMap.put((Object)"felix.systembundle.activators", new ArrayList<BundleActivator>(Collections.singletonList(bundleActivator)));
        return stringMap;
    }

    private void setupCache(String string, StringMap stringMap) {
        this.setupNewCacheDirectory(string, stringMap);
        this.registerShutdownHook();
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                OSGiManager.this.stop();
            }
        }, "OSGiManager ShutdownHook"));
        try {
            Class.forName("com.mathworks.jmi.OSGiShutdownHook");
        }
        catch (ClassNotFoundException classNotFoundException) {
            OSGiUtils.log("OSGiShutdownHook not on classpath.");
        }
    }

    private void removeCacheDirectory() {
        try {
            OSGiUtils.log("Removing cache directory " + this.fCacheDir);
            FileUtils.deleteDirectory((File)this.fCacheDir);
        }
        catch (Exception exception) {
            OSGiUtils.log("Unable to remove cache directory " + this.fCacheDir + ": " + exception.getMessage());
        }
    }

    private void setupNewCacheDirectory(String string, StringMap stringMap) {
        block7: {
            String[] stringArray = new String[]{System.getenv("TMPDIR"), System.getenv("TMP"), System.getenv("TEMP"), SystemUtils.JAVA_IO_TMPDIR, System.getenv("HOME"), SystemUtils.USER_HOME};
            try {
                String string2;
                boolean bl = false;
                Object[] objectArray = stringArray;
                int n = objectArray.length;
                for (int i = 0; !(i >= n || (string2 = objectArray[i]) != null && (bl = this.tryMakingDirectory(string2, string))); ++i) {
                }
                if (!bl) {
                    objectArray = File.listRoots();
                    if (objectArray != null && objectArray.length > 0) {
                        bl = this.tryMakingDirectory(((File)objectArray[0]).getAbsolutePath(), string);
                    } else {
                        Log.log("OSGi: No file system roots available: " + Arrays.toString(objectArray));
                    }
                }
                if (!bl) {
                    throw new IOException("Failed to create " + this.fCacheDir);
                }
                OSGiUtils.log("Created cache directory " + this.fCacheDir);
                stringMap.put((Object)"org.osgi.framework.storage", (Object)this.fCacheDir.getAbsolutePath());
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)iOException);
            }
        }
    }

    private boolean tryMakingDirectory(String string, String string2) {
        boolean bl;
        File file = new File(string, ".felix");
        String string3 = new UID().toString().replace(':', '_');
        this.fCacheDir = new File(file, string2 + string3);
        if (this.fCacheDir.exists()) {
            OSGiUtils.log("Directory " + this.fCacheDir + " unexpectedly already exists");
            bl = true;
        } else {
            bl = this.fCacheDir.mkdirs();
            OSGiUtils.log("Trying to create cache directory " + this.fCacheDir + ": " + bl);
        }
        return bl;
    }
}

