/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util.event;

import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.event.EventListenerInvocationException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;

public class EventListenerList<L> {
    private transient Object[] fListeners = new Object[10];
    private int fSize;
    private final L fProxy;

    public static <L> EventListenerList<L> newEventListenerList(Class<? extends L> clazz) {
        return new EventListenerList<L>(clazz);
    }

    public EventListenerList(Class<? extends L> clazz) {
        this.fProxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                Object[] objectArray2;
                ArrayList<Throwable> arrayList = EventListenerList.this.fProxy;
                synchronized (arrayList) {
                    if (EventListenerList.this.fSize == 0) {
                        return null;
                    }
                    objectArray2 = new Object[EventListenerList.this.fSize];
                    System.arraycopy(EventListenerList.this.fListeners, 0, objectArray2, 0, EventListenerList.this.fSize);
                }
                method.setAccessible(true);
                arrayList = null;
                for (Object object2 : objectArray2) {
                    try {
                        if (object2 instanceof WeakReference) {
                            object2 = ((WeakReference)object2).get();
                        }
                        if (object2 == null) continue;
                        method.invoke(object2, objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<Throwable>();
                        }
                        arrayList.add(invocationTargetException.getTargetException());
                    }
                    catch (Exception exception) {
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.add(exception);
                    }
                }
                if (arrayList != null) {
                    throw new EventListenerInvocationException("Error firing event", arrayList.toArray(new Throwable[arrayList.size()]));
                }
                return null;
            }
        });
    }

    public boolean addListener(final L l, Disposable disposable) {
        boolean bl = this.addListenerInternal(l, false);
        if (bl) {
            Disposer.register(new Disposable(){

                @Override
                public void dispose() {
                    EventListenerList.this.removeListener(l);
                }
            }, disposable);
        }
        return bl;
    }

    public boolean addListener(L l) {
        return this.addListenerInternal(l, false);
    }

    public boolean addWeakListener(final L l, Disposable disposable) {
        boolean bl = this.addListenerInternal(l, true);
        if (bl) {
            Disposer.register(new Disposable(){

                @Override
                public void dispose() {
                    EventListenerList.this.removeListener(l);
                }
            }, disposable);
        }
        return bl;
    }

    public boolean addWeakListener(L l) {
        return this.addListenerInternal(l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addListenerInternal(L l, boolean bl) {
        L l2 = this.fProxy;
        synchronized (l2) {
            try {
                if (this.contains(l)) {
                    boolean bl2 = false;
                    return bl2;
                }
                this.ensureCapacity(this.fSize + 1);
                this.fListeners[this.fSize++] = bl ? new WeakReference<L>(l) : l;
                boolean bl3 = true;
                return bl3;
            }
            finally {
                this.removeCollectedWeak();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeListener(L l) {
        L l2 = this.fProxy;
        synchronized (l2) {
            try {
                int n = this.indexOf(l);
                if (n >= 0) {
                    this.remove(n);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.removeCollectedWeak();
            }
        }
    }

    private void remove(int n) {
        int n2 = this.fSize - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.fListeners, n + 1, this.fListeners, n, n2);
        }
        this.fListeners[--this.fSize] = null;
    }

    private void ensureCapacity(int n) {
        int n2 = this.fListeners.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.fListeners = Arrays.copyOf(this.fListeners, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        L l = this.fProxy;
        synchronized (l) {
            return this.fSize == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        L l = this.fProxy;
        synchronized (l) {
            for (int i = 0; i < this.fSize; ++i) {
                this.fListeners[i] = null;
            }
            this.fSize = 0;
        }
    }

    private void removeCollectedWeak() {
        int n = 0;
        for (int i = 0; i < this.fSize; ++i) {
            Object object = this.fListeners[i];
            if (object instanceof WeakReference) {
                if (((WeakReference)object).get() == null) {
                    this.fListeners[i] = null;
                    continue;
                }
                ++n;
                continue;
            }
            ++n;
        }
        if (n != this.fSize) {
            Object[] objectArray = new Object[n];
            int n2 = 0;
            for (int i = 0; i < this.fListeners.length; ++i) {
                Object object = this.fListeners[i];
                if (object == null) continue;
                objectArray[n2++] = object;
            }
            this.fListeners = objectArray;
            this.fSize = n;
        }
    }

    public L fire() {
        return this.fProxy;
    }

    private boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    private int indexOf(Object object) {
        for (int i = 0; i < this.fSize; ++i) {
            Object object2 = this.fListeners[i];
            if (object != object2 && (!(object2 instanceof WeakReference) || ((WeakReference)object2).get() != object)) continue;
            return i;
        }
        return -1;
    }
}

