/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.FileSystemUtils;
import com.mathworks.util.Log;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class FileUtils {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String ELLIPSIS = "...";
    private static String sPreferenceDirectory;
    public static final int DEFAULT_TRUNCATE_LENGTH = 32;
    public static final int TRUNCATE_KEEPING_PREFIX = 0;
    public static final int TRUNCATE_FRONT = 1;
    public static final int TRUNCATE_END = 2;
    public static final int TRUNCATE_ALL_EXCEPT_FILENAME = 3;
    public static final int TRUNCATE_KEEPING_PREFIX_AND_SUFFIX = 4;

    private FileUtils() {
    }

    public static File absoluteFile(File file) {
        return new File(FileUtils.absolutePathname(file.getAbsolutePath()));
    }

    @Deprecated
    public static String absolutePathname(String string) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("Filename passed in cannot be null");
        }
        File file = new File(string);
        if (PlatformInfo.isWindows()) {
            String string3;
            String string4 = NativeJava.toAbsolutePath(string);
            try {
                string3 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string3 = string4;
            }
            return string4.equalsIgnoreCase(string3) ? string3 : string4;
        }
        if (!file.isAbsolute() && (string2 = NativeJava.toAbsolutePath(string)) != null && string2.length() > 0) {
            return string2;
        }
        string2 = FilenameUtils.normalize((String)string);
        return string2 != null ? string2 : string;
    }

    public static String normalizePathname(String string) {
        if (!new File(string).isAbsolute()) {
            throw new IllegalArgumentException("Path passed in must be absolute: " + string);
        }
        return FileUtils.absolutePathname(string);
    }

    @Deprecated
    public static String toJavaPath(String string) {
        return FilenameUtils.separatorsToUnix((String)string);
    }

    @Deprecated
    public static String fromJavaPath(String string) {
        return FilenameUtils.separatorsToSystem((String)string);
    }

    public static String getLocalizedFilename(String string) {
        return FileUtils.getLocalizedFilename(string, Locale.getDefault());
    }

    public static String getLocalizedFilename(String string, String string2) {
        return FileUtils.getLocalizedFilename(string, string2, Locale.getDefault());
    }

    public static String getLocalizedFilename(String string, Locale locale) {
        Validate.notEmpty((String)string, (String)"'filename' cannot be null or empty");
        File file = new File(string);
        String string2 = file.getParent();
        String string3 = file.getName();
        return FileUtils.getLocalizedFilename(string2, string3, locale);
    }

    public static String getLocalizedFilename(String string, String string2, Locale locale) {
        Validate.notEmpty((String)string, (String)"'parentdirectory' cannot be null or empty");
        Validate.notEmpty((String)string2, (String)"'relativepath' cannot be null or empty");
        Validate.notNull((Object)locale, (String)"'locale' cannot be null");
        String string3 = FileUtils.tryLocalizedFilename(string, string2, locale.toString());
        if (string3 == null) {
            string3 = FileUtils.tryLocalizedFilename(string, string2, locale.getLanguage());
        }
        return string3 == null ? new File(new File(string), string2).getAbsolutePath() : string3;
    }

    private static String tryLocalizedFilename(String string, String string2, String string3) {
        File file = new File(new File(string, string3), string2);
        return file.exists() ? file.getPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getFileContents(String string) {
        String string2 = null;
        File file = new File(string);
        if (file.exists() && !file.isDirectory()) {
            FileInputStream fileInputStream = null;
            try {
                long l = file.length();
                byte[] byArray = new byte[(int)l];
                fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                string2 = new String(byArray);
                IOUtils.closeQuietly((InputStream)fileInputStream);
            }
            catch (Exception exception) {
                Log.logException(exception);
            }
            finally {
                IOUtils.closeQuietly(fileInputStream);
            }
        }
        return string2;
    }

    public static boolean fileExists(String string) {
        File file = new File(FileUtils.absolutePathname(string));
        return FileUtils.fileExists(file);
    }

    public static String getPreferencesDirectory() {
        return sPreferenceDirectory;
    }

    public static void setPreferencesDirectory(String string) {
        if (sPreferenceDirectory != null) {
            throw new IllegalStateException("Preferences Directory Location has already been set.");
        }
        sPreferenceDirectory = string;
    }

    public static boolean fileExists(File file) {
        return file.exists() && !file.isDirectory();
    }

    @Deprecated
    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
    }

    @Deprecated
    public static void copyFile(File file, File file2) throws IOException {
        org.apache.commons.io.FileUtils.copyFile((File)file, (File)file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void copyStreamToFile(InputStream inputStream, File file) throws IOException {
        FileUtils.createParentDirectory(file);
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file);
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
        }
    }

    private static void createParentDirectory(File file) throws IOException {
        org.apache.commons.io.FileUtils.forceMkdir((File)new File(FilenameUtils.getFullPath((String)file.getAbsolutePath())));
    }

    public static boolean isHtmlFile(String string) {
        return FileUtils.isFileExtension(string, "html", "htm");
    }

    public static boolean isCFile(String string) {
        return IOCase.SYSTEM.checkEndsWith(string, ".c");
    }

    public static boolean isPdfFile(String string) {
        return FileUtils.isFileExtension(string, "pdf");
    }

    private static boolean isFileExtension(String string, String ... stringArray) {
        return FilenameUtils.isExtension((String)string.toLowerCase(), (String[])stringArray);
    }

    public static String[] listFolderContents(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        List<String> list = FileUtils.listFolderContentsToVector(string, null, bl, bl2, bl3);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (bl4) {
                string2 = string + File.separator + string2;
            }
            stringArray[i] = string2;
        }
        return stringArray;
    }

    private static List<String> listFolderContentsToVector(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        File file = string2 != null ? new File(string, string2) : new File(string);
        String[] stringArray2 = stringArray = file.list();
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string3;
            File file2 = string2 != null ? new File(string, string2) : new File(string);
            File file3 = new File(file2, string3 = stringArray2[i]);
            boolean bl4 = file3.isDirectory();
            if (!bl4 && bl || bl4 && bl2) {
                if (string2 == null) {
                    vector.add(string3);
                } else {
                    vector.add(string2 + File.separator + string3);
                }
            }
            if (!bl4 || !bl3) continue;
            String string4 = string2 == null ? string3 : string2 + File.separator + string3;
            List<String> list = FileUtils.listFolderContentsToVector(string, string4, bl, bl2, true);
            for (String string5 : list) {
                vector.add(string5);
            }
        }
        return vector;
    }

    public static String truncatePathname(String string) {
        return FileUtils.truncatePathname(string, 32);
    }

    public static String truncatePathname(String string, int n) {
        return FileUtils.truncatePathname(string, n, 0);
    }

    public static String truncatePathname(String string, int n, int n2) {
        String string2;
        if (n < 4) {
            n = 4;
        }
        if (n2 != 3 && (string == null || string.length() == 0 || string.length() <= n)) {
            return string;
        }
        switch (n2) {
            case 1: {
                string2 = FileUtils.truncateFront(string, n);
                break;
            }
            case 2: {
                string2 = string.substring(0, n - ELLIPSIS.length()) + ELLIPSIS;
                break;
            }
            case 3: {
                int n3 = FileUtils.fileLength(string) + FILE_SEPARATOR.length();
                string2 = ELLIPSIS + string.substring(string.length() - n3);
                break;
            }
            case 4: {
                string2 = FileUtils.truncateWithPrefixandFilename(string, n);
                break;
            }
            default: {
                string2 = FileUtils.truncateWithPrefix(string, n);
            }
        }
        return string2;
    }

    private static String truncateFront(String string, int n) {
        int n2 = string.length() - (n - ELLIPSIS.length());
        return ELLIPSIS + string.substring(n2);
    }

    private static String truncateWithPrefix(String string, int n) {
        String string2 = FileUtils.truncateWithPrefixandFilename(string, n);
        if (string2.length() <= n) {
            return string2;
        }
        return FileUtils.truncateFront(string, n);
    }

    private static String truncateWithPrefixandFilename(String string, int n) {
        int n2 = FileUtils.prefixLength(string);
        int n3 = Math.max(n, n2 + ELLIPSIS.length() + FILE_SEPARATOR.length() + FileUtils.fileLength(string));
        if (string.length() <= n3) {
            return string;
        }
        return string.substring(0, n2) + ELLIPSIS + string.substring(string.length() - n3 + n2 + ELLIPSIS.length());
    }

    private static int fileLength(String string) {
        int n = string.length();
        int n2 = string.lastIndexOf(FILE_SEPARATOR);
        if (n2 != -1) {
            n -= n2 + 1;
        }
        return n;
    }

    private static int prefixLength(String string) {
        int n;
        if (PlatformInfo.isWindows()) {
            n = 3;
            if (string.startsWith("\\\\")) {
                int n2 = Math.max(2, string.indexOf(FILE_SEPARATOR, 2) + 2);
                n = n2 + 1;
                if (string.length() > n) {
                    n = string.indexOf(FILE_SEPARATOR, n) + 1;
                }
            }
        } else {
            n = Math.max(0, string.indexOf(FILE_SEPARATOR, 1) + 1);
        }
        return n;
    }

    public static boolean isANativeMacPackage(File file) {
        return PlatformInfo.isMacintosh() && NativeJava.isPackage(file.getAbsolutePath());
    }

    public static File getNextUntitledFile(File file, String string, FileFilter ... fileFilterArray) {
        assert (string != null) : "An extension is required";
        String string2 = !string.contains(".") ? "." + string : string;
        return FileUtils.getNextNamedFile(file, "Untitled", string2, fileFilterArray);
    }

    public static File getNextNamedFile(File file, String string, String string2, FileFilter ... fileFilterArray) {
        return FileUtils.getNextNamedFile(file, string, string2, true, "", fileFilterArray);
    }

    public static File getNextNamedFile(File file, String string, String string2, boolean bl, String string3, final FileFilter ... fileFilterArray) {
        File file2;
        assert (file != null) : "A folder is required";
        assert (string != null) : "A prefix is required";
        assert (string2 != null) : "A suffix is required; use an empty string if it does not matter";
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.exists()) {
                    return false;
                }
                for (FileFilter fileFilter : fileFilterArray) {
                    if (fileFilter.accept(file)) continue;
                    return false;
                }
                return true;
            }
        };
        int n = 1;
        do {
            if (n == 0) {
                throw new IllegalArgumentException("all possible file numbers were exhausted without a match");
            }
            String string4 = !bl && n == 1 ? string3 : string3 + n + string3;
            file2 = new File(file, string + string4 + string2);
            ++n;
        } while (!fileFilter.accept(file2));
        return file2;
    }

    public static int compareCanonicalPaths(File file, File file2) {
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        try {
            string = file.getCanonicalFile().getAbsolutePath();
            string2 = file2.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string.compareTo(string2);
    }

    public static boolean matchesDirStylePattern(File file, String string) {
        if (string.equals("*.*")) {
            return true;
        }
        Pattern pattern = Pattern.compile(FileUtils.parseToRegex(string), 2);
        Matcher matcher = pattern.matcher(file.getName());
        return matcher.matches();
    }

    private static String parseToRegex(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '?') {
                stringBuilder.append(".");
            } else if (c == '*') {
                stringBuilder.append(".*");
            } else if (c == '+' || c == '.' || c == '[' || c == '^' || c == '$' || c == '(' || c == ')' || c == '{' || c == '|' || c == '/') {
                stringBuilder.append("\\").append(c);
            } else {
                stringBuilder.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    public static boolean areFilesTheSame(File file, File file2) {
        boolean bl = file == file2 ? true : (file == null || file2 == null ? false : (PlatformInfo.isWindows() ? FileUtils.absoluteFile(file).getAbsolutePath().equalsIgnoreCase(FileUtils.absoluteFile(file2).getAbsolutePath()) : FileUtils.absoluteFile(file).getAbsolutePath().equals(FileUtils.absoluteFile(file2).getAbsolutePath())));
        return bl;
    }

    public static String generateFileHash(File file) throws IOException {
        String string;
        if (file == null) {
            throw new IllegalArgumentException("The given file cannot be null.");
        }
        FileInputStream fileInputStream = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            while (fileInputStream.available() > 0) {
                int n = fileInputStream.read(byArray);
                messageDigest.update(byArray, 0, n);
            }
            string = new String(messageDigest.digest(), "ISO-8859-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                throw new RuntimeException(noSuchAlgorithmException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return string;
    }

    public static boolean makeFileWriteable(File file) {
        if (file == null) {
            throw new IllegalArgumentException("The given file cannot be null.");
        }
        NativeJava.changeFileAttribute(file.getPath(), "w");
        return file.canWrite();
    }

    public static void makeFileWriteableStrict(File file) throws Exception {
        if (!FileUtils.makeFileWriteable(file)) {
            throw new Exception("Couldn't make file writeable.");
        }
    }

    public static File getParent(File file) {
        File file2 = file;
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Document document, File file, Charset charset) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        RandomAccessFile randomAccessFile = null;
        try {
            boolean bl = file.exists();
            randomAccessFile = new RandomAccessFile(file, "rw");
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(randomAccessFile.getFD()), charset);
            randomAccessFile.setLength(0L);
            FileUtils.writeDocumentContents(document, outputStreamWriter);
            randomAccessFile.getFD().sync();
            FileUtils.notifyFileSystemOfFileChange(file, bl);
            IOUtils.closeQuietly((Writer)outputStreamWriter);
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException(badLocationException);
        }
        finally {
            IOUtils.closeQuietly(outputStreamWriter);
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    public static void writeDocumentContents(Document document, Writer writer) throws IOException, BadLocationException {
        DefaultEditorKit defaultEditorKit = new DefaultEditorKit();
        ((EditorKit)defaultEditorKit).write(writer, document, 0, document.getLength());
    }

    public static void notifyFileSystemOfFileChange(File file, boolean bl) {
        if (bl) {
            FileSystemUtils.getFileSystemNotifier().changed(file);
        } else {
            FileSystemUtils.getFileSystemNotifier().created(file);
        }
    }

    public static boolean hasSameParent(File file, File file2) {
        return file.getParentFile() == null && file2.getParentFile() == null || file.getParentFile() != null && file2.getParentFile() != null && file.getParentFile().equals(file2.getParentFile());
    }

    public static boolean isMatchingExtension(String string, Collection<String> collection) {
        for (String string2 : collection) {
            if (!IOCase.SYSTEM.checkEquals(string, string2)) continue;
            return true;
        }
        return false;
    }

    public static File createUniqueTempDir(boolean bl) throws IOException {
        return FileUtils.createUniqueTempDir("tempdir", bl);
    }

    public static File createUniqueTempDir(String string, boolean bl) throws IOException {
        File file = File.createTempFile(string, "");
        boolean bl2 = file.delete();
        if (!bl2) {
            throw new IOException("Failed to delete " + bl2);
        }
        if (bl) {
            boolean bl3 = file.mkdir();
            file.deleteOnExit();
            if (!bl3) {
                throw new IOException("Failed to create " + file);
            }
        }
        return new File(file.getCanonicalPath());
    }

    public static String getRelativePathFromDirectory(File file, File file2) {
        Validate.notNull((Object)file, (String)"Supplied directory cannot be null.");
        Validate.notNull((Object)file2, (String)"Supplied file cannot be null.");
        for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            if (!FileUtils.areFilesTheSame(file, file3)) continue;
            return file2.getAbsolutePath().substring(file3.getAbsolutePath().length() + File.separator.length());
        }
        return null;
    }

    public static String resolveRelativePath(String string, String string2) {
        if (string2.length() == 0 || ".".equals(string2)) {
            return string.length() == 0 || string.lastIndexOf(FILE_SEPARATOR) != string.length() - FILE_SEPARATOR.length() ? string + FILE_SEPARATOR : string;
        }
        String string3 = ".." + FILE_SEPARATOR;
        String string4 = "../";
        while (string2.length() > 0 && (string2.startsWith(string3) || string2.startsWith(string4))) {
            string2 = string2.substring(string3.length());
            int n = string.lastIndexOf(FILE_SEPARATOR);
            if (n < 0) continue;
            string = string.substring(0, n);
        }
        return string + FILE_SEPARATOR + string2;
    }
}

