/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.google.common.base.Preconditions;
import com.mathworks.util.Disposable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Disposer {
    private static final Disposable ROOT = new Disposable(){

        @Override
        public void dispose() {
        }
    };
    private static final Map<Disposable, Node> sObject2Node = new IdentityHashMap<Disposable, Node>();
    private static final Node sRoot = new Node(ROOT, null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(@NotNull Disposable disposable, @NotNull Disposable disposable2) {
        Preconditions.checkArgument((disposable != disposable2 ? 1 : 0) != 0, (String)"Child and parent have to be different objects: '%s'", (Object[])new Object[]{disposable});
        Node node = sRoot;
        synchronized (node) {
            Preconditions.checkArgument((!Disposer.isDescendantOf(disposable, disposable2) ? 1 : 0) != 0, (String)"Cannot register cyclic dependencies, parent '%s', child '%s'", (Object[])new Object[]{disposable2, disposable});
            Preconditions.checkArgument((!Disposer.isDescendantOf(disposable2, disposable) ? 1 : 0) != 0, (String)"Object '%s' is already registered as descendant of '%s'", (Object[])new Object[]{disposable, disposable2});
            Preconditions.checkArgument((sObject2Node.get(disposable) == null ? 1 : 0) != 0, (String)"Child '%s' is already registered under another root", (Object[])new Object[]{disposable});
            Node node2 = sObject2Node.get(disposable2);
            if (node2 == null) {
                node2 = new Node(disposable2, sRoot);
            }
            node2.fChildren.add(new Node(disposable, node2));
        }
    }

    public static void dispose(@Nullable Disposable disposable) {
        Disposer._dispose(disposable);
    }

    public static void dispose(@NotNull Iterable<? extends Disposable> iterable) {
        for (Disposable disposable : iterable) {
            Disposer._dispose(disposable);
        }
    }

    public static void dispose(@NotNull Disposable[] disposableArray) {
        Disposer.dispose(Arrays.asList(disposableArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _dispose(Disposable disposable) {
        Node node;
        if (disposable == null) {
            return;
        }
        Node node2 = sRoot;
        synchronized (node2) {
            node = sObject2Node.remove(disposable);
            if (node != null) {
                node.fParent.fChildren.remove(node);
                Disposer.removeFromMap(node);
            }
        }
        if (node != null) {
            Disposer._dispose(node);
        } else {
            disposable.dispose();
        }
    }

    private static void _dispose(Node node) {
        final List<Node> list = node.fChildren;
        Disposable disposable = node.fDisposable;
        if (disposable instanceof Disposable.Parent) {
            ((Disposable.Parent)disposable).beforeChildrenDisposed(new Iterable<Disposable>(){

                @Override
                public Iterator<Disposable> iterator() {
                    return new Iterator<Disposable>(){
                        Iterator<Node> it;
                        {
                            this.it = list.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public Disposable next() {
                            return this.it.next().fDisposable;
                        }

                        @Override
                        public void remove() {
                            this.it.remove();
                        }
                    };
                }
            });
        }
        int n = list.size();
        while (--n >= 0) {
            Disposer._dispose(list.get(n));
        }
        disposable.dispose();
    }

    private static void removeFromMap(Node node) {
        for (Node node2 : node.fChildren) {
            sObject2Node.remove(node2.fDisposable);
            Disposer.removeFromMap(node2);
        }
    }

    private static boolean isDescendantOf(Disposable disposable, Disposable disposable2) {
        Node node = sObject2Node.get(disposable);
        return node != null && Disposer._isDescendantOf(node, disposable2);
    }

    private static boolean _isDescendantOf(Node node, Disposable disposable) {
        for (Node node2 : node.fChildren) {
            if (node2.fDisposable != disposable && !Disposer._isDescendantOf(node2, disposable)) continue;
            return true;
        }
        return false;
    }

    private static class Node {
        final Disposable fDisposable;
        final Node fParent;
        final List<Node> fChildren = new ArrayList<Node>();

        private Node(Disposable disposable, Node node) {
            this.fDisposable = disposable;
            this.fParent = node;
            sObject2Node.put(disposable, this);
        }
    }
}

