/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.Converter;
import com.mathworks.util.MRUList;
import com.mathworks.util.ParameterRunnable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;

public class Cache<K, V> {
    private final Map<K, Entry> fData;
    private final Loader<K, V> fLoader;
    private final MRUList<Entry> fRecentlyUsed;
    private final int fElementLimit;
    private final Object fChangeLock;

    private Cache() {
        this.fLoader = null;
        this.fRecentlyUsed = null;
        this.fElementLimit = Integer.MAX_VALUE;
        this.fChangeLock = null;
        this.fData = null;
    }

    public static <X, K, V> Cache<K, V> createIndirect(final Loader<K, V> loader, final Converter<K, X> converter, final int n) {
        return new Cache<K, V>(){
            private Cache<X, V> fRealCache;
            {
                this.fRealCache = new Cache(null, n);
            }

            @Override
            public V get(final K k) throws IOException {
                return this.fRealCache.get(converter.convert(k), new Loader<X, V>(){

                    @Override
                    public V load(X x) throws IOException {
                        return loader.load(k);
                    }
                });
            }

            @Override
            public void flush() {
                this.fRealCache.flush();
            }

            @Override
            public void flush(K k) {
                this.fRealCache.flush(converter.convert(k));
            }

            @Override
            public boolean isPresent(K k) {
                return this.fRealCache.isPresent(converter.convert(k));
            }

            @Override
            protected Entry getIfPresent(K k) {
                Entry entry = this.fRealCache.getIfPresent(converter.convert(k));
                if (entry == null) {
                    return null;
                }
                return new Entry(k, entry.getValue());
            }

            @Override
            public int getElementLimit() {
                return n;
            }
        };
    }

    public Cache(Loader<K, V> loader, int n) {
        this.fLoader = loader;
        this.fElementLimit = n;
        this.fChangeLock = new Object();
        this.fData = new HashMap<K, Entry>();
        this.fRecentlyUsed = new MRUList(n);
    }

    public static <V> Cache<File, V> createFileCache(final FileCacheStyle fileCacheStyle, Loader<File, V> loader, int n) {
        return new Cache<File, V>(loader, n){

            @Override
            public void flush(File file) {
                if (fileCacheStyle == FileCacheStyle.FLUSH_PARENTS_RECURSIVELY) {
                    for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
                        super.flush(file2);
                    }
                } else if (fileCacheStyle == FileCacheStyle.EXPLICIT_FLUSH) {
                    super.flush(file);
                } else {
                    throw new IllegalArgumentException("createFileCache doesn't handle " + (Object)((Object)fileCacheStyle));
                }
            }

            @Override
            public void reloadIfPresent(File file) throws IOException {
                if (fileCacheStyle == FileCacheStyle.FLUSH_PARENTS_RECURSIVELY) {
                    for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
                        super.reloadIfPresent(file2);
                    }
                } else if (fileCacheStyle == FileCacheStyle.EXPLICIT_FLUSH) {
                    super.reloadIfPresent(file);
                } else {
                    throw new IllegalArgumentException("reloadIfPresent doesn't handle " + (Object)((Object)fileCacheStyle));
                }
            }
        };
    }

    public static <K, V> Cache<K, V> makeAsynchronous(final Cache<K, V> cache, final int n, final V v, final ParameterRunnable<K> parameterRunnable, final ParameterRunnable<IOException> parameterRunnable2) {
        return new Wrapper<K, V>(cache){
            private final Queue<K> iLoadQueue;
            private Timer iTimer;
            private TimerTask iNextBatch;
            {
                super(cache3);
                this.iLoadQueue = new LinkedList();
                this.iTimer = new Timer("Cache Timer", true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V get(K k) {
                Entry entry = cache.getIfPresent(k);
                if (entry != null) {
                    return entry.getValue();
                }
                Queue queue = this.iLoadQueue;
                synchronized (queue) {
                    this.iLoadQueue.remove(k);
                    this.iLoadQueue.offer(k);
                    while (this.iLoadQueue.size() > cache.getElementLimit()) {
                        this.iLoadQueue.poll();
                    }
                    if (this.iNextBatch == null) {
                        this.iNextBatch = new TimerTask(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                LinkedList linkedList;
                                Queue queue = iLoadQueue;
                                synchronized (queue) {
                                    linkedList = new LinkedList(iLoadQueue);
                                    iLoadQueue.clear();
                                    iNextBatch = null;
                                }
                                for (Object e : linkedList) {
                                    try {
                                        Thread.yield();
                                        cache.get(e);
                                        if (parameterRunnable == null) continue;
                                        parameterRunnable.run(e);
                                    }
                                    catch (IOException iOException) {
                                        if (parameterRunnable2 == null) continue;
                                        parameterRunnable2.run(iOException);
                                    }
                                }
                            }
                        };
                        this.iTimer.schedule(this.iNextBatch, n);
                    }
                }
                return v;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.fChangeLock;
        synchronized (object) {
            this.fData.clear();
            this.fRecentlyUsed.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(K k) {
        Object object = this.fChangeLock;
        synchronized (object) {
            Entry entry = this.fData.remove(k);
            if (entry != null) {
                this.fRecentlyUsed.remove(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadIfPresent(K k) throws IOException {
        Object object = this.fChangeLock;
        synchronized (object) {
            if (this.isPresent(k)) {
                this.flush(k);
                this.get(k);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(K k, V v) {
        Object object = this.fChangeLock;
        synchronized (object) {
            this.fData.put(k, new Entry(k, v));
        }
    }

    public V get(K k) throws IOException {
        return this.get(k, this.fLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V get(K k, Loader<K, V> loader) throws IOException {
        Entry entry;
        Object object = this.fChangeLock;
        synchronized (object) {
            entry = this.fData.get(k);
        }
        if (entry == null) {
            entry = new Entry(k, loader.load(k));
            object = this.fChangeLock;
            synchronized (object) {
                if (this.fData.size() == this.fElementLimit) {
                    this.fData.remove(this.fRecentlyUsed.getLeastRecentlyUsed().getKey());
                }
                this.fData.put(k, entry);
            }
        }
        this.fRecentlyUsed.add(entry);
        return entry.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPresent(K k) {
        Object object = this.fChangeLock;
        synchronized (object) {
            return this.fData.keySet().contains(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry getIfPresent(K k) {
        Object object = this.fChangeLock;
        synchronized (object) {
            if (this.isPresent(k)) {
                return this.fData.get(k);
            }
            return null;
        }
    }

    public int getElementLimit() {
        return this.fElementLimit;
    }

    private static class Wrapper<K, V>
    extends Cache<K, V> {
        private final Cache<K, V> fWrappedCache;

        public Wrapper(Cache<K, V> cache) {
            this.fWrappedCache = cache;
        }

        @Override
        public void flush() {
            this.fWrappedCache.flush();
        }

        @Override
        public void flush(K k) {
            this.fWrappedCache.flush(k);
        }

        @Override
        public boolean isPresent(K k) {
            return this.fWrappedCache.isPresent(k);
        }

        @Override
        protected Entry getIfPresent(K k) {
            return this.fWrappedCache.getIfPresent(k);
        }

        @Override
        public int getElementLimit() {
            return this.fWrappedCache.getElementLimit();
        }

        @Override
        public void reloadIfPresent(K k) throws IOException {
            this.fWrappedCache.reloadIfPresent(k);
        }
    }

    protected class Entry {
        private K iKey;
        private V iValue;

        Entry(K k, V v) {
            this.iKey = k;
            this.iValue = v;
        }

        K getKey() {
            return this.iKey;
        }

        V getValue() {
            return this.iValue;
        }

        public int hashCode() {
            return this.iKey.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof Entry && ((Entry)object).iKey.equals(this.iKey);
        }
    }

    public static interface Loader<K, V> {
        public V load(K var1) throws IOException;
    }

    public static enum FileCacheStyle {
        EXPLICIT_FLUSH,
        FLUSH_PARENTS_RECURSIVELY;

    }
}

